#ifndef _MBMENU_H_
#define _MBMENU_H_

/*

   Copyright 2002 Matthew Allum

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
*/

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <signal.h>
#include <sys/wait.h>
/*#include <setjmp.h>*/
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#ifdef USE_XFT
#include <X11/Xft/Xft.h>
#endif
#include <X11/xpm.h>
#include <X11/Xresource.h>
#include <X11/extensions/shape.h>

#include "pngloader.h"

#define MAX(x,y) ((x>y)?(x):(y))

#ifdef DEBUG
#define MENUDBG(txt, args... ) fprintf(stderr, "MENU DEBUG: " txt , ##args )
#else
#define MENUDBG(txt, args... ) /* nothing */
#endif

#define WPAD 3  /* Window padding */
#define RECENT_MAX 3

#define SCROLL_BUTT_H 10

#define WBW(a) ((a)->border_width) 	/* Window border width */

#define MBMENU_NO_ITEM_SORT (1<<1)
#define MBMENU_TRANS_HACK   (1<<2)  
#define MBMENU_NO_BEVEL     (1<<3)  

typedef struct _menu
{
#ifdef USE_XFT
  XftDraw *xftdraw;
  int expose_cnt;
#endif

  char *title;
  struct _menuitem *items;
  struct _menuitem *active_item;
  struct _menuitem *too_big_start_item;
  struct _menuitem *too_big_end_item;
  struct _menuitem *parent_item;
  
  int x;
  int y;
  int width;
  int height;
  int depth;
  
  Window   win;
  Pixmap mask;
  GC mask_gc;
  Bool too_big;
   
} Menu;

typedef struct _menuitem
{
  char *title;
  void (* cb)( struct _menuitem *item );
  void *cb_data;
  char *info;
  char *icon_fn;
  
  Pixmap icon;
  Pixmap icon_mask;
  int    icon_w;
  int    icon_h;
  
  Menu *child;
  struct _menuitem *next_item;
  
  int y;
  int h;
   
   
} MenuItem;


typedef struct _mbmemu
{
   Display *dpy;
   Window root;
   int screen;
   
#ifdef USE_XFT
   XftFont *xftfont;
   XftColor fg_xftcol;
   XftColor bg_xftcol;
   XftColor hl_xftcol;
#else
   XFontStruct* font;
#endif
   XColor   fg_xcol;
   XColor   bg_xcol;
   XColor   hl_xcol;
   GC gc;

  int options;

  int border_width;		/* X window border */
  int inner_border_width; 	/* Non X border */
  XColor border_cols[3];
  
  int icon_support;  /* 0 - no icons, else icon size after scale */
  
  int rounded;
  
  Pixmap undef_item_sub_icon, undef_item_sub_icon_mask;
  Pixmap undef_item_icon, undef_item_icon_mask;
  
  Pixmap arrow_icon, arrow_mask; 
  Pixmap bg_pixmap, bg_pixmap_mask;

  struct _menu *rootmenu;
  Bool xmenu_is_active;
  struct _menu *active[10];
  int active_depth;


} MBmenu;

MBmenu *
mbmenu_new(Display *dpy,
	   char *fontname,
	   char *fgcoldef,
	   char *bgcoldef,
	   char *hlcoldef,
	   int border_width,
	   int icon_size,
	   char *default_icon,
	   char *default_sub_icon,
	   char *bg_filename,
	   int options
	   );

void
mbmenu_add_item_to_menu(MBmenu *mb, Menu *menu, 
			char *title, char *icon, char *info,
			void (* cmd)( MenuItem *item ),
			void *cb_data);

Menu *
mbmenu_add_path(MBmenu *mb, char *path, char *icon);

void
mbmenu_remove_menu(MBmenu *mb, Menu *menu);

void 				/* TO IMPLEMENT */
mbmenu_remove_menu_item(MBmenu *mb, Menu *menu, MenuItem *item);


void
mbmenu_create_xmenu(MBmenu *mb, Menu *menu, int x, int y);

void
mbmenu_xmenu_paint(MBmenu *mb, Menu *menu);

void
mbmenu_xmenu_show(MBmenu *mb, Menu *menu);

void
mbmenu_activate(MBmenu *mb, int x, int y);

void 
mbmenu_deactivate(MBmenu *mb);

void
mbmenu_handle_xevent(MBmenu *mb, XEvent *an_event);

void
mbmenu_set_bgcol(MBmenu *mb, char *col);

void
mbmenu_dump(MBmenu *mb, Menu *menu);

void
mbmenu_free(MBmenu *mb);

Bool
mbmenu_is_active(MBmenu *mb);

#endif
