{
//*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
//*-*
//*-*  This program creates :
//*-*    - one-dimensional histograms of each type
//*-*    - two-dimensional histogram of each type
//*-*    - a profile histogram
//*-*    - a memory-resident ntuple
//*-*
//*-*  These objects are filled with some random numbers and saved on a file.
//*-*
//*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*

gROOT->Reset();

// Create a new canvas.
c01 = new TCanvas("c01","1-D Histograms",250,60,700,500);
c01->Divide(3,2);
c02 = new TCanvas("c02","2-D Histograms",300,110,700,500);
c02->Divide(3,2);

c1 = new TCanvas("c1","Dynamic Filling Example",200,10,700,500);
c1->SetFillColor(42);
c1->GetFrame()->SetFillColor(21);
c1->GetFrame()->SetBorderSize(6);
c1->GetFrame()->SetBorderMode(-1);
c1->cd(1);

// Create a new ROOT binary machine independent file.
// Note that this file may contain any kind of ROOT objects, histograms,
// pictures, graphics objects, detector geometries, tracks, events, etc..
// This file is now becoming the current directory.

TFile *hfile = (TFile*)gROOT->FindObject("example.root");
if (hfile) hfile->Close();

hfile = new TFile("example.root","RECREATE","Demo ROOT file with histograms");

// Create some histograms, a profile histogram and an ntuple
hpx1   = new TH1F("hpx","This is the px distribution",100,-4,4);
hpx2   = new TH1F("h101","This is the px distribution",100,-3,3);
hpxpy  = new TH2F("hpxpy","py vs px",40,-4,4,30,-3,3);
hprof  = new TProfile("hprof","Profile of pz versus px",100,-4,4,0,20);
ntuple = new TNtuple("ntuple","Demo ntuple","px:py:pz:random:i");

// Put same histograms of different types in a subdirectory
hfile->mkdir("h1dir");
hfile->mkdir("h2dir");

// Create a histogram of each type
hfile->cd("h1dir");
h1c = new TH1C("h1c","Byte per channel",60,-3,3);
h1d = new TH1D("h1d","Double per channel",60,-3,3);
h1f = new TH1F("h1f","Float per channel",60,-3,3);
h1i = new TH1I("h1i","Integer per channel",60,-3,3);
h1s = new TH1S("h1s","Short Integer per channel",60,-3,3);

hfile->cd("h2dir");
h2c = new TH2C("h2c","Byte per channel",30,-3,3,20,-2,2);
h2d = new TH2D("h2d","Double per channel",30,-3,3,20,-2,2);
h2f = new TH2F("h2f","Float per channel",30,-3,3,20,-2,2);
h2i = new TH2I("h2i","Integer per channel",30,-3,3,20,-2,2);
h2s = new TH2S("h2s","Short Integer per channel",30,-3,3,20,-2,2);

//  Set canvas/frame attributes (save old attributes)
  hpx1->SetFillColor(48);
  hpx2->SetFillColor(48);

  gBenchmark->Start("hsimple");

// Fill histograms randomly
  gRandom->SetSeed();
  Float_t px, py, pz;
  const Int_t kUPDATE = 1000;
  for (Int_t i = 0; i < 25000; i++) {
     gRandom->Rannor(px,py);
     pz = px*px + py*py;
     Float_t random = gRandom->Rndm(1);
     hpx1->Fill(px);
     hpx2->Fill(px);
     hpxpy->Fill(px,py);
     hprof->Fill(px,pz);
     ntuple->Fill(px,py,pz,random,i);

     h1c->Fill(px);
     h1d->Fill(px+0.2);
     h1f->Fill(px-0.2);
     h1i->Fill(px+0.4);
     h1s->Fill(px-0.4);

     h2c->Fill(px,py);
     h2d->Fill(px+0.2,py+0.2);
     h2f->Fill(px+0.4,py-0.2);
     h2i->Fill(px-0.2,py+0.4);
     h2s->Fill(px-0.4,py-0.4);

     if (i && (i%kUPDATE) == 0) {
        if (i == kUPDATE) hpx1->Draw();
        c1->Modified();
        c1->Update();
        if (gSystem->ProcessEvents())
           break;
     }
  }
  gBenchmark->Show("hsimple");

// Save all objects in this file
  hpx1->SetFillColor(0);
  hfile->Write();
  hpx1->SetFillColor(48);
  c1->Modified();

// Show the 1-D and 2-D histograms
c01->cd(1);
h1c->Draw();
c01->cd(2);
h1d->Draw();
c01->cd(3);
h1f->Draw();
c01->cd(4);
h1i->Draw();
c01->cd(5);
h1s->Draw();

c02->cd(1);
h2c->Draw("BOX");
c02->cd(2);
h2d->Draw("COL");
c02->cd(3);
h2f->Draw("LEGO");
c02->cd(4);
h2i->Draw("SURF");
c02->cd(5);
h2s->Draw("COLZ");
  
// Note that the file is automatically close when application terminates
// or when the file destructor is called.
}
