      DOUBLE PRECISION FUNCTION XMNARGUS(wpar,npar,dpx,dexpmx)
C
C------------------------------------------------------------------------------
C     Interface to ARGUS background function
C     Does the function normalization if requested.
C------------------------------------------------------------------------------
C
      IMPLICIT NONE
C
      INTEGER MSTEP
      PARAMETER (MSTEP = 100)
C
#include "mnpar.inc"
#include "mnfit.inc"
#include "mnusr.inc"
C
      double precision wpar(*),dpx,dexpmx
      integer npar
C
      DOUBLE PRECISION DSIMPS
      DOUBLE PRECISION XMNARGUS2,WMNARGUSI,WPARI(MFNPAR),WARVAL(0:MSTEP)
     + ,WXLO,WXHI,xx,dxx
      INTEGER I,ii
      LOGICAL QARNEW,qfarea_lst
C
      SAVE WPARI,WMNARGUSI,qfarea_lst
      DATA WPARI/MFNPAR*-1.0D+31/
      data qfarea_lst/.false./
C
      IF(QFAREA) THEN
C
C         See if any parameters have changed
C
          QARNEW = .FALSE.
          DO I=2,NPAR
              IF(WPAR(I).NE.WPARI(I)) THEN
                  QARNEW = .TRUE.
*ICB                  write(6,'('' ARGUS parameter'',I4,'' changed ''
*ICB     +             ,2(1pg18.10))') i,wpari(i),wpar(i)
                  WPARI(I) = WPAR(I)
              ENDIF
          ENDDO
C
C         If they have changed then recalculate the AREA
C
          IF(QARNEW .or. .not.qfarea_lst) THEN
              WXLO     = 0.0d0
              WXHI     = wpari(3)
              WPARI(1) = 1.0D0
              DXX = (WXHI - WXLO) / DFLOAT(MSTEP)
              XX  = WXLO - DXX
              DO I=0,MSTEP
                  XX = XX + DXX
                  WARVAL(I) = XMNARGUS2(WPARI(1),XX,DEXPMX)
              ENDDO
              WMNARGUSI = DSIMPS(WARVAL(0), WXLO, WXHI, MSTEP)
*ICB              write(6,'('' ARGUS parameters: '',4(1pg12.5))')
*ICB     +         (wpari(ii),ii=1,4)
*ICB              write(6,'('' ARGUS integral: '',1pg12.5)') wmnargusi
          ENDIF
      ELSE
          WMNARGUSI = 1.0D0
      ENDIF
      qfarea_lst = qfarea
C
      XMNARGUS = XMNARGUS2(WPAR,DPX,DEXPMX) / WMNARGUSI
C
      END
