      SUBROUTINE MN_CDS(IDELIM)
C
C     STORES A SERIES OF DATA POINTS IN A FILE
C
#include "mnpar.inc"
#include "mndat.inc"
#include "mninf.inc"
#include "mncwn.inc"
#include "mncmd.inc"
#include "mnlun.inc"
C
      CHARACTER*80 FILNAM
      CHARACTER*133 TTMP
      LOGICAL QERRL,QERRH,QRNGE,QZERO
      REAL RVAL(10)
      integer ltmp,lent
      integer lnblnk
      external lnblnk
C
      LUN = 0
      CALL MN_FIL(-3,LUN,FILNAM,IDELIM,IERR)
      IF(IERR.NE.0) GOTO 9000
C
1000  CONTINUE
      CALL WAITYQ('Give histogram number: ')
      CALL MN_HRN(IDA1,IDA2,IDB1,IDB2,IDELIM,NNID)
      IF(NNID.LE.0) GOTO 8000
      QZERO = .FALSE.
      IF(NNID.EQ.1 .AND. IDA1.EQ.0) QZERO = .TRUE.
      QRNGE = IDA1.NE.IDA1 .OR. IDB1.NE.IDB2
C
C     If storing single plots, check that they exist
C
      IF(.NOT.QZERO .AND. .NOT.QRNGE) THEN
          CALL MN_HGT(IDA1,IDB1,NH)
          IF(NH.LE.0) THEN
              WRITE(TXTERR,'(''Plot'',I7,I4,'' does not exist'')'
     +         ,IOSTAT=IOERR) IDA1,IDB1
              CALL MN_ERR('MN_CDS',TXTERR)
              GOTO 8000
          ENDIF
      ENDIF
C
      DO 3000 NH=1,NDHIS
          IF(IDPTRH(NH).LE.0 .OR. IDPTRD(NH).LE.0) GOTO 3000
          IDA = IDIDA(NH)
          IDB = IDIDB(NH)
          IF((NNID.EQ.1 .AND. IDA1.EQ.0) .OR.
     +       (NNID.EQ.2 .AND. IDA1.EQ.0 .AND.
     +        IDB.GE.IDB1 .AND. IDB.LE.IDB2) .OR.
     1       (IDA.GE.IDA1 .AND. IDA.LE.IDA2 .AND.
     1        IDB.GE.IDB1 .AND. IDB.LE.IDB2)) THEN
              CALL MN_HGT(IDA,IDB,NH)
              IF(NH.LE.0) THEN
                  WRITE(TXTERR,'(''Histogram'',I7,I4
     1             ,'' does not exist'')') IDA,IDB
                  CALL MN_ERR('MN_CDS',TXTERR)
                  GOTO 8000
              ENDIF
C
              IF(NDIM.GT.1 .OR. NDIM.LT.-10) THEN
                  IF(NDIM.GT.1) THEN
                      WRITE(TXTERR,'(''Plot'',I7,I4
     +                 ,'' is not 1-dimensional.''
     +                 ,'' It will not be stored.'')'
     +                 ,IOSTAT=IOERR) IDA,IDB
                  ELSE
                      WRITE(TXTERR,'(''Ntuple'',I7,I4
     +                 ,'' has more than 10 variables.''
     +                 ,'' It will not be stored.'')'
     +                 ,IOSTAT=IOERR) IDA,IDB
                  ENDIF
                  CALL MN_ERR('MN_CDS',TXTERR)
                  GOTO 3000
              ENDIF
C
              IF(.NOT.QRFILE .AND. NPNT.GT.1000) THEN
                  IF(IDELIM.EQ.0) THEN
                      ISTR = ISTRNQ(.TRUE.,TTMP,NCHAR)
                  ENDIF
                  WRITE(TXTMES,'('' Plot'',I7,I4
     +             ,'' has more than 1000 points'')')
                  CALL MN_MES(LUNTTO,'ME',TXTMES)
                  TXTMES =
     +             'Hit <CR> to store, q to quit, any character to skip'
                  CALL MN_CRT(0,TXTMES,IERR)
                  IF(IDELIM.EQ.0 .AND. NCHAR.GT.0) THEN
                      CALL QUOTYQ(TTMP(:NCHAR))
                  ENDIF
                  IF(IERR.NE.0) GOTO 3000
              ENDIF
C
              CALL AMNOFF(NDIM,NWPPT,NOFF,NOFFL,NOFFH,QERRL,QERRH)
              IF(NDIM.GT.0) THEN
                  DX = 0.5 * (ADHI(1) - ADLO(1)) / FLOAT(IDBIN(1))
              ENDIF
C
              WRITE(LUN,'('' ID '',I7,I4)') IDA,IDB
              WRITE(LUN,'('' TITLE '',A72)') TDTIT(NH)(1:72)
              IF(IABS(NDIM).EQ.1) THEN
                  WRITE(LUN,'('' LIMIT '',G15.6,1X,G15.6)')
     +             ADLO(1),ADHI(1)
                  IF(QERRH) THEN
                      WRITE(LUN,'('' ORDER X Y DNX DNY DPX DPY'')')
                  ELSE IF(QERRL) THEN
                      WRITE(LUN,'('' ORDER X Y DX DY'')')
                  ELSE
                      WRITE(LUN,'('' ORDER X Y'')')
                  ENDIF
              ELSE
                  ND = IABS(NDIM)
                  ttmp = ' NTUPLE'
                  write(ttmp(9:),'(I3)') nd
                  ltmp = 11
                  do i=1,nd
                    lent = lnblnk(tdnam(i,nh))
                    write(ttmp(ltmp+1:),'(1x,a)') tdnam(i,nh)(:lent)
                    ltmp = ltmp + lent + 1
                  enddo
                  write(lun,'(1x,A)') ttmp(:ltmp)
*ICB                  WRITE(LUN,'('' NTUPLE'',I4,1X,10(A,1X))')
*ICB     +             ND,(TDNAM(II,NH),II=1,ND)
              ENDIF
              WRITE(LUN,'('' DATA'')')
C
C             Initialize the Ntuple reading
C
              IF(NDIM.LT.-1) THEN
                  nvcwn = 0
                  CALL M_NTPPNT(IDA,IDB,0,IERR,RVAL)
                  IF(IERR.NE.0) THEN
                      WRITE(LUN,'('' END'')')
                      GOTO 3000
                  ENDIF
              ENDIF
C
              DO 2900 I=1,NPNT
                  NPTR = NPTRD + NWPPT*(I-1) - 1
                  IF(IABS(NDIM).EQ.1) THEN
                      IF(NDIM.GT.0) THEN
                          X = ADLO(1) + 2.0*FLOAT(I-1)*DX + DX
                          DXL = DX
                          DXH = DX
                      ELSE
                          X = RDAT(NPTR + 1)
                          IF(QERRL) DXL = RDAT(NPTR + NOFF + 1)
                          IF(QERRH) DXH = RDAT(NPTR + NOFFL + 1)
                      ENDIF
                      Y = RDAT(NPTR + NOFF)
                      IF(QERRL) DYL = RDAT(NPTR + NOFFL)
                      IF(QERRH) DYH = RDAT(NPTR + NOFFH)
C
                      IF(QERRH) THEN
                          WRITE(LUN,'(1X,6(1PG13.6,1X))') X,Y,DXL,DYL
     +                     ,DXH,DYH
                      ELSE IF(QERRL) THEN
                          WRITE(LUN,'(1X,6(1PG13.6,1X))') X,Y,DXL,DYL
                      ELSE
                          WRITE(LUN,'(1X,6(1PG13.6,1X))') X,Y
                      ENDIF
                  ELSE
                      CALL M_NTPPNT(IDA,IDB,I,IERR,RVAL)
                      IF(IERR.NE.0) THEN
                          WRITE(LUN,'('' END'')')
                          GOTO 3000
                      ENDIF
                      WRITE(LUN,'(10(1X,1PG12.5))') (RVAL(II),II=1,ND)
                  ENDIF
 2900         CONTINUE
C
              WRITE(LUN,'('' END'')')
          ENDIF
 3000 CONTINUE
      IF(IDELIM.EQ.0) GOTO 1000
C
8000  CONTINUE
      CLOSE(UNIT=LUN)
      CALL CLEO_FRELUN(LUN,'MN_FIL')
C
9000  CONTINUE
      END
