      SUBROUTINE MN_ERC (IDA,IDB,NMODE,err)
C
C     SUBROUTINE TO CHANGE THE ERRORS ON A HISTOGRAM
C     NMODE = 0 MEANS 0 ERRORS
C     NMODE = 1 MEANS ERRORS ARE SQAURE ROOT OF THE NUMBER OF ENTRIES
C     NMODE = 2 SAME AS 1, EXCEPT ERROR ON 0 IS 1
C     NMODE = 3 means set all errors to value given
C
      implicit none
*
#include "mnpar.inc"
#include "mndat.inc"
#include "mninf.inc"
#include "mnlun.inc"
C
      integer ida,idb,nmode
      real err
*
      integer nh,nerr,ii,nd,nwtot
     + ,nh2,nwh2,nwppt2,nwrd2,ntmod2,nptrh2,nptrd2,nptr2
     + ,noff2,noffl2,noffh2
     + ,nhdat2,nhtim2,nsdat2,nstim2
      real edent2,edlo2,edhi2,x,dx,ee,dee
      LOGICAL QERRL,QERRH
*
      real     amne,amnp,amndpn
      external amne,amnp,amndpn
C
      CALL MN_HGT(IDA,IDB,NH)
      IF(NH.LE.0) THEN
          WRITE(TXTERR,'(''Histogram'',I7,I4
     1     ,'' does not exist'')') IDA,IDB
          CALL MN_ERR('MN_ERC',TXTERR)
          GOTO 9000
      ENDIF
      IF(NDIM.LT.-1) THEN
          CALL MN_ERR('MN_ERC','There are no errors for an Ntuple')
          GOTO 9000
      ENDIF
C
C     BOOK THE NEW HISTOGRAM
C
      IF(NDIM.LT.0) THEN
          NWPPT2 = 2*(IABS(NDIM)+1)
      ELSE
          IF(NMODE.EQ.-1) THEN
              NWPPT2 = 1
          ELSE
              NWPPT2 = 2
          ENDIF
      ENDIF
      CALL MN_UOF(RDAT(NPTRH),ACONT)
C
      NWRD2  = NWPPT2 * NPNT
      NBPPT  = 32
      NTMOD2 = NTMODE
      CALL MN_HNW(IDA,IDB,NDIM,NWRD2,NH2,NPTRH2,NPTRD2,NWH2
     + ,NBPPT,NTMOD2)
      IF(NH2.LE.0) GOTO 9000
C
C     CALL AMNOFF FOR NEW PLOT
C
      CALL AMNOFF(NDIM,NWPPT2,NOFF2,NOFFL2,NOFFH2,QERRL,QERRH)
C
C     SET THE POINTERS TO THE FIRST PLOT POSITIVE AGAIN UNTIL THE
C     END OF THE SUBROUTINE
C
      IDPTRH(NH) = IABS(IDPTRH(NH))
      IDPTRD(NH) = IABS(IDPTRD(NH))
C
      EDENT2 = 0.0
      EDLO2  = 1.0E+30
      EDHI2  = -1.0E+30
      NERR   = 0
      DO 6300 II=1,NPNT
          NPTR2 = NPTRD2 + NWPPT2*(II-1) - 1
C
          EE = AMNE(II,NH,NERR)
          IF(NMODE.LE.0) THEN
              DEE = 0.0
          elseif(nmode.eq.3) then
              dee = err
          ELSE
              DEE = SQRT(ABS(EE))
              IF(NMODE.EQ.2 .AND. EE.EQ.0.0) DEE = 1.0
          ENDIF
C
          IF(NDIM.LT.0) THEN
              DO 6200 ND=1,IABS(NDIM)
                  X  = AMNP(II,NH,ND,1,NERR)
                  DX = AMNDPN(II,NH,ND,NERR)
                  RDAT(NPTR2 + ND)      = X
                  RDAT(NPTR2 + NOFF2 + ND) = DX
6200          CONTINUE
          ENDIF
C
          RDAT(NPTR2 + NOFF2)  = EE
          IF(NMODE.NE.-1) THEN
              RDAT(NPTR2 + NOFFL2) = DEE
          ENDIF
C
          EDLO2  = AMIN1(EDLO2,EE-DEE)
          EDHI2  = AMAX1(EDHI2,EE+DEE)
          EDENT2 = EDENT2 + EE
 6300 CONTINUE
C
C     NOW SET THE POINTERS NEGATIVE AGAIN AND UPDATE THE HEADER
C
      IDPTRH(NH) = -IABS(IDPTRH(NH))
      IDPTRD(NH) = -IABS(IDPTRD(NH))
C
C     Give the new plot the same date/time as the old one as only the
C     errors have changed
C
      NHDAT2 = NHDATE
      NHTIM2 = NHTIME
      NSDAT2 = NSDATE
      NSTIM2 = NSTIME
C
      NWDAT = NPNT * NWPPT2
      NWTOT = NWH2 + NWDAT
      CALL MN_HDU(RDAT(NPTRH2),NWTOT,NWH2,NWDAT,IDA,IDB
     1 ,NDIM,NWPPT2,NPNT,NHDAT2,NHTIM2,NSDAT2,NSTIM2,NTMOD2
     + ,EDENT2,EDLO2,EDHI2,IDBIN,ADLO,ADHI,NBPPT,ACONT)
      CALL MN_PTU(NH2,NWTOT,IDA,IDB,NPTRH2,NPTRD2,TDTIT(NH)
     1 ,TDFIL(NH),' ',TDNAM(1,NH))
      CALL MN_MSU(IDA,IDB,NDIM,NWH2,NH2)
C
9000  CONTINUE
      END
