      SUBROUTINE MN_HBN(IDA,IDB,IERR)
C
C     MAKES AN HBOOK HISTOGRAM FROM AN MN_FIT HISTOGRAM
C
      IMPLICIT NONE
C
#include "mnpar.inc"
#include "mndat.inc"
#include "mninf.inc"
#include "mnlun.inc"
C
      INTEGER MPNTMX
      PARAMETER (MPNTMX=50 000)
C     COMMON/MNSCR/BUFDAT(MPNTMX),BUFERR(MPNTMX)
#include "mnscr.inc"
      REAL BUFDAT(MPNTMX),BUFERR(MPNTMX)
      EQUIVALENCE(SCRATCH(1),BUFDAT(1))
      EQUIVALENCE(SCRATCH(MPNTMX+1),BUFERR(1))
C
      INTEGER IDA,IDB,IERR
C
      CHARACTER*80 TEXT
      CHARACTER*32 TAGS_NOERR(2),TAGS_ERR(4),TAGS_ASYM(6)
C
      INTEGER IDH,II,JJ,NH,NPTR,NPPT,NOFF,NOFFL,NOFFH
      REAL X,Y,DX,DY,EE
      LOGICAL QERRL,QERRH
      LOGICAL HEXIST
C
      DATA TAGS_NOERR/'X','Y'/
      DATA TAGS_ERR/  'X','Y','DX','DY'/
      DATA TAGS_ASYM/ 'X','Y','DNX','DNY','DPX','DPY'/
C
      IERR = 0
      CALL MN_HGT(IDA,IDB,NH)
      IF(NH.LE.0) THEN
          WRITE(TXTERR,'(''Histogram'',I7,I4
     1     ,'' does not exist'')') IDA,IDB
          CALL MN_ERR('MN_HBN',TXTERR)
          IERR = 1
          GOTO 9000
      ENDIF
C
      IF(NDIM.LT.0) THEN
          IF(NWDAT.LE.0) THEN
              WRITE(TXTERR,'('' Plot'',I7,I4,'', I can only store''
     +         ,'' scatter plots or Ntuples that are in memory'')')
     +         IDA,IDB
              CALL M_EMSG('MN_HBN',TXTERR)
              IERR = 2
              GOTO 9000
          ENDIF
      ELSEIF(NDIM.GT.2) THEN
          WRITE(TXTERR,'('' Plot'',I7,I4,'', I can only make HBOOK''
     +     ,'' histograms of 1 or 2 dimensional plots'')') IDA,IDB
          CALL M_EMSG('MN_HBN',TXTERR)
          IERR = 2
          GOTO 9000
      ENDIF
C
      CALL AMNOFF(NDIM,NWPPT,NOFF,NOFFL,NOFFH,QERRL,QERRH)
C
      TEXT = TDTIT(NH)
      IDH = IDA
      IF(HEXIST(IDH) .AND. NWDAT.GT.0) THEN
          WRITE(TXTMES,'('' HBOOK histogram'',I8
     1     ,'' will be overwritten'')') IDH
          CALL MN_MES(LUNTTO,'ME',TXTMES)
          CALL HDELET(IDH)
      ENDIF
      IF(NDIM.LT.-2) THEN
          WRITE(TXTMES,'('' Plot'',I7,I4,'' will be stored with''
     +     ,'' HBOOK id'',I8,'' in top level directory'')')
     +     IDA,IDB,IDH
      ELSEIF(NDIM.EQ.-1) THEN
          WRITE(TXTMES,'('' Plot'',I7,I4
     +     ,'' will be stored as an Ntuple with''
     +     ,'' HBOOK id'',I8)') IDA,IDB,IDH
      ELSE
          WRITE(TXTMES,'('' Plot'',I7,I4,'' will be stored with''
     +     ,'' HBOOK id'',I8)') IDA,IDB,IDH
      ENDIF
      CALL MN_MES(LUNTTO,'ME',TXTMES)
      IF(NDIM.EQ.1) THEN
          CALL HBOOK1(IDH,TEXT,IDBIN(1),ADLO(1),ADHI(1),0.0)
          IF(QERRL) CALL HBARX(IDH)
      ELSEIF(NDIM.EQ.2) THEN
          CALL HBOOK2(IDH,TEXT,IDBIN(1),ADLO(1),ADHI(1)
     1     ,IDBIN(2),ADLO(2),ADHI(2),0.0)
      ELSEIF(NDIM.EQ.-1 .AND. NWPPT.EQ.2) THEN
          CALL HBOOKN(IDH,TEXT,2,' ',10000,TAGS_NOERR)
      ELSEIF(NDIM.EQ.-1 .AND. NWPPT.EQ.4) THEN
          CALL HBOOKN(IDH,TEXT,4,' ',10000,TAGS_ERR)
      ELSEIF(NDIM.EQ.-1 .AND. NWPPT.EQ.6) THEN
          CALL HBOOKN(IDH,TEXT,6,' ',10000,TAGS_ASYM)
      ELSEIF(NDIM.EQ.-2) THEN
          CALL HBOOKN(IDH,TEXT,2,' ',10000,TAGS_NOERR)
      ELSEIF(NDIM.LT.-2) THEN
          CALL M_NTPSTO(IDA, IDB, NH, IERR)
      ENDIF
C
      IF(NDIM.EQ.1) THEN
          NPPT = MAX0(NPNT,MPNTMX)
          DO 2000 II=1,NPPT
              NPTR = NPTRD + NWPPT*(II-1) - 1
              BUFDAT(II) = RDAT(NPTR + NOFF)
              IF(QERRL) BUFERR(II) = RDAT(NPTR + NOFFL)
 2000     CONTINUE
          CALL HPAK(IDH,BUFDAT)
          IF(QERRL) CALL HPAKE(IDH,BUFERR)
      ELSEIF(NDIM.EQ.2) THEN
          NPTR = NPTRD - NWPPT - 1
          IF(IDBIN(1).GT.0) DX = (ADHI(1) - ADLO(1)) / FLOAT(IDBIN(1))
          IF(IDBIN(2).GT.0) DY = (ADHI(2) - ADLO(2)) / FLOAT(IDBIN(2))
          DO 3000 JJ=1,IDBIN(2)
              DO 2900 II=1,IDBIN(1)
                  NPTR = NPTR + NWPPT
                  X = ADLO(1) + FLOAT(II-1)*DX + 0.5*DX
                  Y = ADLO(2) + FLOAT(JJ-1)*DY + 0.5*DY
                  EE = RDAT(NPTR + 1)
                  CALL HF2(IDH,X,Y,EE)
2900          CONTINUE
3000      CONTINUE
      ELSEIF(NDIM.EQ.-1) THEN
          NPTR = NPTRD - NWPPT
          DO 4000 II=1,NPNT
              NPTR = NPTR + NWPPT
              CALL UCOPY_r(RDAT(NPTR),BUFDAT(1),NWPPT)
              CALL HFN(IDH,BUFDAT)
 4000     CONTINUE
      ELSEIF(NDIM.EQ.-2) THEN
          NPTR = NPTRD - NWPPT
          DO 5000 II=1,NPNT
              NPTR = NPTR + NWPPT
              CALL UCOPY_r(RDAT(NPTR),BUFDAT(1),NWPPT)
              CALL HFN(IDH,BUFDAT)
 5000     CONTINUE
      ENDIF
C
9000  CONTINUE
      END
