      SUBROUTINE MN_PLI(IDA,IDB)
C
#include "mnpar.inc"
#include "mnfit.inc"
#include "mnfun.inc"
#include "mnhpj.inc"
C
      CHARACTER*255 TXT1,TXT2,TTMP,CONCAT
      CHARACTER*30 TNUMB
      CHARACTER*80 THFIL
      DOUBLE PRECISION FMIN,FEDM,ERRDEF
C
      IF(.NOT.QSTEXT .OR. NSHEAD.EQ.0) RETURN
C
C     FIND OUT WHERE THE HISTOGRAM IS STORED
C
      CALL MN_FGT(IDA,IDB,NH)
      IF(NH.LE.0) RETURN
C
C     Get the fit status
C
      CALL MNSTAT(FMIN,FEDM,ERRDEF,NPARI,NPARX,ISTAT)
      EDM = SNGL(FEDM)
      UP  = SNGL(ERRDEF)
C
      THFIL = TFFIL(NH)
C
C     SET UP SIZES AND POSITIONS
C
      XLEFT = 1.0
      XRIGHT = SIZEU(1) - 1.0
      YTOP  = SIZEU(2)
      SZ1_MN = TSZEU(1)
      SZ2_MN = TSZEU(2)
      DY1_MN = 1.5*SZ1_MN
      DY2_MN = 1.5*SZ2_MN
C
      NCOL  = ICOLU(5)
      THICK = ATHKU(5)
      NFONT = IFNTU(1)
C
      YY = YTOP - 1.5*DY1_MN
      TXT1 = ' '
      IF(NFITTP.EQ.0) THEN
          IF(NHFIT.EQ.1) THEN
              TXT1 = 'MINUIT [v]^2! Fit to Plot'
              NNCHAR = 17
          ELSE
              TXT1 = 'MINUIT [v]^2! Fit to Plots'
              NNCHAR = 18
          ENDIF
      ELSEIF(NFITTP.EQ.1 .OR. NFITTP.EQ.2) THEN
          IF(NHFIT.EQ.1) THEN
              TXT1 = 'MINUIT Likelihood Fit to Plot'
              NNCHAR = 23
          ELSE
              TXT1 = 'MINUIT Likelihood Fit to Plots'
              NNCHAR = 24
          ENDIF
      ENDIF
      CALL MN_TXT(XLEFT,YY,TXT1,SZ1_MN,0.0,-1,NFONT,NCOL,THICK)
      N1 = 1
      TXT1 = ' '
      DO 1000 II=1,NHFIT
          JDA = IDFITA(II)
          JDB = IDFITB(II)
          NCHAR = IFIX(ALOG10(FLOAT(JDA)+0.1)) + 1
          WRITE(TTMP,'(I15)',IOSTAT=IOERR) JDA
          TXT1(N1:N1+NCHAR-1) = TTMP(15-NCHAR+1:15)
          N1 = N1 + NCHAR
          TTMP = TXT1
          TXT1 = TTMP(1:N1-1)//'@&'
          N1 = N1 + 2
          NCHAR = 1
          IF(JDB.NE.0) NCHAR = IFIX(ALOG10(FLOAT(JDB)+0.1)) + 1
          WRITE(TTMP,'(I15)',IOSTAT=IOERR) JDB
          TXT1(N1:N1+NCHAR-1) = TTMP(15-NCHAR+1:15)
          IF(II.NE.NHFIT) TXT1(N1+NCHAR:N1+NCHAR) = ';'
          N1 = N1 + NCHAR + 2
1000  CONTINUE
      XX = XLEFT + FLOAT(NNCHAR)*SZ1_MN
      CALL MN_TXT(XX,YY,TXT1,SZ1_MN,0.0,-1,NFONT,NCOL,THICK)
C
C     IF MORE THAN 1 HISTOGRAM GIVE NUMBER AND TITLE
C     OTHERWISE JUST TITLE
C
      YY = YY - 1.2*DY2_MN
C
      XX = XLEFT
      IF(NHFIT.GT.1) THEN
          TNUMB = 'Plot'
          NCHARA = 1
          IF(IDA.NE.0) NCHARA = IFIX(ALOG10(FLOAT(IDA)+0.1)) + 1
          WRITE(TTMP,'(I15)',IOSTAT=IOERR) IDA
          TNUMB(6:5+NCHARA) = TTMP(15-NCHARA+1:15)
          TTMP = TNUMB
          TNUMB = TTMP(1:5+NCHARA)//'@&'
          NCHARB = 1
          IF(IDB.NE.0) NCHARB = IFIX(ALOG10(FLOAT(IDB)+0.1)) + 1
          WRITE(TTMP,'(I15)',IOSTAT=IOERR) IDB
          TNUMB(8+NCHARA:7+NCHARA+NCHARB) = TTMP(15-NCHARB+1:15)
          TNUMB(8+NCHARA+NCHARB:) = ':'
          CALL MN_TXT(XLEFT,YY,TNUMB,SZ2_MN,0.0,-1,NFONT,NCOL,THICK)
          XX = XX + (6.5+FLOAT(NCHARA+NCHARB))*SZ2_MN
      ENDIF
C
      IF(.NOT.QTUSER) THEN
          TXT1 = TFTIT(NH)
      ELSE
          TXT1 = TITUSR
      ENDIF
      CALL MN_TXT(XX,YY,TXT1,SZ2_MN,0.0,-1,NFONT,NCOL,THICK)
C
C     WRITE OUT THE FIT RESULTS
C
      YY = YY - DY2_MN
C
C     Truncate the filename and convert it to IGTEXT form if necessary
C
      TXT1 = ' '
      CALL M_TFIL(0,NFONT,THFIL,TTMP)
      THFIL = TTMP
      TXT1 = 'File: ' // THFIL
      CALL MN_TXT(XLEFT,YY,TXT1,SZ2_MN,0.0,-1,NFONT,NCOL,THICK)
C
C     YY = YY - DY1_MN
      TXT1 = ' '
      CALL M_TTIM(TXT1,TXT2)
      TTMP = TXT1(1:11) // ' ' // TXT2(1:5)
      CALL MN_TXT(XRIGHT,YY,TTMP,SZ2_MN,0.0,+1,NFONT,NCOL,THICK)
C
C     WRITE OUT AREA UNDER PLOT AND UNDER FUNCTION
C
      YY = YY - DY2_MN
      TXT1 = ' '
      TXT1 = 'Plot Area Total/Fit'
      CALL MN_TXT(XLEFT,YY,TXT1,SZ2_MN,0.0,-1,NFONT,NCOL,THICK)
      WRITE(TTMP,'(1PG13.5)',IOSTAT=IOERR) AHTTOT(NH)
      TXT2 = TTMP
      TXT1 = CONCAT(TXT2,'/')
      WRITE(TTMP,'(1PG13.5)',IOSTAT=IOERR) AHFTOT(NH)
      TXT2 = CONCAT(TXT1,TTMP)
      CALL MN_TXT(XLEFT+15.0*SZ2_MN,YY,TXT2,SZ2_MN,0.0,-1
     + ,NFONT,NCOL,THICK)
C
      YY = YY - DY2_MN
      TXT1 = 'Func Area Total/Fit'
      WRITE(TTMP,'(1PG13.5)',IOSTAT=IOERR) AFTTOT(1,NH)
      CALL MN_TXT(XLEFT,YY,TXT1,SZ2_MN,0.0,-1,NFONT,NCOL,THICK)
      TXT2 = TTMP
      TXT1 = CONCAT(TXT2,'/')
      WRITE(TTMP,'(1PG13.5)',IOSTAT=IOERR) AFFTOT(1,NH)
      TXT2 = CONCAT(TXT1,TTMP)
      CALL MN_TXT(XLEFT+15.0*SZ2_MN,YY,TXT2,SZ2_MN,0.0,-1
     + ,NFONT,NCOL,THICK)
C
C     Write out the fit status and the estimated distance to the minimum
C
      YY = YY + DY2_MN
      WRITE(TXT1,'(''Fit Status'',I3)',IOSTAT=IOERR) ISTAT
      CALL MN_TXT(XRIGHT,YY,TXT1,SZ2_MN,0.0,+1,NFONT,NCOL,THICK)
C
      YY = YY - DY2_MN
      WRITE(TXT1,'(''E.D.M.'',1PG10.3)',IOSTAT=IOERR) EDM
      CALL MN_TXT(XRIGHT,YY,TXT1,SZ2_MN,0.0,+1,NFONT,NCOL,THICK)
C
      YY = YY - 1.2*DY1_MN
C
      IF(NFITTP.EQ.1 .OR. NFITTP.EQ.2) THEN
          TXT1 = ' '
          TXT1 = 'Likelihood ='
          WRITE(TXT1(13:),'(F8.1)',IOSTAT=IOERR) ALIK_MN
          CALL MN_TXT(XLEFT,YY,TXT1,SZ1_MN,0.0,-1,NFONT,NCOL,THICK)
          YY = YY - 1.0*DY1_MN
      ENDIF
C
      TXT1 = ' '
      IF(NFONT.LE.0 .OR. MOD(NFONT,100).EQ.0) THEN
          TXT1 = '[v]^2!=         for     -    d.o.f.,'
      ELSE
          TXT1 = 'Chi**2=         for     -    d.o.f.,'
      ENDIF
      WRITE(TXT1( 8:15),'(F8.1)',IOSTAT=IOERR) CHI2_MN
      WRITE(TXT1(20:23),'(I4)') NPTTOT
      WRITE(TXT1(26:28),'(I3)') NFRE_MN
      CALL MN_TXT(XLEFT,YY,TXT1,SZ1_MN,0.0,-1,NFONT,NCOL,THICK)
      TXT1 = 'C.L.='
      IF(CONLEV.GE.0.01) THEN
          WRITE(TXT1(6:10),'(F5.1)') CONLEV*100.
          TXT1(11:) = '%'
      ELSE
          WRITE(TXT1(6:14),'(G9.3)') CONLEV*100.
          TXT1(15:) = '%'
      ENDIF
      CALL MN_TXT(XRIGHT,YY,TXT1,SZ1_MN,0.0,+1,NFONT,NCOL,THICK)
C
      IF(NHFIT.GT.1) THEN
          YY = YY - DY1_MN
          IF(NFITTP.EQ.0) THEN
              IF(NFONT.LE.0 .OR. MOD(NFONT,100).EQ.0) THEN
                  TXT1 = 'Individual [v]^2!:'
              ELSE
                  TXT1 = 'Individual chi**2:'
              ENDIF
              N1 = 19
              DO II=1,NHFIT
                  WRITE(TXT1(N1:),'(F8.1)',IOSTAT=IOERR) FICHI(II)
                  IF(II.NE.NHFIT) TXT1(N1+8:) = ','
                  N1 = N1 + 9
              ENDDO
          ELSE
              TXT1 = 'Individual Likelihoods:'
              N1 = 24
              DO II=1,NHFIT
                  WRITE(TXT1(N1:),'(F8.1)',IOSTAT=IOERR) FILIK(II)
                  IF(II.NE.NHFIT) TXT1(N1+8:) = ','
                  N1 = N1 + 9
              ENDDO
          ENDIF
          CALL MN_TXT(XLEFT,YY,TXT1,SZ2_MN,0.0,-1,NFONT,NCOL,THICK)
      ENDIF
C
C     Print out if functions are convoluted with a Gaussian
C
      IF(QFCONV) THEN
          YY = YY - DY2_MN
          NVAL = NINT(RFCONV(2))
          WRITE(TXT1,'(
     +     ''Func convoluted with Gaussian of width'',1PG9.3
     +     ,'', # intervals'',I4,'', # sigma'',F3.1)'
     +     ,IOSTAT=IOERR) RFCONV(1),NVAL,RFCONV(3)
          CALL MN_TXT(XLEFT,YY,TXT1,SZ2_MN,0.0,-1,NFONT,NCOL,THICK)
      ENDIF
C
C     Print out if function is integrated across bin
C
      IF(QFINTG) THEN
          YY = YY - DY2_MN
          WRITE(TXT1,'(
     +     ''Func integrated across bin, # intervals'',I4)'
     +     ,IOSTAT=IOERR) NFINTG
          CALL MN_TXT(XLEFT,YY,TXT1,SZ2_MN,0.0,-1,NFONT,NCOL,THICK)
      ENDIF
C
C     IF ERROR DEFINITION IS NOT A CHI**2 CHANGE OF 1 PRINT WHAT IT IS
C
      IF(ABS(UP-1.0).GT.1.0E-3) THEN
          YY = YY - DY2_MN
          IF(NFONT.LE.0 .OR. MOD(NFONT,100).EQ.0) THEN
              TXT1 = 'Errors correspond to a [v]^2! change of'
          ELSE
              TXT1 = 'Errors correspond to a chi**2 change of'
          ENDIF
          WRITE(TXT1(40:),'(F8.3)',IOSTAT=IOERR) UP
          CALL MN_TXT(XLEFT,YY,TXT1,SZ2_MN,0.0,-1,NFONT,NCOL,THICK)
      ENDIF
C
      YY = YY - DY2_MN
      TXT1 = ' '
      TXT1 = 'Errors'
      CALL MN_TXT(XLEFT,YY,TXT1,SZ2_MN,0.0,-1,NFONT,NCOL,THICK)
      TXT1 = ' '
      TXT1 = 'Parabolic                     Minos'
      CALL MN_TXT(XLEFT+23.5*SZ2_MN,YY,TXT1,SZ2_MN,0.0,-1
     + ,NFONT,NCOL,THICK)
      NPART = 0
      N1 = 1
      IF(QSNORM) N1 = 0
      DO 3100 IF=N1,NFUN_MN
          IF(IF.GT.0 .AND. IUSEF(IF).EQ.0) GOTO 3100
          YY = YY - DY2_MN
          TXT1 = ' '
          TXT1 = 'Function   :'
          WRITE(TXT1( 9:11),'(I3)') IF
          IF(IF.GT.0) THEN
              NPARF = IPARF(IF)
              TXT1(14:) = TUSEF(IF)
          ELSE
              NPARF = 1
              TXT1(14:) = 'Overall Normalization'
          ENDIF
          CALL MN_TXT(XLEFT,YY,TXT1,SZ2_MN,0.0,-1,NFONT,NCOL,THICK)
C
C         Print out the parameter values and their errors.
C         Label those parameters which are fixed and those that are
C         constrained.
C
          DO 3050 II=1,NPARF
              YY = YY - DY2_MN
              NPART = NPART + 1
              IF(IF.GT.0) THEN
                  TXT1 = TPARF(II,IF)
              ELSE
                  TXT1 = 'NORM00'
              ENDIF
              CALL MN_TXT(XLEFT,YY,TXT1,SZ2_MN,0.0,-1,NFONT,NCOL,THICK)
              IF((IF.GT.0 .AND. ISFPAR(II,IF).LE.0) .OR.
     +           (IF.EQ.0 .AND. ISF00.LE.0)) THEN
                  IF(JCNSTX(NPART).EQ.0) THEN
                      IF(NFONT.LE.0 .OR. MOD(NFONT,100).EQ.0) THEN
                          TXT1 = '[*]'
                      ELSE
                          TXT1 = '*'
                      ENDIF
                  ELSE
                      IF(NFONT.LE.0 .OR. MOD(NFONT,100).EQ.0) THEN
                          TXT1 = '"F#'
                      ELSE
                          TXT1 = '#'
                      ENDIF
                  ENDIF
                  CALL MN_TXT(XLEFT-1.0*SZ2_MN,YY,TXT1,SZ2_MN,0.0,-1
     1             ,NFONT,NCOL,THICK)
              ENDIF
              TXT1 = ' '
              AOFF = 10.0
              IF(IF.GT.0) THEN
                  WRITE(TXT1( 1:),'(1PG12.5)') FPAR(II,IF)
                  IF(FPAR(II,IF).LT.0) AOFF = 9.0
              ELSE
                  WRITE(TXT1( 1:),'(1PG12.5)') F00
                  IF(F00.LT.0) AOFF = 9.0
              ENDIF
              CALL MN_TXT(XLEFT+AOFF*SZ2_MN,YY,TXT1,SZ2_MN,0.0,-1
     1         ,NFONT,NCOL,THICK)
              IF(NFONT.LE.0 .OR. MOD(NFONT,100).EQ.0) THEN
                  CALL MN_TXT(XLEFT+22.0*SZ2_MN,YY,'"A#',SZ2_MN,0.0,-1
     1             ,NFONT,NCOL,THICK)
              ELSE
                  CALL MN_TXT(XLEFT+22.0*SZ2_MN,YY,'+/-',SZ2_MN,0.0,-1
     1             ,NFONT,NCOL,THICK)
              ENDIF
              TXT1 = ' '
              IF(IF.GT.0) THEN
                  WRITE(TXT1( 1:),'(1PG11.4)') DFPAR(II,IF)
              ELSE
                  WRITE(TXT1( 1:),'(1PG11.4)') DF00
              ENDIF
              CALL MN_TXT(XLEFT+23.5*SZ2_MN,YY,TXT1,SZ2_MN,0.0,-1
     1         ,NFONT,NCOL,THICK)
              CALL MN_TXT(XLEFT+34.0*SZ2_MN,YY,'-',SZ2_MN,0.0,-1
     1         ,NFONT,NCOL,THICK)
              TXT1 = ' '
              IF(IF.GT.0) THEN
                  WRITE(TXT1( 1:),'(1PG11.4)') ABS(DNFPAR(II,IF))
              ELSE
                  WRITE(TXT1( 1:),'(1PG11.4)') ABS(DNF00)
              ENDIF
              CALL MN_TXT(XLEFT+35.5*SZ2_MN,YY,TXT1,SZ2_MN,0.0,-1
     1         ,NFONT,NCOL,THICK)
              CALL MN_TXT(XLEFT+46.0*SZ2_MN,YY,'+',SZ2_MN,0.0,-1
     1         ,NFONT,NCOL,THICK)
              TXT1 = ' '
              IF(IF.GT.0) THEN
                  WRITE(TXT1( 1:),'(1PG11.4)') DPFPAR(II,IF)
              ELSE
                  WRITE(TXT1( 1:),'(1PG11.4)') DPF00
              ENDIF
              CALL MN_TXT(XLEFT+47.5*SZ2_MN,YY,TXT1,SZ2_MN,0.0,-1
     1         ,NFONT,NCOL,THICK)
3050      CONTINUE
3100  CONTINUE
C
      END
