//------------------------------------------------------------------------
// Get the data for a histogram
//
// $Id: m_root_ent.cxx,v 1.1 2005/05/12 21:20:48 brock Exp $
//------------------------------------------------------------------------

#include "TDirectory.h"
#include "TH1.h"
#include "TMath.h"
#include <iostream>

using namespace std;
using namespace TMath;

extern "C" {
    int m_root_ent_(Int_t &leni, char *tidi, Int_t &ndat,
		    Float_t &edent, Float_t &edlo, Float_t &edhi,
		    Float_t *acont, Float_t *rdat) {
	
	char* tid;
	tid = tidi;
	tid[leni] = 0;
	//gDirectory->ls();
	TH1 *h; 
	gDirectory->GetObject(tid,h);
	if ( h == 0 ) {
	    cout << "m_root_ent: Could not find histogram " << tid << endl;
	    return 1;
	}

	const char *classname;
	classname = h->ClassName();
	//cout << "m_root_ent: " << tid << " is a " << classname << endl;

	Stat_t stats[7];
	h->GetStats(stats);

	// Get the information about the histograms
	Double_t e1 = 1.0e+30;
	Double_t e2 = -1.0e+30;
	Double_t ee = 0.0;
	if ( strncmp(classname,"TH1",3) == 0 ) {
	    //cout << "Sums w,w2,wx,wx2: " 
	    // << stats[0] << ", " << stats[1] << ", "
	    // << stats[2] << ", " << stats[3] << endl;
	    Int_t nbinsx = h->GetNbinsX();
	    Double_t ent, dent;
	    for (Int_t nbinx=1; nbinx <= nbinsx; nbinx++) {
		ent  = h->GetBinContent(nbinx);
		dent = h->GetBinError(nbinx);
		//cout << "Bin: " << nbinx 
		//   << ", Contents: " << ent << " +/- " << dent << endl;
		rdat[2*(nbinx-1)]   = ent;
		rdat[2*(nbinx-1)+1] = dent;

		ee = ee + ent;
		e1 = Min(e1,ent - dent);
		e2 = Max(e2,ent + dent);
	    }
	    edent = ee;
	    edlo = e1;
	    edhi = e2;
	    //cout << "Sum of weights: " << stats[0] << endl;
	    //cout << "Integral: " << h->Integral(1,nbinsx,"") << endl;
	    Float_t und = h->GetBinContent(0);
	    Float_t sum = stats[0];
	    Float_t ove = h->GetBinContent(nbinsx+1);
	    acont[0] = und;
	    acont[1] = sum;
	    acont[2] = ove;
	} else if ( strncmp(classname,"TH2",3) == 0 ) {
	    //cout << "Sums w,w2,wx,wx2,wy,wy2,wxy: " 
	    // << stats[0] << ", " << stats[1] << ", "
	    // << stats[2] << ", " << stats[3] << ", "
	    // << stats[4] << ", " << stats[5] << ", " 
	    // << stats[6] << endl;
	    Int_t nbinsx = h->GetNbinsX();
	    Int_t nbinsy = h->GetNbinsY();
	    Double_t ent, dent;
	    Int_t nbin = 0;
	    for (Int_t nbiny=1; nbiny <= nbinsy; nbiny++) {
		for (Int_t nbinx=1; nbinx <= nbinsx; nbinx++) {
		    ent  = h->GetBinContent(nbinx,nbiny);
		    dent = h->GetBinError(nbinx,nbiny);
		    //cout << "Bin: " << nbinx 
		    //   << ", Contents: " << ent << " +/- " << dent << endl;
		    nbin++;
		    rdat[2*(nbin-1)]   = ent;
		    rdat[2*(nbin-1)+1] = dent;
		    
		    ee = ee + ent;
		    e1 = Min(e1,ent - dent);
		    e2 = Max(e2,ent + dent);
		}
	    }
	    edent = ee;
	    edlo = e1;
	    edhi = e2;
	    for (Int_t i=0; i<9; i++) {
		Double_t sum;
		acont[i] = 0.0;
		switch ( i ) {
		    case 0:
			sum = h->Integral(0,0,0,0,"");
			break;
		    case 1:
			sum = h->Integral(1,nbinsx,0,0,"");
			break;
		    case 2:
			sum = h->Integral(nbinsx+1,nbinsx+1,0,0,"");
			break;
		    case 3:
			sum = h->Integral(0,0,1,nbinsy,"");
			break;
		    case 4:
			sum = h->Integral(1,nbinsx,1,nbinsy,"");
			//sum = stats[0];
			break;
		    case 5:
			sum = h->Integral(nbinsx+1,nbinsx+1,1,nbinsy,"");
			break;
		    case 6:
			sum = h->Integral(0,0,nbinsy+1,nbinsy+1,"");
			break;
		    case 7:
			sum = h->Integral(1,nbinsx,nbinsy+1,nbinsy+1,"");
			break;
		    case 8:
			sum = h->Integral(nbinsx+1,nbinsx+1,nbinsy+1,nbinsy+1,"");
			break;
		}
		acont[i] = sum;
	    }
	} else if ( strncmp(classname,"TH3",3) == 0 ) {
	    Int_t nbinsx = h->GetNbinsX();
	    Int_t nbinsy = h->GetNbinsY();
	    Int_t nbinsz = h->GetNbinsZ();
	    Double_t ent, dent;
	    Int_t nbin = 0;
	    for (Int_t nbinz=1; nbinz <= nbinsz; nbinz++) {
		for (Int_t nbiny=1; nbiny <= nbinsy; nbiny++) {
		    for (Int_t nbinx=1; nbinx <= nbinsx; nbinx++) {
			ent  = h->GetBinContent(nbinx,nbiny,nbinz);
			dent = h->GetBinError(nbinx,nbiny,nbinz);
			//cout << "Bin: " << nbinx 
			//   << ", Contents: " << ent << " +/- " << dent << endl;
			nbin++;
			rdat[2*(nbin-1)]   = ent;
			rdat[2*(nbin-1)+1] = dent;
			
			ee = ee + ent;
			e1 = Min(e1,ent - dent);
			e2 = Max(e2,ent + dent);
		    }
		}
	    }
	    edent = ee;
	    edlo = e1;
	    edhi = e2;
	} else {
	    cout << tid << " is not a 1-D or 2-D histogram: "
		 << classname << endl;
	    return 1;
	}
	return 0;
    }
}
