      SUBROUTINE M_CXYZ(XIN,YIN,ZIN,XOUT,YOUT,NPT,NOPT)
C
C     TRANSFORMS FROM PLOT TO REAL COORDINATES IF REQUESTED
C     NOPT = 1 MEANS POINT IS IN PLOT CO-ORDINATES
C     NOPT = 2 MEANS DO IT FOR A LEGO PLOT
C     NOPT negative means do z transformation also and is only valid
C     for a lego plot
C
C     If x or y are outside limits for log scale set them to the limits
C     Return XOUT and YOUT = -9999.0 if the log scale would otherwise
C     blow up, even after the above
C
      IMPLICIT NONE
C
#include "mnpar.inc"
#include "mnhpj.inc"
#include "mnpij.inc"
#include "mnleg.inc"
C
      INTEGER NCHAX,NCHAY
      REAL XT,YT,A11,A13,A21,A22,A23,XC,ZSCALE,ZMIN
      COMMON/M9LEG/NCHAX,NCHAY,XT,YT
     + ,A11,A13,A21,A22,A23,XC,ZSCALE,ZMIN
c      double precision zbug1,zbug2
c      real bug1,bug2
c      common /crap12345/ bug1,bug2
C
      INTEGER NPT,NOPT
      REAL XIN(NPT),YIN(NPT),ZIN(NPT),XOUT(NPT),YOUT(NPT)
      REAL VECI(3),VECO(3)
C
      REAL XSCAL,YSCAL,XX,YY,zz,XLOG,YLOG,zlog,XMID,YMID,XTMP,YTMP
      REAL XF,YF,DX,DY,DZ,ANGLE
      INTEGER II
*ICB      integer ioerr
*ICB      character text*20
C
      CALL VZERO_r(XOUT,NPT)
      CALL VZERO_r(YOUT,NPT)
C
      IF(NOPT.EQ.1) THEN
          IF(ISMODU(1).EQ.2 .AND. XLO.GT.0.0) THEN
              XSCAL = (XPHI-XPLO) / ALOG10(XHI/XLO)
          ELSEIF(XHI.GT.XLO) THEN
              XSCAL = (XPHI-XPLO) / (XHI-XLO)
          ELSE
              XSCAL = 1.0
          ENDIF
          IF(ISMODU(2).EQ.2 .AND. YLO.GT.0.0) THEN
              YSCAL = (YPHI-YPLO) / ALOG10(YHI/YLO)
          ELSEIF(YHI.GT.YLO) THEN
              YSCAL = (YPHI-YPLO) / (YHI-YLO)
          ELSE
              YSCAL = 1.0
          ENDIF
C
          DO 1000 II=1,NPT
              IF(ISMODU(1).EQ.2) THEN
                  XX = AMAX1(XLO,AMIN1(XHI,XIN(II)))
                  IF(XX.LE.0.0 .OR. XLO.LE.0.0 .OR.
     1               XLO*XX.LE.0.0) THEN
                      XOUT(II) = -9999.0
                      YOUT(II) = -9999.0
                      GOTO 1000
                  ENDIF
                  XLOG = ALOG10(XX/XLO)
                  XOUT(II) = XPLO + XLOG*XSCAL
              ELSE
                  XOUT(II) = XPLO + (XIN(II)-XLO)*XSCAL
              ENDIF
C
              IF(ISMODU(2).EQ.2) THEN
                  YY = AMAX1(YLO,AMIN1(YHI,YIN(II)))
                  IF(YY.EQ.0.0 .OR. YLO.EQ.0.0 .OR.
     1               YLO*YY.LE.0.0) THEN
                      XOUT(II) = -9999.0
                      YOUT(II) = -9999.0
                      GOTO 1000
                  ENDIF
                  YLOG = ALOG10(YY/YLO)
                  YOUT(II) = YPLO + YLOG*YSCAL
              ELSE
                  YOUT(II) = YPLO + (YIN(II)-YLO)*YSCAL
              ENDIF
1000      CONTINUE
C
C     LEGO PLOT COORDINATE TRANSFORMATION
C
      ELSE IF(IABS(NOPT).EQ.2) THEN
          XF = FLOAT(NCHAX) / (XHI - XLO)
          YF = FLOAT(NCHAY) / (YHI - YLO)
C
          DO 2000 II=1,NPT
*
*             Put in some more protection because the HP optimizer is stupid!!
*
c              write(6,'(1x,3(1pg15.8))',iostat=ioerr) xin(ii),xlo
c     +         ,(xin(ii)-xlo)
c              write(text,'(1pg15.8)',iostat=ioerr) (xin(ii)-xlo)
c              write(6,'(1x,a)') text
              if(xlo.ne.0.0) then
c                  print *,xlo,xin(ii)
c                  bug1 = (xin(ii)-xlo)
c                  print *,bug1
                  if(dble(xin(ii))/dble(xlo) .lt. (1.0d0 - 1.0d-5) .or.
     +               dble(xin(ii))/dble(xlo) .gt. (1.0d0 + 1.0d-5)) then
                      DX = XC * (dble(XIN(II)) - dble(XLO)) * XF
c                      DX = XC * bug1 * XF
                  else
                      dx = 0.0
                  endif
              else
                  DX = XC * (dble(XIN(II)) - dble(XLO)) * XF
              endif
c              write(6,'(2(1pg15.8))') xin(ii),xlo
c              zbug1 = dble(xin(ii)) - dble(xlo)
c              write(6,'(2(1pg15.8))') yin(ii),ylo
c              zbug2 = dble(yin(ii)) - dble(ylo)
c              write(6,'(2(1pg15.8))') zbug1,zbug2
c              call hbug_dummy(bug1,bug2)
c              print *,xin(ii),xlo,(xin(ii)-xlo),bug1,xc,xf
c              bug1 = sngl(zbug1)
c              bug2 = sngl(zbug2)
c              write(6,'(2(1pg15.8))') bug1,bug2
c              DX = XC * zbug1 * XF
c              print *,yin(ii),ylo,(yin(ii)-ylo),bug2,xc,yf
              if(ylo.ne.0.0) then
c                  print *,ylo,yin(ii)
c                  bug2 = (yin(ii)-ylo)
c                  write(text,'(1pg15.8)',iostat=ioerr) (yin(ii)-ylo)
c                  write(6,'(1x,a)') text
                  if(dble(yin(ii))/dble(ylo) .lt. (1.0d0 - 1.0d-5) .or.
     +               dble(yin(ii))/dble(ylo) .gt. (1.0d0 + 1.0d-5)) then
c                  if(abs(bug2/ylo).gt.1.0e-5) then
c                      print *,yin(ii),ylo,(yin(ii)-ylo)
                      Dy = XC * (dble(yIN(II)) - dble(yLO)) * yF
c                      Dy = XC * bug2 * yF
                  else
                      dy = 0.0
                  endif
              else
                  Dy = XC * (dble(yIN(II)) - dble(yLO)) * yF
              endif
c              DY = XC * (YIN(II) - YLO) * YF
c              DY = XC * zbug2 * YF
c              write(6,'(2(1pg15.8))') dx,dy
*
              XOUT(II) = A11*DX + A13*DY + XT
              IF(NOPT.GT.0) THEN
                  YOUT(II) = A21*DX + A23*DY + YT
              ELSE
                  if(ismodu(3).eq.2) then
                      zz = amax1(zlo,amin1(zhi,zin(ii)))
                      if(zz.eq.0.0 .or. zlo.eq.0.0 .or.
     +                 zlo*zz.lt.0.0) then
                          xout(ii) = -9999.0
                          yout(ii) = -9999.0
                          goto 2000
                      endif
                      zlog = alog10(zz/zllo) - alog10(zlo/zllo)
                      dz   = zscale * (zlog + zmin)
                  else
                      DZ   = ZSCALE * ((ZIN(II) - ZLO) + ZMIN)
                  endif
                  YOUT(II) = A21*DX + A22*DZ + A23*DY + YT
              ENDIF
2000      CONTINUE
C
C     IGTABL LEGO PLOT COORDINATE TRANSFORMATION
C
      ELSE IF(IABS(NOPT).EQ.3) THEN
          DO 3000 II=1,NPT
              VECI(1) = XIN(II) + YIN(II)*COSA
              VECI(2) = YIN(II)*SINA
              IF(NOPT.GT.0) THEN
                  if(ismodu(3).eq.2) then
                      veci(3) = alog10(zlo/zllo)
                  else
                      VECI(3) = ZLO
                  endif
              ELSE
                  if(ismodu(3).eq.2) then
                      zz = amax1(zlo,amin1(zhi,zin(ii)))
                      if(zz.eq.0.0 .or. zlo.eq.0.0 .or.
     +                 zlo*zz.lt.0.0) then
                          xout(ii) = -9999.0
                          yout(ii) = -9999.0
                          goto 3000
                      endif
                      VECI(3) = alog10(ZIN(II)/zllo)
                  else
                      VECI(3) = ZIN(II)
                  endif
              ENDIF
              CALL IHWTON(VECI,VECO)
              XOUT(II) = VECO(1)
              YOUT(II) = VECO(2)
 3000     CONTINUE
      ELSE
          CALL UCOPY_r(XIN,XOUT,NPT)
          CALL UCOPY_r(YIN,YOUT,NPT)
      ENDIF
C
C     Now apply a rotation if requested.
C     The rotation is about the centre of the current picture
C
      IF(TSZEU(8).NE.0.0) THEN
          ANGLE = TSZEU(8) * DRAD
          XMID = 0.5 * (XPLO + XPHI)
          YMID = 0.5 * (YPLO + YPHI)
          DO 4000 II=1,NPT
              XTMP = XMID + (XOUT(II)-XMID)*COS(ANGLE) -
     +                      (YOUT(II)-YMID)*SIN(ANGLE)
              YTMP = YMID + (XOUT(II)-XMID)*SIN(ANGLE) +
     +                      (YOUT(II)-YMID)*COS(ANGLE)
              XOUT(II) = XTMP
              YOUT(II) = YTMP
 4000     CONTINUE
      ENDIF
C
 9000 CONTINUE
      RETURN
      END
