      SUBROUTINE M_UPTS (IDATE, ITIME, IDATM)
*
************************************************************************
*                                                                      *
*        SUBR. M_UPTS (IDATE*, ITIME*, IDATM)                          *
*                                                                      *
*     Unpacks date and time from one word                              *
*                                                                      *
*     Arguments :                                                      *
*                                                                      *
*     IDATE*   Date : 6 Decimal integer : YYMMDD                       *
*     ITIME*   Time : 6 Decimal integer : HHMMSS                       *
*     IDATM    Packed date-time                                        *
*                                                                      *
************************************************************************
*
#include "mntim.inc"
*
#include "mntimd.inc"
*     ------------------------------------------------------------------
*
      III  = IDATM
      ISEC = MOD(III,MXSEC)
      if(isec.ge.60) then
          isec = mod(isec,60)
      endif
      III  = (III-ISEC)/MXSEC
      IMIN = MOD(III,MXMIN)
      if(imin.ge.60) then
          imin = mod(imin,60)
      endif
      III  = (III-IMIN)/MXMIN
      IHOU = MOD(III,MXHOU)
      if(ihou.gt.24 .or.
     +   (ihou.eq.24 .and. (imin.gt.0 .or.isec.gt.0))) then
          ihou = mod(ihou,24)
      endif
      III  = (III-IHOU)/MXHOU
      IDAY = MOD(III,MXDAY)
      if(iday.gt.31) then
          iday = mod(iday,31)
      endif
      III  = (III-IDAY)/MXDAY
      IMON = MOD(III,MXMON)
      if(imon.gt.12) then
          isec = mod(isec,12)
      endif
      IYEA = (III-IMON)/MXMON
      if(iyea.le.20) then
        iyea = iyea + 80
      else
        iyea = iyea - 20
      endif
*
      IDATE = IDAY + 100*IMON + 10000*IYEA
      ITIME = ISEC + 100*IMIN + 10000*IHOU
*                                                             END M_UPTS
      END
