      double precision function xmnargus(nmode,wpar,npar,dpx,dexpmx)
*
*------------------------------------------------------------------------------
*     Interface to ARGUS background function (normal and reversed)
*     Does the function normalization if requested.
*
*     $Id: xmnargus.fpp,v 1.4 2005/09/08 12:43:36 brock Exp $
*------------------------------------------------------------------------------
*
      implicit none
C
      integer mstep
      parameter (mstep = 100)
C
#include "mnpar.inc"
#include "mnfit.inc"
#include "mnusr.inc"
C
      integer nmode,npar
      double precision wpar(*),dpx,dexpmx
C
      double precision dsimps
      double precision xmnargus2,xmnargusr2,wmnargusi
     + ,wpari(mfnpar),warval(0:mstep)
     + ,wxlo,wxhi,xx,dxx
      integer i,ii
      logical qarnew,qfarea_lst
      integer nmode_lst
c
      save wpari,wmnargusi,qfarea_lst,nmode_lst
      data wpari/mfnpar*-1.0d+31/
      data qfarea_lst/.false./
      data nmode_lst/-1/
C
      IF(QFAREA) THEN
C
C       See if any parameters have changed
C
        QARNEW = .FALSE.
        DO I=2,NPAR
          IF(WPAR(I).NE.WPARI(I)) THEN
            QARNEW = .TRUE.
*ICB                  write(6,'('' ARGUS parameter'',I4,'' changed ''
*ICB     +             ,2(1pg18.10))') i,wpari(i),wpar(i)
            WPARI(I) = WPAR(I)
          ENDIF
        ENDDO
C
C       If they have changed then recalculate the AREA
C
        IF(QARNEW .or. .not.qfarea_lst .or. nmode.ne.nmode_lst) THEN
          if(nmode.eq.0) then
            WXLO     = 0.0d0
            WXHI     = wpari(3)
          else
            wxlo     = wpari(3)
            wxhi     = dble(xmaxnm)
          endif
          WPARI(1) = 1.0D0
          DXX = (WXHI - WXLO) / DFLOAT(MSTEP)
          XX  = WXLO - DXX
          DO I=0,MSTEP
            XX = XX + DXX
            if(nmode.eq.0) then
              WARVAL(I) = XMNARGUS2(WPARI(1),XX,DEXPMX)
            else
              WARVAL(I) = XMNARGUSR2(WPARI(1),XX,DEXPMX)
            endif
          ENDDO
          WMNARGUSI = DSIMPS(WARVAL(0), WXLO, WXHI, MSTEP)
*ICB          write(6,'('' ARGUS parameters: '',4(1pg12.5))')
*ICB     +     (wpari(ii),ii=1,4)
*ICB          write(6,'('' ARGUS range: '',2F8.2
*ICB     +     ,'' Integral: '',1pg12.5)') wxlo,wxhi,wmnargusi
        ENDIF
      ELSE
        WMNARGUSI = 1.0D0
      ENDIF
      qfarea_lst = qfarea
      nmode_lst  = nmode
C
      if(nmode.eq.0) then
        XMNARGUS = XMNARGUS2(WPAR,DPX,DEXPMX) / WMNARGUSI
      else
        XMNARGUS = XMNARGUSR2(WPAR,DPX,DEXPMX) / WMNARGUSI
      endif
C
      END
