      DOUBLE PRECISION FUNCTION XMNDFUN(XX,YY,IF,NH,WXPARI,WMNHER)
C
C     CALULATES THE VALUE OF A FUNCTION AT XX
C     IF IS THE FUNCTION NUMBER IN THE ORDER THEY WERE ADDED
C     NH IS THE POSITION OF THE HISTOGRAM
C
      IMPLICIT NONE
C
#include "mnpar.inc"
#include "mnfit.inc"
#include "mnfun.inc"
#include "mnflg.inc"
#include "mnusr.inc"
#include "mnpij.inc"
#include "mnlun.inc"
C
      REAL XX,YY
      INTEGER IF,NH
      DOUBLE PRECISION WXPARI(MFNPAR)
      DOUBLE PRECISION WXPAR(MFNPAR)
C
      DOUBLE PRECISION XMNCLC,XMNPPM,XMNFRG,XMNRES,XMNCNT,XMNUSR
     + ,XMNHIS,XMNHSM,XMNC2D
     1 ,CSDJCL
      DOUBLE PRECISION WMNCLC,WMNPPM,WMNFRG,WMNRES,WMNCNT,WMNUSR
     1 ,WMNCMI,WMNHIS,WMNHSM
      DOUBLE PRECISION WFUN,WFERR,WMNHER,WTMP,WTMP2
C
C     Stuff needed for convoluting function with a Gaussian
C
      DOUBLE PRECISION DSIMPS
      DOUBLE PRECISION WXSAV,WNORM,WXXLO,WXXHI,WXLLO,WXLHI
      double precision WFVAL(0:MFCONV),WLVAL(0:MSIMPS)
      REAL SIGMA,RSIGMA,XBSAV,XSTEP,XXLO,XXHI
      real xllo,xlhi,xlstep
      INTEGER NSTEP,nlstep,NFUN,NPAR,I,II,JJ
C
      INTEGER LMODEL,NFUSER,NFCMI,IDHA,IDHB,NHFMD,NHS,NPAR2,NF
      REAL ERES,EDAU,AMPI,XXX
C
      WFUN  = 0.0
      WFERR = 0.0
      NFUN  = INUMF(IF)
      NPAR  = IPARF(IF)
C
C     PACK PARAMETER VALUES IN THE RIGHT PLACE
C
      IF(NHFIT.GT.1) THEN
          IF(NH.GT.0 .AND. NHFIT.GT.1 .AND. .NOT.QRATIO) THEN
              WXPAR(1) = WXPARI(NH)
          ELSE
              WXPAR(1) = WXPARI(1)
          ENDIF
          JJ = 1
          DO 1000 II=NHFIT+1,NPAR
              JJ = JJ + 1
              WXPAR(JJ) = WXPARI(II)
1000      CONTINUE
          NPAR = NPAR - NHFIT + 1
      ELSE
          CALL UCOPY_r(WXPARI,WXPAR,2*NPAR)
      ENDIF
C
C     Setup things if we are convoluting the function with a Gaussian
C
      IF(QFCONV) THEN
          SIGMA = RFCONV(1)
          NSTEP = MAX(2,NINT(RFCONV(2)))
          RSIGMA= MAX(1,NINT(RFCONV(3)))
          XBSAV  = XBINNM
          XXLO   = XX - RSIGMA*SIGMA
          XXHI   = XX + RSIGMA*SIGMA
          XSTEP  = (XXHI - XXLO) / FLOAT(NSTEP)
          WNORM  = 1.0D0 / DBLE(SQRT(TWOPI)*SIGMA)
          WXXLO  = DBLE(XXLO)
          WXXHI  = DBLE(XXHI)
      ENDIF
C
C     DIPION FUNCTIONS
C
      IF(NFUN.EQ.LFPIPI) THEN
          LMODEL = NINT(XFXPAR(1,IF))
          IF(NH.GT.0 .AND. NHFIT.GT.0) THEN
              ERES = XFTPAR(2,NH)
              EDAU = XFTPAR(3,NH)
              AMPI = XFTPAR(4,NH)
          ELSE
              ERES = XFXPAR(2,IF)
              EDAU = XFXPAR(3,IF)
              AMPI = XFXPAR(4,IF)
          ENDIF
C
          IF(QFCONV) THEN
              XXX      = XXLO - XSTEP
              DO I=0,NSTEP
                  XXX = XXX + XSTEP
                  WTMP = XMNPPM(XX,ERES,EDAU,AMPI,LMODEL,WXPAR(1))
                  WFVAL(I) = WTMP *
     +             WNORM * DBLE(EXP(-0.5*((XXX-XX)/SIGMA)**2))
              ENDDO
              WMNPPM = DSIMPS(WFVAL(0),WXXLO,WXXHI,NSTEP)
          ELSE
              WMNPPM = XMNPPM(XX,ERES,EDAU,AMPI,LMODEL,WXPAR(1))
          ENDIF
          WFUN = WMNPPM
C
C     FRAGMENTATION FUNCTIONS
C
      ELSEIF(NFUN.EQ.LFFRAG) THEN
          LMODEL = NINT(XFXPAR(1,IF))
C
          IF(QFCONV) THEN
              XXX      = XXLO - XSTEP
              DO I=0,NSTEP
                  XXX = XXX + XSTEP
                  WTMP = XMNFRG(LMODEL,WXPAR(1),NPAR,XX)
                  WFVAL(I) = WTMP *
     +             WNORM * DBLE(EXP(-0.5*((XXX-XX)/SIGMA)**2))
              ENDDO
              WMNFRG = DSIMPS(WFVAL(0),WXXLO,WXXHI,NSTEP)
          ELSE
              WMNFRG = XMNFRG(LMODEL,WXPAR(1),NPAR,XX)
          ENDIF
          WFUN = WMNFRG
C
C     FIT TO RESONANCE CROSS-SECTIONS
C
      ELSEIF(NFUN.EQ.LFXRES) THEN
          IF(QFCONV) THEN
              XXX      = XXLO - XSTEP
              DO I=0,NSTEP
                  XXX = XXX + XSTEP
                  WTMP = XMNRES(WXPAR(1),NPAR,XX)
                  WFVAL(I) = WTMP *
     +             WNORM * DBLE(EXP(-0.5*((XXX-XX)/SIGMA)**2))
              ENDDO
              WMNRES = DSIMPS(WFVAL(0),WXXLO,WXXHI,NSTEP)
          ELSE
              WMNRES = XMNRES(WXPAR(1),NPAR,XX)
          ENDIF
          WFUN = WMNRES
C
C     FIT TO CONTINUUM CROSS-SECTIONS
C
      ELSEIF(NFUN.EQ.LFXCNT) THEN
          IF(QFCONV) THEN
              XXX      = XXLO - XSTEP
              DO I=0,NSTEP
                  XXX = XXX + XSTEP
                  WTMP = XMNCNT(WXPAR(1),NPAR,XX)
                  WFVAL(I) = WTMP *
     +             WNORM * DBLE(EXP(-0.5*((XXX-XX)/SIGMA)**2))
              ENDDO
              WMNCNT = DSIMPS(WFVAL(0),WXXLO,WXXHI,NSTEP)
          ELSE
              WMNCNT = XMNCNT(WXPAR(1),NPAR,XX)
          ENDIF
          WFUN = WMNCNT
C
C     USER DEFINED FUNCTION
C
      ELSEIF(NFUN.EQ.LFUSER) THEN
          NFUSER = NINT(XFXPAR(1,IF))
          IF(QFCONV) THEN
              XXX      = XXLO - XSTEP
              DO I=0,NSTEP
                  XXX = XXX + XSTEP
                  WTMP = XMNUSR(XXX,YY,NPAR,WXPAR(1),NFUSER,WFERR)
                  WFVAL(I) = WTMP *
     +             WNORM * DBLE(EXP(-0.5*((XXX-XX)/SIGMA)**2))
              ENDDO
              WMNUSR = DSIMPS(WFVAL(0),WXXLO,WXXHI,NSTEP)
          ELSE
              WMNUSR = XMNUSR(XX,YY,NPAR,WXPAR(1),NFUSER,WFERR)
          ENDIF
          WFUN = WMNUSR
C
C     COMIS DEFINED FUNCTION
C
      ELSEIF(NFUN.EQ.LFCMIS) THEN
          NFCMI  = NINT(XFXPAR(1,IF))
          IF(QFCONV) THEN
              XXX      = XXLO - XSTEP
              DO I=0,NSTEP
                  XXX = XXX + XSTEP
                  WTMP = CSDJCL(IADRF(IF),6,XXX,YY,NPAR,WXPAR(1),NFCMI
     +             ,WFERR)
                  WFVAL(I) = WTMP *
     +             WNORM * DBLE(EXP(-0.5*((XXX-XX)/SIGMA)**2))
              ENDDO
              WMNCMI = DSIMPS(WFVAL(0),WXXLO,WXXHI,NSTEP)
          ELSE
              WMNCMI = CSDJCL(IADRF(IF),6,XX,YY,NPAR,WXPAR(1),NFCMI
     +         ,WFERR)
          ENDIF
          WFUN = WMNCMI
C
C     HISTOGRAM DEFINED AS A FUNCTION
C
      ELSEIF(NFUN.EQ.LFHFUN) THEN
          IDHA  = NINT(XFXPAR(1,IF))
          IDHB  = NINT(XFXPAR(2,IF))
          NHFMD = NINT(XFXPAR(3,IF))
          WMNHIS = XMNHIS(IDHA,IDHB,NHFMD,XX,YY,WFERR)
          WFUN   = WXPAR(1) * WMNHIS
          WFERR  = WXPAR(1) * WFERR
C
C     Smooth histogram defined as a function
C
      ELSEIF(NFUN.EQ.LFHSMO) THEN
          IDHA  = NINT(XFXPAR(1,IF))
          IDHB  = NINT(XFXPAR(2,IF))
          NHFMD = NINT(XFXPAR(3,IF))
          NHS   = NINT(XFXPAR(4,IF))
          WMNHSM = XMNHSM(IDHA,IDHB,WXPAR(2),NHFMD,NHS,XX,YY,WFERR)
          WFUN   = WXPAR(1) * WMNHSM
          WFERR  = WXPAR(1) * WFERR
C
C     2D Functions
C
      ELSEIF(NFUN.GE.LF2DIM) THEN
          NPAR2  = NINT(XFXPAR(2,IF))
          NF     = NFUN - LF2DIM + 1
          WMNCLC = XMNC2D(NF,WXPAR(1),NPAR,NPAR2,XX,YY)
          WFUN   = WMNCLC
C
C     ALL OTHERS
C
      ELSE
          NPAR2  = NINT(XFXPAR(2,IF))
          IF(QFCONV) THEN
              XXX      = XXLO - XSTEP
              DO I=0,NSTEP
                  XXX = XXX + XSTEP
                  WTMP = XMNCLC(NFUN,WXPAR(1),NPAR,NPAR2,XXX,YY)
                  WFVAL(I) = WTMP *
     +             WNORM * DBLE(EXP(-0.5*((XXX-XX)/SIGMA)**2))
              ENDDO
              WMNCLC = DSIMPS(WFVAL(0),WXXLO,WXXHI,NSTEP)
          ELSE
              WMNCLC = XMNCLC(NFUN,WXPAR(1),NPAR,NPAR2,XX,YY)
          ENDIF
          WFUN   = WMNCLC
      ENDIF
*
*     For Gaussians, BW and CB functions scale the AREA to only include that
*     inside the plot limits
*
      if(qfplim) then
        if((nfun.ge.lfgauss .and. nfun.le.lfgauss+5) .or.
     +     (nfun.ge.lfgaus2 .and. nfun.le.lfgaus2+6) .or.
     +     nfun.eq.lfcb .or. nfun.eq.lfrcb) then
          nlstep = nintft
          xllo   = xminnm
          xlhi   = xmaxnm
          xlstep = (xlhi - xllo) / float(nlstep)
          xxx    = xllo - xlstep
          wxllo = dble(xllo)
          wxlhi = dble(xlhi)
*ICB          WXSAV  = WXPAR(1)
*ICB          wxpar(1) = 1.0d0
          xbsav  = xbinnm
          xbinnm = 1.0
          do i=0,nlstep
            xxx = xxx + xlstep
            wtmp = xmnclc(nfun,wxpar(1),npar,npar2,xxx,yy)
            wlval(i) = wtmp
          enddo
          wtmp2 = dsimps(wlval(0),wxllo,wxlhi,nlstep)
          write(6,'('' AREA '',f12.5,'' Int '',f12.5)')
     +     wxpar(1),wtmp2
          wfun  = wfun * wxpar(1) / wtmp2
          xbinnm = xbsav
*ICB          wxpar(1) = wxsav
        endif
      endif
C
C     IF WE ARE FITTING SEVERAL PLOTS MULTIPLY BY THE NORMALIZATION
C     RATIO, IF THAT IS ENABLED, OTHERWISE BY THE PARAMETER
C
      IF(QRATIO .AND. NH.GT.0 .AND. NHFIT.GT.1) THEN
          IF(NH.LT.NHFIT) THEN
              WFUN  = WXPARI(NH+1) * WFUN
              WFERR = WXPARI(NH+1) * WFERR
          ELSE
              WTMP = 1.0
              DO 5000 I=2,NHFIT
                  WTMP = WTMP - WXPARI(I)
5000          CONTINUE
              WFUN  = WTMP * WFUN
              WFERR = WTMP * WFERR
          ENDIF
      ENDIF
C
      XMNDFUN = WFUN
      WMNHER  = WFERR
C
      RETURN
      END
