      SUBROUTINE M_HGET(NMODE,COMAND,ISET,IBIN,IVAR,QPASS,IDELIM)
C
C------------------------------------------------------------------------------
C     Get the histogram number and bin number
C     NMODE = 0  means use INTTYP
C     NMODE = 1  means use VALTYP
C     NMODE = 2  means use VL2TYP
C     If the plot is an Ntuple, set IVAR to the variable
C     number and only allow X, otherwise IVAR = 0
C------------------------------------------------------------------------------
C
      IMPLICIT NONE
*
#include "mnpar.inc"
#include "mndat.inc"
#include "mninf.inc"
#include "mnprj.inc"
#include "mnlun.inc"
*
      integer nmode,iset,ibin,ivar,idelim
      character*(*) comand
      logical qpass
*
      logical qmnhex,qexist
      character*80 txt1
      integer ida,idb,nh,nloop,npt,nmult,i,k,jelem(9),leng,mnllen
     + ,nbin,ich,nblo,ioerr,ierr
      external mnllen
*
      integer  ichtyp,lchtyp,inttyp,ivltyp,nchscn
      real     vl2typ
      external ichtyp,lchtyp,inttyp,ivltyp,vl2typ,nchscn
C
C     Get data set number and bin number in Y1(IBIN)
C
      QPASS = .FALSE.
C
C     Loop over characters in command to get to numeric part
C
100   CONTINUE
      K = ICHTYP(.TRUE.)
      IF(K .EQ. ICHAR(' '))GOTO 100
C
      LENG = MNLLEN(COMAND)
      DO 110 I=1,LENG-1
          K = ICHTYP(.TRUE.)
110   CONTINUE
*
*     If plot number is not there, treat it as an Ntuple variable and
*     return
*
      IDA = INTTYP(.TRUE.,IDELIM)
*
      IF(NMODE.EQ.0 .OR. NMODE.EQ.2) THEN
          IF(IDA.EQ.0 .AND. NCHSCN().EQ.0) THEN
              IDELIM = 0
              CALL RESTYP
              RETURN
          ENDIF
      ENDIF
*
      IF(IDELIM.GT.0) THEN
          CALL MN_ERR('M_HGET','Something wrong with plot number')
          RETURN
      ENDIF
      IDB = NDIDB
C
C     SEE IF & IS NEXT CHARACTER
C
      ICH = LCHTYP()
      IF(ICH.EQ.ICHAR('&')) THEN
          IDB = INTTYP(.TRUE.,IDELIM)
          IF(IDELIM.GT.0) THEN
              CALL MN_ERR('M_HGET','Something wrong with plot number')
              RETURN
          ENDIF
      ENDIF
C
C     Check for left parenthesis
C
      ICH = LCHTYP()
      IF(ICH.NE.ICHAR('(')) THEN
          CALL MN_ERR('M_HGET','Missing "(" after plot number')
          RETURN
      ENDIF
C
      NH = 0
      QEXIST = QMNHEX(IDA,IDB,NH)
      ISET = NH
C
      IF(.NOT.QEXIST) THEN
           WRITE(TXTERR,10000) IDA,IDB
10000      FORMAT('Plot ',I7,I4,' does not exist ***')
           CALL MN_ERR('M_HGET',TXTERR)
           RETURN
      ENDIF
C
C     GET ALL THE RELEVANT HISTOGRAM INFORMATION
C
      CALL MN_HGT(IDA,IDB,NH)
C
      IF(NMODE.LT.0) THEN
          IF(COMAND.EQ.'X'   .OR. COMAND.EQ.'DX' .OR.
     +       COMAND.EQ.'DNX' .OR. COMAND.EQ.'DPX') THEN
              IF(NDIM.GT.0) THEN
                  WRITE(TXTERR,'(''Histogram'',I7,I4
     +             ,'' does not have the X, DX values stored'')')
     +             IDA,IDB
                  CALL MN_ERR('M_HGET',TXTERR)
                  RETURN
              ENDIF
          ENDIF
C
          IF(COMAND.EQ.'DX'  .OR.
     +       COMAND.EQ.'DNX' .OR. COMAND.EQ.'DPX') THEN
              IF(NDIM.LT.-1) THEN
                  WRITE(TXTERR,'(''Histogram'',I7,I4
     +             ,'' does not have the DX values stored'')')
     +             IDA,IDB
                  CALL MN_ERR('M_HGET',TXTERR)
                  RETURN
              ENDIF
          ENDIF
C
          IF((COMAND.EQ.'DPX' .OR. COMAND.EQ.'DPY') .AND.
     +       ((NDIM.LT.0 .AND. NWPPT.LE.4) .OR.
     +        (NDIM.GT.0 .AND. NWPPT.LE.2)))THEN
              WRITE(TXTERR,'(''Histogram'',I7,I4
     +         ,'' does not have asymmetric errors'')') IDA,IDB
              CALL MN_ERR('M_HGET',TXTERR)
              RETURN
          ENDIF
      ENDIF
C
C     Get bin value and variable if it is an Ntuple
C
      NLOOP = 0
      NPT = 1
      NMULT = 1
      QPASS = .FALSE.
2000  CONTINUE
      NLOOP = NLOOP + 1
      IF(NMODE.EQ.0) THEN
          NBIN = INTTYP(.TRUE.,IDELIM)
      ELSEIF(IABS(NMODE).EQ.1) THEN
          NBIN = IVLTYP(.TRUE.,IDELIM)
      ELSEIF(IABS(NMODE).EQ.2) THEN
          NBIN = NINT(VL2TYP(.TRUE.,IDELIM))
      ENDIF
C
      IF(IDELIM .GT. 0) THEN
          CALL MN_ERR('M_HGET','Something wrong with bin number')
          RETURN
      ENDIF
C
      NBLO = 0
      IF(QPROJ) NBLO = -1
      IF((NDIM.GT.0 .AND.
     +    (NBIN.LE.NBLO .OR. NBIN.GT.IDBIN(NLOOP))) .OR.
     +   (NDIM.LT.0 .AND.
     +    (NBIN.LE.NBLO .OR. NBIN.GT.NPNT))) THEN
         WRITE(TXTERR,11000,IOSTAT=IOERR) NBIN
11000    FORMAT('Point number',I4,' is out of range')
         CALL MN_ERR('M_HGET',TXTERR)
         RETURN
      ENDIF
C
      NPT = NMULT*(NBIN-1) + NPT
      NMULT = NMULT*IDBIN(NLOOP)
      IF(NDIM.GT.0 .AND. NLOOP.LT.NDIM) GOTO 2000
C
      IBIN = NPT
C
      IVAR = 0
C
C     If this is an Ntuple get the variable name or number
C
      IF(NDIM.LT.-1) THEN
          CALL M_VGET(1,NH,IVAR,TXT1,jELEM,IDELIM,IERR)
          IF(IERR.NE.0) THEN
              if(nmode.eq.0 .or. nmode.eq.2) then
                  CALL MN_ERR('M_HGET'
     +             ,'Something wrong with the variable')
              endif
              IVAR = 0
              RETURN
          ENDIF
      ENDIF
C
C     Check for right parenthesis
C
      ICH = LCHTYP()
      IF(ICH.NE.ICHAR(')')) THEN
         CALL MN_ERR('M_HGET','Missing ")" after point or variable')
         RETURN
      ENDIF
C
      QPASS = .TRUE.
C
      END
