C
      SUBROUTINE M_PRSE(QEQUAL,NSUB,STRING,LSTYP,LSTP,LSTF,LSTV,QPASS)
C
C     This set of subroutine unpacks Fortran arithmetic equations,
C     except integer functions and those involving more than 1 variable.
C     the subroutines recognize the following kinds of operands:
C
C               (1) Floating point constants,
C               (2) Registers R0 - R99
C               (3) Parameters such as P1(3), P5(9), etc.. the first
C                   integer is the parameter number and the second is
C                   the function number.
C               (4) Parameter errors such as ERR1(3), ERR5(9), etc.. the first
C                   integer is the parameter number and the second is
C                   the function number.
C               (5) Functions such as FPOS1(...), FNEG5(...), etc.. the
C                   first number is the function number. the argument
C                   of the function can be any expression.
C               (6) Data values such as X2(165),DX2(165),Y2(165),DY2(165)
C                   X ....... Center of bin
C                   DX ...... Bin width
C                   Y ....... Y value of bin
C                   DY ...... Error of Y value
C                   First number is the data set number.
C                   Second number is the bin number
C               (7) Extra variables, which are stored in registers
C
C     EXAMPLES: P2(10) = SQRT(3.1416) * P4(8)**P4(1) + FPOS1(P2(3))
C               P3(4)  + SIN(P4(3) + 1.)**3 = 1. + DFPOS2(30.+FNEG1(1.))
C
C     THE OUTPUT OF M_PRSE IS IN THE FORM OF 3 PARALLEL LISTS WHICH
C     CONTAIN OPERANDS AND OPERATORS USING THE RULES OF REVERSE POLISH
C     NOTATION FOR UNPACKING ARITHMETIC OPERATORS. THE ARGUMENTS ARE AS
C     FOLLOWS:
C
C     QPASS = .TRUE. IF NO ERRORS ENCOUNTERED
C
C     QEQUAL = .TRUE. IF WE DEMAND THAT EQUAL SIGN BE IN EXPRESSION
C
C     NSUB  = LENGTH OF LIST
C
C     STRING = ASCII STRING TYPE BY USER
C
C     LSTYP(I) = TYPE OF ITEM I IN LSTP
C              = -1 ITEM IS AN OPERATOR
C              =  0 ITEM IS A FLOATING POINT CONSTANT
C              =  1 ITEM IS A PARAMETER
C
C     LSTF(I) = FUNCTION # OF ITEM I   (LSTYP(I) = 1)
C     LSTF(I) = 0                      (LSTYP(I) # 1)
C
C     LSTP(I) = PARAMETER #            (LSTYP(I) = 1)
C     LSTP(I) = F.P. CONSTANT          (LSTYP(I) = 0)
C     LSTP(I) = OPERATOR               (LSTYP(I) =-1) SEE BELOW
C     LSTP(I)  =  1    +
C              =  2    -
C              =  3    *
C              =  4    /
C              =  5    ** (PROGRAM ALSO UNDERSTANDS ^)
C              =  6    SQRT
C              =  7    SIN
C              =  8    COS
C              =  9    TAN
C              = 10    ALOG
C              = 11    ALOG10
C              = 12    EXP
C              = 13    ASIN
C              = 14    ACOS
C              = 15    ATAN
C              = 16    ABS
C              = 17    INT
C              = 18    NINT
C              = 19    MIN
C              = 20    MAX
C              = 21    MOD
C              = 22    DATE_ONLY
C              = 23    TIME_SEC
C              = 24    TIME_MIN
C              = 25    DATE_TIM
C
C      LSTV(10,I) = Variable number of item I
C
C
#include "mncmd.inc"
#include "mnprs.inc"
#include "mnprj.inc"
C
      DIMENSION LSTYP(*),LSTP(*),LSTF(*),LSTV(10,*)
C
      CHARACTER*32 COMAND
      CHARACTER*(*) STRING
C
      LOGICAL QMNLFT,QMNRGT
      LOGICAL QEQUAL,QPASS,QEQFND,QEQNOW,QNEW
      CHARACTER*1 TCHR,TCH2
      INTEGER ISTREN(0:5)
C
      EQUIVALENCE (X,IX)
C
      DATA ISTREN/0,1,1,2,2,3/
C
      NCMD  = MPRSE + MDEPI + NVARBL
      CLCNAM(NCMD + 1) = ' '
C
C     Put string in command buffer
C
      LENG = LENOCC(STRING)
      CALL QUOTYP(STRING(1:LENG))
C
      QPASS = .FALSE.
C
C     # OF COMMAS
      NCOMMA = 0
C     # OF UNPAIRED OPERANDS
      NREMN = 0
C     LENGTH OF OPERATOR LIST
      NOP = 0
C     # BINARY OPERATORS
      NBINRY = 0
C     PARENTHESIS LEVEL
      LEVEL = 0
C     LENGTH OF LIST
      NSUB = 0
C
C     LET "." BE PART OF A COMMAND (FOR FLOATING POINT NUMBERS)
C     and allow $_ in variables
C
      CALL ICMSYM('.$_')
C
C     GET STRING
C
      IF(     QEQUAL)CALL WAITYP('Equation: ')
      IF(.NOT.QEQUAL)CALL WAITYP('FORTRAN expression: ')
      TS3SCN = TSDSCN
      TSDSCN = ','
      LENT   = LENOCC(TSDSCN)
      CALL SDLSCN(TSDSCN(1:LENT))
C
C     FORCE STRING TO BE TYPED AT THIS POINT
C
      ICMD = ICMTYP(.TRUE.,IDELIM,CLCNAM)
      CALL RESTYP
C
C     PUT STRING INTO ARRAY TO BE RETURNED TO USER AND RESTORE POINTER
C
      NCHARS = MAX0(0,NCHLFT())
      CALL STRTYP(NCHARS,STRING)
      CALL RESTYP
C
C     GIVE TYPSCN A LIST OF STANDARD DELIMITERS
C
      TSDSCN = ',=()[]{}+-*/^&'
      LENT   = LENOCC(TSDSCN)
      CALL SDLSCN(TSDSCN(1:LENT))
C
C     LOOK FOR UNBALANCED PARENTHESES
C
      NLEFT = 0
      NRIGHT = 0
      NEQUAL = 0
      DO 500 I=1,NCHARS
          TCHR = STRING(I:I)
          IF(QMNLFT(TCHR)) NLEFT  = NLEFT + 1
          IF(QMNRGT(TCHR)) NRIGHT = NRIGHT + 1
          IF(TCHR .EQ. '=' ) NEQUAL = NEQUAL + 1
C
C         UNBALANCED
C
          IF(NRIGHT .GT. NLEFT) THEN
              CALL ZERTYP('Too many ) parentheses: ')
              GOTO 8000
          ENDIF
C
C         UNBALANCED BEFORE "=" SIGN
C
          IF(NRIGHT .NE. NLEFT .AND. TCHR .EQ. '=' ) THEN
              CALL ZERTYP('Unbalanced parentheses before =: ')
              GOTO 8000
          ENDIF
C
500   CONTINUE
C
C     UNBALANCED PARENTHESES
C
      IF(NRIGHT .NE. NLEFT) THEN
          CALL ZERTYP('Unbalanced parentheses: ')
          GOTO 8000
      ENDIF
C
C     NO EQUAL SIGN
C
      IF(NCHARS.GT.0) THEN
          IF(NEQUAL .GT. 1) THEN
              CALL ZERTYP('?Too many equal signs: ')
              GOTO 8000
          ELSE IF(NEQUAL .EQ. 0 .AND. QEQUAL) THEN
              CALL ZERTYP('?No equal sign in expression: '      )
              GOTO 8000
          ELSE IF(NEQUAL .EQ. 1 .AND. .NOT.QEQUAL) THEN
              CALL ZERTYP('?Cannot have equal sign in expression: ')
              GOTO 8000
          ENDIF
      ENDIF
C
C     SCAN THE EXPRESSION
C     HAVE NOT FOUND EQUAL SIGN YET
C
      QEQFND = .FALSE.
      QEQNOW = .FALSE.
      QNEW = .TRUE.
C
      IDELIM = 1
C
2000  CONTINUE
      CALL M_CGET(1,COMAND,ICMD,IDELIM)
C
      ICHL = LCHTYP()
      IOP = IOPTYP(ICHL)
      TCHR = CHAR(ICHL)
      IF(TCHR .EQ. '=') THEN
          QEQFND = .TRUE.
          QEQNOW = .TRUE.
          IOP = 2
      ENDIF
C
C  .....................................................................
C     SQRT, SIN, COS, ETC.
C
      IF (ICMD.GT.0 .AND. ICMD .LE. MPRSE) THEN
C
C         MAKE SURE COMMAND ENDS IN "("
C
          IF(.NOT.QMNLFT(TCHR)) THEN
              CALL ZERTYP('Arithmetic function not followed by "(" ')
              GOTO 8000
          ENDIF
C
C         GET FUNCTION NUMBER - can also be a register, parameter etc.
C
          IFUN = 0
          IF(CLCNAM(ICMD) .EQ. 'FPOS   '   .OR.
     *       CLCNAM(ICMD) .EQ. 'FNEG   '   .OR.
     *       CLCNAM(ICMD) .EQ. 'DFPOS  '   .OR.
     *       CLCNAM(ICMD) .EQ. 'DDFPOS '   .OR.
     *       CLCNAM(ICMD) .EQ. 'DFNEG  '   .OR.
     *       CLCNAM(ICMD) .EQ. 'DDFNEG '   .OR.
     *       CLCNAM(ICMD) .EQ. 'FINT   ') THEN
C
              CALL RESTYP
              CALL M_FGET(1,CLCNAM(ICMD),IFUN,QPASS,IDELIM)
              IF(.NOT.QPASS)GOTO 8000
C
*ICB              ARG = VALTYP(.TRUE.,IDELIM)
              ifun = ivlTYP(.TRUE.,IDELIM)
C
              CALL M_FGET(2,CLCNAM(ICMD),IFUN,QPASS,IDELIM)
          ENDIF
C
C         UPDATE OPERATION LIST
C
          LEVEL = LEVEL + 1
          QNEW = .TRUE.
          QEQNOW = .FALSE.
          NOP = NOP + 1
          LSTOP(NOP)    = 5 + ICMD
          LSTFUN(NOP)   = IFUN
          LSTLEV(NOP)   = LEVEL
          LSTVAR(1,NOP) = 0
C
C     An Ntuple variable - convert it to Xid&idb(ibin,ivar) format with
C     ibin = 0 and position the pointer just before the delimiter
C     Also get the element numbers, if any
C
      ELSEIF(ICMD.GT.MNTP0) THEN
          QNEW = .FALSE.
          QEQNOW = .FALSE.
          call m_eget(lstv(2,nsub+1),idelim,ierr)
          if(ierr.ne.0) then
              CALL ZERTYP('Error getting Ntuple variable element')
              GOTO 8000
          endif
*
*         If the delimiter was ), then set it to 0
*
*ICB          ichl = lchtyp()
*ICB          tchr = char(ichl)
*ICB          if(qmnrgt(tchr)) idelim = 0
C
          IBIN = 0
          ISET = NHP
          IVAR = ICMD - MNTP0
C
          NSUB = NSUB + 1
          NREMN = NREMN + 1
          LSTYP(NSUB)  = MP_NTP + MPRSE
          LSTF(NSUB)   = ISET
          LSTP(NSUB)   = IBIN
          LSTV(1,NSUB) = IVAR
C
C     A variable - convert it to the register number
C     and position the pointer just before the delimiter
C
      ELSEIF(ICMD.GT.MPRSE+MDEPI) THEN
          QNEW = .FALSE.
          QEQNOW = .FALSE.
          CALL M_VRES(IDELIM)
C
          NVAR = ICMD - MPRSE - MDEPI
          IREG = MVAR0 + NVAR
C
C         UPDATE LISTS
C
          NSUB = NSUB + 1
          NREMN = NREMN + 1
          LSTYP(NSUB)  = MP_REG + MPRSE
          LSTP(NSUB)   = IREG
          LSTF(NSUB)   = 0
          LSTV(1,NSUB) = 0
C
C         IF END OF LINE, FINISH UP OPERATIONS
C
          IF(IDELIM .LT. 0)CALL M_PRSO(NSUB,LSTYP,LSTP,LSTF,LSTV)
C
C  .....................................................................
C     GOT "R", now get register number
C     Note that the register number must be a normal number
C
      ELSEIF (COMAND .EQ. 'R' .OR. COMAND.EQ.'IR') THEN
          QNEW = .FALSE.
          QEQNOW = .FALSE.
          CALL RESTYP
          CALL M_RGET(0,COMAND,IREG,QPASS,IDELIM)
          IF(.NOT.QPASS)GOTO 8000
C
C         UPDATE LISTS
C
          NSUB = NSUB + 1
          NREMN = NREMN + 1
          LSTYP(NSUB)  = ICMD
          LSTP(NSUB)   = IREG
          LSTF(NSUB)   = 0
          LSTV(1,NSUB) = 0
C
C         IF END OF LINE, FINISH UP OPERATIONS
C
          IF(IDELIM .LT. 0)CALL M_PRSO(NSUB,LSTYP,LSTP,LSTF,LSTV)
C
C  .....................................................................
C     GOT "P", NOW GET PARAMETER NUMBER
C
      ELSEIF (COMAND .EQ. 'P' .OR. COMAND.EQ.'ERR' .OR.
     1        COMAND.EQ.'ERP' .OR. COMAND.EQ.'ERN' .OR.
     1        COMAND.EQ.'LOLIM' .OR. COMAND.EQ.'HILIM') THEN
          QNEW = .FALSE.
          QEQNOW = .FALSE.
          CALL RESTYP
          CALL M_PGET(1,COMAND,IFUN,IPAR,QPASS,IDELIM)
          IF(.NOT.QPASS) GOTO 8000
C
C         UPDATE LISTS
C
          NSUB = NSUB + 1
          NREMN = NREMN + 1
          LSTYP(NSUB)  = ICMD
          LSTP(NSUB)   = IPAR
          LSTF(NSUB)   = IFUN
          LSTV(1,NSUB) = 0
C
C         IF END OF LINE, FINISH UP OPERATIONS
C
          IF(IDELIM .LT. 0)CALL M_PRSO(NSUB,LSTYP,LSTP,LSTF,LSTV)
C
C  .....................................................................
C     Got "X, DX, Y, or DY" ==>  now get data set number and bin value
C
      ELSE IF (COMAND.EQ.'X'   .OR. COMAND.EQ.'Y'   .OR.
     +         COMAND.EQ.'DX'  .OR. COMAND.EQ.'DY'  .OR.
     +         COMAND.EQ.'DNX' .OR. COMAND.EQ.'DNY' .OR.
     +         COMAND.EQ.'DPX' .OR. COMAND.EQ.'DPY') THEN
          QNEW = .FALSE.
          QEQNOW = .FALSE.
          CALL RESTYP
          CALL M_HGET(1,COMAND,ISET,IBIN,IVAR,QPASS,IDELIM)
          IF(.NOT.QPASS) GOTO 8000
C
C         UPDATE LISTS
C
          NSUB = NSUB + 1
          NREMN = NREMN + 1
          LSTYP(NSUB)  = ICMD
          LSTF(NSUB)   = ISET
          LSTP(NSUB)   = IBIN
          LSTV(1,NSUB) = IVAR
C
C         IF END OF LINE, FINISH UP OPERATIONS
C
          IF(IDELIM .LT. 0)CALL M_PRSO(NSUB,LSTYP,LSTP,LSTF,LSTV)
C
C  .....................................................................
C     REAL NUMBER
C
      ELSE IF (ICMD .EQ. 0) THEN
          QNEW = .FALSE.
          QEQNOW = .FALSE.
          CALL RESTYP
          NCHSAV = MAX0(0,NCHLFT())
          X = RELTYP(.TRUE.,IDELIM)
          IF(IDELIM .GT. 0) THEN
              CALL ZERTYP('Real number messed up: ')
              GOTO 8000
          ENDIF
C
C         UPDATE OPERAND LISTS
C
          NSUB = NSUB + 1
          NREMN = NREMN + 1
          LSTYP(NSUB)  = 0
          LSTP(NSUB)   = IX
          LSTF(NSUB)   = 0
          LSTV(1,NSUB) = 0
C
C         PUT US AT THE POSITION JUST BEFORE DELIMITER
C
          IF(QMNRGT(TCHR) .OR. IDELIM .GE. 0) THEN
              IDELIM = 0
              NSKIP = NCHSAV - MAX0(0,NCHLFT()) - 1
              CALL RESTYP
              DO 2300 I=1,NSKIP
                  ICH = ICHTYP(.TRUE.)
2300          CONTINUE
          ENDIF
C
C  .....................................................................
C     + - * / ** =
C
      ELSE IF (ICMD .LT. 0 .AND. IOP .GT. 0) THEN
C
C         CHECK IF "**"
C
          IF(TCHR .EQ. '*' ) THEN
              ICH2 = ICHTYP(.TRUE.)
              TCH2 = CHAR(ICH2)
              IF(TCH2 .EQ. '*') THEN
                  ICHL = ICHAR('^')
                  IOP = IOPTYP(ICHL)
              ELSE
                  CALL RESTYP
              ENDIF
          ENDIF
C
C         IF AFTER "=", CHANGE + TO - AND VICE VERSA
          IF(TCHR .NE. '=' .AND. QEQFND .AND. LEVEL.EQ.0 .AND.
     *       IOP.LE.2) IOP = 3 - IOP
C
C         IF FIRST COMMAND IS LEADING "+" OR "-", PUT 0 IN OPERAND LIST
C
          IF(TCHR .NE. '=' .AND. IOP .LE. 2 .AND.
     *       (QNEW .OR. QEQNOW)) THEN
              NSUB = NSUB + 1
              NREMN = NREMN + 1
              LSTYP(NSUB)  = 0
              LSTP(NSUB)   = 0
              LSTF(NSUB)   = 0
              LSTV(1,NSUB) = 0
          ENDIF
          QNEW = .FALSE.
          IF(TCHR .NE. '=')QEQNOW = .FALSE.
C
C         SEE IF THERE ARE ANY PENDING OPERATIONS THAT ARE STRONGER
          IHIR = ISTREN(IOP)
          DO 2500 I=NOP,1,-1
              IF(LSTLEV(I) .EQ. LEVEL .AND. LSTOP(I) .LE. 5) THEN
cicb              IF(LSTLEV(I) .EQ. LEVEL) THEN
C
C                 FOUND ONE, ADD TO OPERAND LIST AND REMOVE FROM OPERATOR LIST
C
                  IF(IHIR .LT. ISTREN(LSTOP(I)) ) THEN
                      NSUB = NSUB + 1
                      NREMN = NREMN - 1
                      LSTYP(NSUB)  = -1
                      LSTP(NSUB)   = LSTOP(I)
                      LSTF(NSUB)   = 0
                      LSTV(1,NSUB) = 0
                      NOP = NOP -1
                      NBINRY = NBINRY -1
                   ENDIF
               ENDIF
2500      CONTINUE
C
C         SEE IF THERE ARE ANY PENDING OPERATIONS THAT ARE EQUALLY STRONG
C
          DO 2600 I=1,NOP
              IF(LSTLEV(I) .EQ. LEVEL .AND. LSTOP(I) .LE. 5) THEN
cicb              IF(LSTLEV(I) .EQ. LEVEL) THEN
C
C                 FOUND ONE, ADD TO OPERAND LIST AND REMOVE FROM OPERATOR LIST
C
                  IF(IHIR .EQ. ISTREN(LSTOP(I)) ) THEN
                      NSUB = NSUB + 1
                      NREMN = NREMN - 1
                      LSTYP(NSUB)  = -1
                      LSTP(NSUB)   = LSTOP(I)
                      LSTF(NSUB)   = 0
                      LSTV(1,NSUB) = 0
                      NOP = NOP -1
                      NBINRY = NBINRY -1
                  ENDIF
               ENDIF
2600      CONTINUE
C
C         ADD TO OPERATOR LIST
C
          NOP = NOP + 1
          NBINRY = NBINRY + 1
          LSTOP(NOP) = IOP
          LSTLEV(NOP) = LEVEL
C
C         TOO MANY OPERATORS?
C
          IF(NBINRY .GT. NREMN) THEN
              CALL ZERTYP('Too many binary operators: ')
              GOTO 8000
          ENDIF
C
C  .....................................................................
C
      ELSE IF (ICMD .LT. 0 .AND. QMNLFT(TCHR) ) THEN
          LEVEL = LEVEL + 1
          QNEW = .TRUE.
          QEQNOW = .FALSE.
C
C  .....................................................................
C
      ELSE IF (ICMD .LT. 0 .AND. QMNRGT(TCHR) ) THEN
          CALL M_PRSO(NSUB,LSTYP,LSTP,LSTF,LSTV)
          LEVEL = LEVEL - 1
          QNEW = .FALSE.
          QEQNOW = .FALSE.
C
C  .....................................................................
C
      ELSE IF (ICMD .LT. 0 .AND. TCHR .EQ. ',') THEN
C
C         PUT REMAINING BINARY OPERATORS IN OPERAND LIST
          DO 2800 I=NOP,1,-1
              IF(LSTLEV(I) .EQ. LEVEL .AND. LSTOP(I) .LE. 5) THEN
                  NSUB = NSUB + 1
                  LSTYP(NSUB) = -1
C
C                 FUNCTION # IF "FPOS" ETC.
C
                  LSTF(NSUB)   = LSTFUN(I)
                  LSTP(NSUB)   = LSTOP(I)
                  LSTV(1,NSUB) = LSTVAR(1,I)
C
                  NOP = NOP - 1
                  NREMN = NREMN - 1
                  NBINRY = NBINRY - 1
              ENDIF
2800      CONTINUE
C
          NCOMMA = NCOMMA + 1
          QNEW = .TRUE.
          QEQNOW = .FALSE.
C
C  .....................................................................
C     END OF LINE
C
      ELSE IF (ICMD .LT. 0 .AND. IDELIM .LT. 0 ) THEN
          CALL M_PRSO(NSUB,LSTYP,LSTP,LSTF,LSTV)
          QNEW = .FALSE.
          QEQNOW = .FALSE.
      ENDIF
C
      IF(IDELIM .GE. 0) GOTO 2000
C
C     SEE IF ANYTHING LEFT OVER
C
      CALL M_PRSO(NSUB,LSTYP,LSTP,LSTF,LSTV)
C
      IF(NREMN - NCOMMA .NE. 1) THEN
          CALL ZERTYP('?Too many operands: ')
          GOTO 8000
      ENDIF
C
      QPASS = .TRUE.
      GOTO 8100
C
C     COME HERE IF FAILURE
C
8000  CONTINUE
      NSUB = 0
C
C     Restore standard delimiter and list of characters in a command
C
8100  CONTINUE
      TSDSCN = TS3SCN
      LENT   = LENOCC(TSDSCN)
      CALL SDLSCN(TSDSCN(1:LENT))
      CALL ICMSYM(TSPSYM)
      CALL ZERTYP('.FALSE.')
C
      END
