      SUBROUTINE M_VGET(NMODE,NH,IVAR,TVAR,IELEM,IDELIM,IERR)
C
C-----------------------------------------------------------------------
C
C     Gets a variable name or number
C     NMODE = 0 means just get variable name - no special delimiters
C               no expression allowed
C     NMODE = 1 means just get variable name - allow ) as a delimiter
C               Use the TYP routines for mode 1
C     NMODE = 2 means it is a variable name or expression - no special
C               delimiters
C     NMODE = 3 means it is a variable name or expression - if & or #
C               is found, set IERR and IVAR = 0
C     NMODE = 4 means it is a variable name or expression - if =
C               is found, set IERR and IVAR = 0
C
C     Called by M_HGET, MN_PRJ
C
C-----------------------------------------------------------------------
C
      IMPLICIT NONE
C
#include "mnpar.inc"
#include "mndat.inc"
#include "mninf.inc"
#include "mncmd.inc"
#include "mnlun.inc"
*
      integer nmode,nh,ivar,ielem(9),idelim,ierr
      character*(*) tvar
      character*255 txt1,txt2
      character tuname*32,taxis(3)*3
      integer nval,ioerr,nchr,nchr2,ind,jelem(9),ich,i,istr,lnblnk
     + ,nloop,lenu
*
      integer  inttyp,inttyq,isttyp,isttyq,nchscn,ichtyp
     + ,lchtyp,istrng
      character charuc*1
      external inttyp,inttyq,isttyp,isttyq,nchscn,ichtyp
     + ,lchtyp,istrng,charuc
C
      data taxis/'X','Y','Z'/
C
      IERR = 0
C
C     See if the variable number was given
C
      IF(NMODE.EQ.1) THEN
          NVAL = INTTYP(.TRUE.,IDELIM)
      ELSE
          NVAL = INTTYQ(.TRUE.,IDELIM)
      ENDIF
      call vzero_i(jelem,9)
C
C     Check for a <CR> - although it should not be there
C
      IF(NCHSCN().EQ.0 .AND. IDELIM.LT.0) THEN
          IERR = 5
          GOTO 9000
      ENDIF
C
C     Fill the element number, just in case it is a CWN
C     It does not actually make too much sense to use the variable
C     numbers, but it seems to work.
C     However, I have no idea what happens with REAL*8 etc.!
C
      IF(NVAL.GT.0 .AND. IDELIM.LE.0) THEN
          WRITE(TXT2,'(I8)',IOSTAT=IOERR) NVAL
          call cleft(txt2,1,8)
          NCHR2 = lnblnk(txt2)
          jelem(1) = 1
          GOTO 5000
      ENDIF
C
C     Check if text starts with &. If so return
C     The only valid delimiter is a ' '
C     Get the rest of the string, define end as 1st space.
C
      IF(NMODE.EQ.1) THEN
          CALL RESTYP
          istr = istrng(.true.,txt2,nchr2)
          call restyp
          NCHR = ISTTYP(.TRUE.,IDELIM,TXT1)
      ELSE
          CALL RESTYQ
          istr = istrng(.true.,txt2,nchr2)
          call restyq
          NCHR = ISTTYQ(.TRUE.,IDELIM,TXT1)
      ENDIF
c$$$      write(6,'('' Full string is: '',A)') txt2(:nchr2)
c$$$      write(6,'('' Working on string: '',A)') txt1(:nchr)
      IF((NMODE.EQ.3 .AND.
     +    (TXT1(1:1).EQ.'&' .OR. TXT1(1:1).EQ.'#')) .OR.
     +   (NMODE.EQ.4 .AND. TXT1(1:1).EQ.'=')) THEN
          CALL RESTYQ
          IVAR = 0
          IERR = 0
          IDELIM = ICHAR(TXT1(1:1))
          GOTO 9000
      ENDIF
*
*     Get the string
*
      ind = index(txt2(:nchr2),' ')
      if(ind.gt.0) nchr2 = ind - 1
C
C     See if it is an expression - quickest check is to see if it starts with (
C
      IF(NMODE.GE.2) THEN
          IF(TXT1(1:1).EQ.'(') THEN
              CALL RESTYQ
              IVAR = 0
              IERR = -1
              GOTO 9000
          ENDIF
*
*         See if the string has an operator
*
          DO 1000 I=1,NCHR2
CICB              IF(INDEX('+-*/^()',TXT2(I:I)).GT.0) THEN
              IF(INDEX('+-*/^',TXT2(I:I)).GT.0) THEN
                  CALL RESTYQ
                  IVAR = 0
                  IERR = -1
                  GOTO 9000
              ENDIF
1000      CONTINUE
      ENDIF
C
C     Look to see if the variable name was given
C     This can only be done if NH > 0.
C
      IF(NH.GT.0) THEN
          ind = index(txt1(1:nchr),'(')
          if(ind.gt.0) nchr = ind - 1
*
*         Allow a ) at the end of a variable name with mode 1
*         Not necessary as isttyp uses ) as a delimiter
*
*ICB          if(nmode.eq.1) then
*ICB              ind = index(txt1(1:nchr),')')
*ICB              if(ind.gt.0) nchr = ind - 1
*ICB          endif
*
*         Check if it is really a variable - otherwise assume it is an
*         expression
*         For 1 and 2-D histograms y and z should also be valid variable names
*
          if(ndim.gt.0 .and. ndim.le.2) then
              nloop = iabs(ndim) + 1
          else
              nloop = iabs(ndim)
          endif
c$$$          write(6,'('' Checking '',A,'' against Ntuple variables'')')
c$$$     +     txt1(1:nchr)
          do 3000 i=1,nloop
              if(i.le.iabs(ndim)) then
                  tuname = tdnam(i,nh)
              else
                  tuname = taxis(i)
              endif
              lenu = lnblnk(tuname)
              call cltou(tuname)
c$$$              write(6,'('' Comparing with '',A)')
c$$$     +         tuname(:lenu)
              if(nchr.eq.lenu .and. txt1(1:nchr).eq.tuname) then
                  nval = i
                  goto 3100
              endif
 3000     continue
          call restyq
          ivar = 0
          ierr = -1
          goto 9000
 3100     continue
*
*         Move the pointer until it as at the ( or )
*
          if(ind.gt.0) then
              call restyq
*
*             First make sure I am at the beginning of the variable name
*
 3200         continue
              ich = ichtyp(.true.)
              if(charuc(ich).ne.txt1(1:1)) goto 3200
*
              do i=1,nchr-1
                  ich = ichtyp(.true.)
              enddo
*
              ich = ichtyp(.true.)
*
*             Get the element number (if there is one)
*
              call m_eget(jelem,idelim,ierr)
              ich = lchtyp()
              if(ierr.ne.0) then
                  txterr = 'Error in element number: ' // txt2(:nchr2)
                  call mn_err('M_VGET',txterr)
                  ivar = 0
                  ierr = -1
                  goto 9000
*
*             Skip past the ) if that is the last delimiter
*
*ICB              elseif(ich.eq.ichar(')')) then
*ICB                  ich = ichtyp(.true.)
              endif
          else
              jelem(1) = 1
              jelem(2) = 0
          endif
*
*     If it cannot be a variable name, then () anywhere also
*     indicates an expression
*
      ELSE
          IF(NMODE.GE.2) THEN
              DO 4000 I=1,NCHR
                  IF(INDEX('()',TXT1(I:I)).GT.0) THEN
                      CALL RESTYQ
                      IVAR = 0
                      IERR = -1
                      GOTO 9000
                  ENDIF
 4000         CONTINUE
          ENDIF
          CALL MN_ERR('M_VGET'
     +     ,'You cannot use variable names,' //
     +      ' as you have not specified a plot')
          IERR = 1
          GOTO 9000
      ENDIF
C
5000  CONTINUE
      IVAR  = NVAL
      TVAR  = TXT2(1:NCHR2)
      call ucopy_i(jelem,ielem,9)
C
9000  CONTINUE
      END
