<?php
/*
 * $Horde: mnemo/list.php,v 1.1.2.4 2005/01/03 11:25:59 jan Exp $
 *
 * Copyright 2001-2005 Jon Parise <jon@horde.org>
 *
 * See the enclosed file LICENSE for license information (BSD). If you
 * did not receive this file, see http://www.horde.org/bsdl.php.
 */

@define('MNEMO_BASE', dirname(__FILE__));
require_once MNEMO_BASE . '/lib/base.php';

/* Get the current action ID. */
$actionID = Horde::getFormData('actionID');

/* Sort out the sorting values. */
if (Horde::getFormData('sortby') !== null) {
    $prefs->setValue('sortby', Horde::getFormData('sortby'));
}
if (Horde::getFormData('sortdir') !== null) {
   $prefs->setValue('sortdir', Horde::getFormData('sortdir'));
}

/* Create a Mnemo storage instance. */
require_once MNEMO_BASE . '/lib/Driver.php';
$storage = &Mnemo_Driver::factory($conf['storage']['driver'], Auth::getAuth(),
                                $conf['storage']['params']);
$storage->retrieve();

/* Get the full, sorted memo list. */
$memos = Mnemo::listMemos($storage, MEMO_ANY, $prefs->getValue('sortby'),
                        $prefs->getValue('sortdir'));

/* Page variables. */
$i = 0;
$title = _("Current Notes");

switch ($actionID) {
 case MNEMO_DELETE_MEMOS:
     $items = Horde::getFormData('items');
     if (isset($items) && (count($items) > 0)) {
         foreach ($items as $memo_id) {
             if (isset($memos[$memo_id])) {
                 $storage->deleteMemo($memo_id);
                 unset($memos[$memo_id]);
             }
         }

         if (!PEAR::isError($storage->store())) {
             if (count($items) == 1) {
                 $message = _("Deleted 1 note.");
             } elseif (count($items) > 1) {
                 $message = sprintf(_("Deleted %d notes."), count($items));
             } else {
                 $message = _("No notes were deleted.");
             }
             $notification->push($message, 'horde.success');
         } else {
             $notification->push(_("There was a problem deleting notes."), 'horde.error');
         }
     }
     break;

 case MNEMO_SEARCH_MEMOS:
     /* If we're searching, only list those memos that match the
        search result. */
     /* Get the search parameters. */
     $pattern = Horde::getFormData('search_pattern');
     $search_desc = (Horde::getFormData('search_desc') == 'on');
     $search_body = (Horde::getFormData('search_body') == 'on');

     if (!empty($pattern) && ($search_body || $search_desc)) {
         $search_result = array();
         foreach ($memos as $memo_id => $memo) {
             if (($search_desc && preg_match("/$pattern/i", $memo['desc'])) ||
                 ($search_body && preg_match("/$pattern/i", $memo['body']))) {
                 $search_result[$memo_id] = $memo;
             }
         }

         /* Reassign $memos to the search result. */
         $memos = $search_result;
         $title = _("Search Results");
     }
     break;
}

require MNEMO_TEMPLATES . '/common-header.inc';
require MNEMO_BASE . '/menu.php';
$notification->notify();
require MNEMO_TEMPLATES . '/list/javascript.inc';
require MNEMO_TEMPLATES . '/list/header.inc';
require MNEMO_TEMPLATES . '/list/actions.inc';

$colors = Mnemo::categoryColors();

if (count($memos) > 0) {
    include MNEMO_TEMPLATES . '/list/memo_headers.inc';

    foreach ($memos as $memo_id => $memo) {
        $color = isset($colors[$memo['category']]) ? $colors[$memo['category']] : '#ffffff';
        include MNEMO_TEMPLATES . '/list/memo_summaries.inc';
    }

    include MNEMO_TEMPLATES . '/list/memo_footers.inc';
    include MNEMO_TEMPLATES . '/list/actions.inc';
} else {
    include MNEMO_TEMPLATES . '/list/empty.inc';
}

require MNEMO_TEMPLATES . '/list/footer.inc';
require MNEMO_TEMPLATES . '/common-footer.inc';

$prefs->store();
