/* Copyright (C) 2000-2002 Lavtech.com corp. All rights reserved.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#ifndef _UDM_STORE_H
#define _UDM_STORE_H

#include <stdio.h>
#include "udm_common.h"
#include "udm_crc32.h"

#define UDM_DOCHUNKSIZE (16384)

#define UDM_STOREIND_SIG "msINDEX\0"
#define UDM_STORE_SIG    "msSTORE\0"
#define UDM_URL_SIG      "msURLTB\0"
#define UDM_URLINFO_SIG  "msURLIN\0"
#define UDM_SERVER_SIG   "msSERVR\0"
#define UDM_LINKS_SIG    "msLINKS\0"
#define UDM_SIG_LEN 8
#define UDM_STORE_BITS 0xFFFF      /* bits of rec_id for file no. */

#define UDM_HASH_PRIME 4093
#define UDM_HASH(x)    (((size_t)x) % UDM_HASH_PRIME)

#define UDM_READ_LOCK  0
#define UDM_WRITE_LOCK 1

typedef struct StoreItem {
  urlid_t rec_id;
  long offset;
  long next;
  size_t size;
} UDM_STOREITEM;

typedef struct SortStoreItem {
  long offset;
  UDM_STOREITEM Item;
} UDM_SORTSTOREITEM;

typedef struct {
  urlid_t    rec_id;
  short      status;
  size_t     docsize;
  time_t     next_index_time;
  time_t     last_mod_time;
  urlid_t    referrer;
  short      hops;
  udmcrc32_t crc32;
  short      seed;
  time_t     bad_since_time;
  size_t     site_id;
  size_t     server_id;
  float      pop_rank;
  size_t     infoseek;
} UDM_CACHE_URL; /* url */

typedef struct {
  size_t rec_id;
  short  enabled;
  time_t period;
  int    proxy_port;
  short  maxhops;
  int    gindex;
  int    follow;
  short  deletebad;
  short  use_robots;
  short  use_clones;
  short  max_net_errors;
  time_t net_delay_time;
  time_t read_timeout;
  char   command;
  int    match_type;
  char   case_sense;
  char   nomatch;
  size_t ordre;
  size_t parent;
  size_t weight;
  float  pop_weight;
} UDM_CACHE_SERVER; /* url alias tag category charset lang basic_auth proxy proxy_auth */

typedef struct {
  size_t ot;
  size_t k;
  float weight;
} UDM_CACHE_LINK;

typedef struct {
  long CurrentItemPos;
  const char *subdir;
  const char *basename;
  const char *BASE_SIG;
  const char *indname;
  char *Ifilename;
  char *Sfilename;
  urlid_t rec_id;
  FILE *Ifd, *Sfd;
  UDM_STOREITEM  Item;
  int  mishash;
} UDM_STORE_PARAM;
  

extern __C_LINK int __UDMCALL UdmStoreDoc(UDM_AGENT *A, UDM_DOCUMENT *Doc);
extern __C_LINK int __UDMCALL UdmUnStoreDoc(UDM_AGENT *A, UDM_DOCUMENT *Doc);
extern __C_LINK int __UDMCALL UdmStoreDeleteDoc(UDM_AGENT *A, UDM_DOCUMENT *Doc);
extern __C_LINK int __UDMCALL UdmStoreCheckUp(UDM_AGENT *Agent);


extern __C_LINK char * __UDMCALL UdmExcerptDoc(UDM_AGENT *query, UDM_RESULT *Res,UDM_DOCUMENT *Doc, size_t size);
extern __C_LINK int __UDMCALL UdmOpenBase(UDM_AGENT *A, UDM_STORE_PARAM *P, int mode);
extern __C_LINK int __UDMCALL UdmCloseBase(UDM_STORE_PARAM *P);
extern int UdmStoreSave(UDM_AGENT *Agent, int ns, char *Client);
extern int UdmStoreGet(UDM_AGENT *Agent, int ns, char *Client);
extern int UdmStoreGetByChunks(UDM_AGENT *Agent, int ns, char *Client);
extern int UdmStoreFind(UDM_AGENT *Agent, int ns, char *Client);
extern int UdmStoreDelete(UDM_AGENT *Agent, int ns, char *Client);
extern int UdmStoredCheck(UDM_AGENT *Agent, int ns, char *Client);

#endif
