/* Copyright (C) 2000-2002 Lavtech.com corp. All rights reserved.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#include "udm_config.h"

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <errno.h> 

#include "udmsearch.h"
#include "udm_db_int.h"

#ifdef HAVE_GETOPT_H
#include <getopt.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#define SPLDIR  "splitter"

/** 
   splitter usage
 */
static void usage(void) {

	fprintf(stderr,
"\n\
splitter from %s-%s-%s\n\
http://search.mnogo.ru (C) 1998-2002, LavTech Corp.\n\
\n\
Usage: splitter [OPTIONS]\n\
\n\
Options are:\n\
  -w /path      choose alternative working /var directory\n\
  -f xxx        start at xxx.log, where xxx is a hex number\n\
  -t xxx        stop  at xxx.log, where xxx is a hex number\n\
  -h,-?         print this help page and exit\n\
\n\
Please mail bug reports and suggestions to <general@mnogosearch.org>.\n",
	PACKAGE,VERSION,UDM_DBTYPE);

	return;
}

int main(int argc,char **argv){
	int ch;
	int from=0;
	int to=0xFFF;
	UDM_ENV * Env;

	Env=UdmEnvInit(NULL);

	while ((ch = getopt(argc, argv, "t:f:w:h?")) != -1){
		switch (ch) {
			case 'f':
				sscanf(optarg,"%x",&from);
				if(from<0)from=0;
				if(from>0xFFF)from=0xFFF;
				break;	
			case 't': 
				sscanf(optarg,"%x",&to);
				if(to<0)to=0;
				if(to>0xFFF)to=0xFFF;
				break;
			case 'w':
			 	UdmVarListReplaceStr(&Env->Vars,"VarDir",optarg);
				break;
			case 'h':
			case '?':
			default:
				usage();
				return 1;
				break;
		}
	}
	argc -= optind;
	argv += optind;

	if(argc>0){
		usage();
		return 1;
	}
	{
		UDM_LOGDEL *del_buf=NULL;
		int del_count = 0;
		int dd;
		struct stat sb;
		char dname[1024]="";
		int log;
		const char *vardir=UdmVarListFindStr(&Env->Vars,"VarDir",UDM_VAR_DIR);
		
		/* Open del log file */
		udm_snprintf(dname,sizeof(dname),"%s%c%s%cdel-split.log",vardir,UDMSLASH,SPLDIR,UDMSLASH);
		if((dd=open(dname,O_RDONLY|UDM_BINARY))<0){
			fprintf(stderr, "Can't open del log '%s': %s\n",dname,strerror(errno));
			exit(1);
		}

		/* Allocate del buffer */
		fstat(dd, &sb);
		if (sb.st_size != 0) {
		  del_buf=(UDM_LOGDEL*)malloc((size_t)sb.st_size);
		  del_count=read(dd,del_buf,(size_t)sb.st_size)/sizeof(UDM_LOGDEL);
		}
		close(dd);

		/* Remove duplicates URLs in DEL log     */
		/* Keep only oldest records for each URL */
		if (del_count > 0) {
		  UdmSort(del_buf,(size_t)del_count,sizeof(UDM_LOGDEL), UdmCmpurldellog);
		  del_count = UdmRemoveDelLogDups(del_buf, del_count);
		}

		for(log=from;log<=to;log++){
			UdmSplitCacheLog(Env,log,del_buf,del_count);
			UDMSLEEP(0);
		}
		UDM_FREE(del_buf);
	}
	
	return 0;
}
