/* Copyright (C) 2000-2002 Lavtech.com corp. All rights reserved.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#include "udm_config.h"

#include <stdio.h>
#include <string.h>
#include "udm_uniconv.h"
#include "udm_sgml.h"

__C_LINK int __UDMCALL udm_mb_wc_8bit(UDM_CONV *conv, UDM_CHARSET *cs,int *wc,
             const unsigned char *str,
             const unsigned char *end) {

  const unsigned char *p;

  conv->icodes = conv->ocodes = 1;

        if (*str == '&' && (conv->flags & UDM_RECODE_HTML) ) {
       if ((p = strchr(str, ';')) != NULL) {
         if (str[1] == '#') {
           if (str[2] == 'x' || str[2] == 'X') sscanf(str + 3, "%x;", wc);
           else sscanf(str + 2, "%d;", wc);
         } else {
           *wc = UdmSgmlToUni(str + 1);
         }
         if (*wc) return conv->icodes = (p - str + 1);
       }
     }

     *wc=cs->tab_to_uni[*str];
     return (!wc[0] && str[0]) ? UDM_CHARSET_ILSEQ : 1;
}

__C_LINK int __UDMCALL udm_wc_mb_8bit(UDM_CONV *conv, UDM_CHARSET *cs, int *wc, unsigned char *s, unsigned char *e)
{
     UDM_UNI_IDX *idx;
     
  conv->icodes = conv->ocodes = 1;

     for(idx=cs->tab_from_uni; idx->tab ; idx++){
          if(idx->from <= *wc && idx->to >= *wc){
               s[0]=idx->tab[*wc - idx->from];
               if ((conv->flags && UDM_RECODE_HTML) && (s[0] == '"' || s[0] == '&' || s[0] == '<' || s[0] == '>')) 
                 return UDM_CHARSET_ILUNI;
               return (!s[0] && *wc) ? UDM_CHARSET_ILUNI : 1;
          }
     }
     return UDM_CHARSET_ILUNI;
}
