#ifndef STOPWATCH_H
#define STOPWATCH_H

#include <sys/time.h>
#include <iosfwd>

//----------------------------------------------------------------------------
class StopWatch
{
  public:
    StopWatch(const char *name);
    ~StopWatch();

    void start();
    void stop();

    void reset();

    int compare(const StopWatch &other) const;

    friend std::ostream &operator<<(std::ostream &os, const StopWatch &s);

  protected:
    const char *m_name;

    struct timeval m_start;
    struct timeval m_stop;

    struct timeval m_total;
};

#endif //STOPWATCH_H
