#ifndef XMLVISITORS_H
#define XMLVISITORS_H

#include "File.h"
#include "XMLElements.h"

//----------------------------------------------------------------------------
/**
 * Base class for all XML visitors.
 */
class XMLVisitor
{
  public:
    //------------------------------------------------------------------------
    virtual ~XMLVisitor() {}

    //------------------------------------------------------------------------
    inline void visit(XMLProperty *p) { do_visit(p); }
    inline void visit(XMLText *t) { do_visit(t); }
    inline void visit(XMLNode *n) { do_visit(n); }

  protected:
    //------------------------------------------------------------------------
    XMLVisitor() {}

  private:
    //------------------------------------------------------------------------
    virtual void do_visit(XMLProperty *p) {}
    virtual void do_visit(XMLText *t) {}
    virtual void do_visit(XMLNode *n) {}
};


//----------------------------------------------------------------------------
/**
 * Base class for all XML const visitors.
 */
class XMLConstVisitor
{
  public:
    //------------------------------------------------------------------------
    virtual ~XMLConstVisitor() {}

    //------------------------------------------------------------------------
    inline void visit(const XMLProperty *p) { do_visit(p); }
    inline void visit(const XMLText *t) { do_visit(t); }
    inline void visit(const XMLNode *n) { do_visit(n); }

  protected:
    //------------------------------------------------------------------------
    XMLConstVisitor() {}

  private:
    //------------------------------------------------------------------------
    virtual void do_visit(const XMLProperty *p) {}
    virtual void do_visit(const XMLText *t) {}
    virtual void do_visit(const XMLNode *n) {}
};


//----------------------------------------------------------------------------
/**
 * This visitor is used to write the content of an XMLNode to a file.
 */
class XMLWriteToFileVisitor : public XMLConstVisitor
{
  public:
    //------------------------------------------------------------------------
    /**
     * @param name The name of the file to write to.
     * @throw SyscallException if the file cannot be opened for writing.
     */
    XMLWriteToFileVisitor(const char *name) throw (SyscallException);
    ~XMLWriteToFileVisitor();

  private:
    //------------------------------------------------------------------------
    void do_visit(const XMLProperty *p);
    void do_visit(const XMLText *t);
    void do_visit(const XMLNode *n);

    void writeIndentation();

    //------------------------------------------------------------------------
    File m_file;
    int m_level;
};

#endif //XMLVISITORS_H
