#ifndef GAMEBRIDGE_H
#define GAMEBRIDGE_H

#include "GameInterface.h"

//----------------------------------------------------------------------------
class GameBridge : public GameInterface
{
    SINGLETON_OBJECT(GameBridge);

  public:
    //------------------------------------------------------------------------
    GameBridge();
    ~GameBridge();

    //------------------------------------------------------------------------
    Uint16 getPlayGroundXTiles() const;
    Uint16 getPlayGroundYTiles() const;

    void addXGravityToPlayGround(Uint16 x, Uint16 y, int increment);
    void addYGravityToPlayGround(Uint16 x, Uint16 y, int increment);

    int getXGravity(const SDL_Rect &r) const;
    int getYGravity(const SDL_Rect &r) const;
    int getXVelocity(const SDL_Rect &r) const;
    int getYVelocity(const SDL_Rect &r) const;
    unsigned getFriction(const SDL_Rect &r) const;

    void addObjectToPlayGround(ObjectBase *o);
    void addParticleToPlayGround(ParticleBase *p);

    bool isBackgroundBetween(Uint16 x1, Uint16 y1, Uint16 x2, Uint16 y2) const;

    const Platform *isInLandingZone(const Ship *s) const;

    const Ship *getPlayerShip() const;

    void onShipTakeoff(const Ship *s);
    void onShipLanded(Ship *s, const Platform *platform);
    void onShipFiring(const Ship *s);
    void onShipOutOfFuel(const Ship *s);
};

#endif //GAMEBRIDGE_H
