#include <pgthemewidget.h>

#include "PlayGround.h"
#include "PlayerStatus.h"
#include "PlayerConfiguration.h"

#include "MainMenu.h"
#include "IngameMenu.h"
#include "PlayGroundMenu.h"
#include "GraphicsMenu.h"
#include "SoundMenu.h"
#include "ControlMenu.h"
#include "HighscoreMenu.h"

MENU_SINGLETON_INIT(Ingame);

//----------------------------------------------------------------------
IngameMenu::IngameMenu() throw(GuiMenuException)
{
  getWidget(ID_INGAME_MENU_CONTINUE)->SetEventObject(
    MSG_BUTTONCLICK, this, (MSG_CALLBACK_OBJ)&IngameMenu::onContinue);
  getWidget(ID_INGAME_MENU_CTRL)->SetEventObject(
    MSG_BUTTONCLICK, this, (MSG_CALLBACK_OBJ)&IngameMenu::onCtrl);
  getWidget(ID_INGAME_MENU_GRAPHICS)->SetEventObject(
    MSG_BUTTONCLICK, this, (MSG_CALLBACK_OBJ)&IngameMenu::onGraphics);
  getWidget(ID_INGAME_MENU_SOUND)->SetEventObject(
    MSG_BUTTONCLICK, this, (MSG_CALLBACK_OBJ)&IngameMenu::onSound);
  getWidget(ID_INGAME_MENU_BACK)->SetEventObject(
    MSG_BUTTONCLICK, this, (MSG_CALLBACK_OBJ)&IngameMenu::onBack);

  getWidget(ID_INGAME_MENU_CONTINUE)->Show();
  getWidget(ID_INGAME_MENU_CTRL)->Show();
  getWidget(ID_INGAME_MENU_GRAPHICS)->Show();
  getWidget(ID_INGAME_MENU_SOUND)->Show();
  getWidget(ID_INGAME_MENU_BACK)->Show();
}

//----------------------------------------------------------------------
IngameMenu::~IngameMenu()
{
}

//----------------------------------------------------------------------
PARAGUI_CALLBACK(IngameMenu::onContinue)
{
  MenuManager::getInstance()->changeTo(PlayGroundMenu::getInstance(), false, false);
  return true;
}

//----------------------------------------------------------------------
PARAGUI_CALLBACK(IngameMenu::onCtrl)
{
  MenuManager::getInstance()->changeTo(ControlMenu::getInstance());
  return true;
}

//----------------------------------------------------------------------
PARAGUI_CALLBACK(IngameMenu::onGraphics)
{
  MenuManager::getInstance()->changeTo(GraphicsMenu::getInstance());
  return true;
}

//----------------------------------------------------------------------
PARAGUI_CALLBACK(IngameMenu::onSound)
{
  MenuManager::getInstance()->changeTo(SoundMenu::getInstance());
  return true;
}

//----------------------------------------------------------------------
PARAGUI_CALLBACK(IngameMenu::onBack)
{
  HighscoreMenu::getInstance()->setInsertEntryOnShow(true);
  PlayGroundMenu::getInstance()->restoreBackground();
  MenuManager::getInstance()->changeTo(HighscoreMenu::getInstance(), true, false);
  return true;
}

//----------------------------------------------------------------------
void IngameMenu::eventShow()
{
  getWidget(ID_INGAME_MENU)->Show();
  SetInputFocus();
}

//----------------------------------------------------------------------
void IngameMenu::eventHide()
{
  ReleaseInputFocus();
  getWidget(ID_INGAME_MENU)->Hide();
}

//----------------------------------------------------------------------
bool IngameMenu::eventKeyDown(const SDL_KeyboardEvent *key)
{  
    TranslateNumpadKeys((SDL_KeyboardEvent*)key);
    PlayerConfiguration::Control::KeyConfig *kc =
        PlayerConfiguration::getInstance()->getControl()->getKeyConfig();

    if(key->keysym.sym == kc->escape)
        MenuManager::getInstance()->changeTo(
            PlayGroundMenu::getInstance(), false, false);

    return true;
}
