#include "PlayerMenu.h"
#include "ControlMenu.h"
#include "GraphicsMenu.h"
#include "SoundMenu.h"
#include "OptionMenu.h"

#include <iostream>

MENU_SINGLETON_INIT(Option);

//----------------------------------------------------------------------
OptionMenu::OptionMenu() throw(GuiMenuException)
{
  getWidget(ID_OPTION_MENU_PLAYER)->SetEventObject(
    MSG_BUTTONCLICK, this, (MSG_CALLBACK_OBJ)&OptionMenu::onPlayer);
  getWidget(ID_OPTION_MENU_CTRL)->SetEventObject(
    MSG_BUTTONCLICK, this, (MSG_CALLBACK_OBJ)&OptionMenu::onCtrl);
  getWidget(ID_OPTION_MENU_GRAPHICS)->SetEventObject(
    MSG_BUTTONCLICK, this, (MSG_CALLBACK_OBJ)&OptionMenu::onGraphics);
  getWidget(ID_OPTION_MENU_SOUND)->SetEventObject(
    MSG_BUTTONCLICK, this, (MSG_CALLBACK_OBJ)&OptionMenu::onSound);
  getWidget(ID_OPTION_MENU_BACK)->SetEventObject(
    MSG_BUTTONCLICK, this, (MSG_CALLBACK_OBJ)&OptionMenu::onBack);

  getWidget(ID_OPTION_MENU_PLAYER)->Show();
  getWidget(ID_OPTION_MENU_CTRL)->Show();
  getWidget(ID_OPTION_MENU_GRAPHICS)->Show();
  getWidget(ID_OPTION_MENU_SOUND)->Show();
  getWidget(ID_OPTION_MENU_BACK)->Show();
}

//----------------------------------------------------------------------
OptionMenu::~OptionMenu()
{
}

//----------------------------------------------------------------------
PARAGUI_CALLBACK(OptionMenu::onPlayer)
{
  try
  {
    MenuManager::getInstance()->changeTo(PlayerMenu::getInstance());
  }
  catch(GuiMenuException &e)
  {
    std::cout << e << std::endl;
  }
  return true;
}

//----------------------------------------------------------------------
PARAGUI_CALLBACK(OptionMenu::onCtrl)
{
  try
  {
    MenuManager::getInstance()->changeTo(ControlMenu::getInstance());
  }
  catch(GuiMenuException &e)
  {
    std::cout << e << std::endl;
  }
  return true;
}

//----------------------------------------------------------------------
PARAGUI_CALLBACK(OptionMenu::onGraphics)
{
  try
  {
    MenuManager::getInstance()->changeTo(GraphicsMenu::getInstance());
  }
  catch(GuiMenuException &e)
  {
    std::cout << e << std::endl;
  }
  return true;
}

//----------------------------------------------------------------------
PARAGUI_CALLBACK(OptionMenu::onSound)
{
  try
  {
    MenuManager::getInstance()->changeTo(SoundMenu::getInstance());
  }
  catch(GuiMenuException &e)
  {
    std::cout << e << std::endl;
  }
  return true;
}

//----------------------------------------------------------------------
PARAGUI_CALLBACK(OptionMenu::onBack)
{
  MenuManager::getInstance()->changeTo(getPrevious());
  return true;
}

//----------------------------------------------------------------------
void OptionMenu::eventShow()
{
  getWidget(ID_OPTION_MENU)->Show();
}

//----------------------------------------------------------------------
void OptionMenu::eventHide()
{
  getWidget(ID_OPTION_MENU)->Hide();
}
