#include "StatusBarMenu.h"

#include "PlayerStatus.h"
#include "GameControlBase.h"
#include "Ship.h"

MENU_SINGLETON_INIT(StatusBar);

//----------------------------------------------------------------------
StatusBarMenu::StatusBarMenu() throw(GuiMenuException)
{
    m_score = 0xffffffff;
    m_lastBonusValue = 0xffffffff;
    m_lastFuelValue = 0xffffffff;
    m_lifes = 0xffffffff;

    getWidget(ID_STATUSBAR_MENU_SCORE)->Show();
    getWidget(ID_STATUSBAR_SCORE_ENTRY)->Show();
    getWidget(ID_STATUSBAR_MENU_SHIP)->Show();
    getWidget(ID_STATUSBAR_SHIP_ENTRY)->Show();
    getWidget(ID_STATUSBAR_MENU_BONUS)->Show();
    getWidget(ID_STATUSBAR_BONUS_ENTRY)->Show();
    getWidget(ID_STATUSBAR_MENU_FUEL)->Show();
    getWidget(ID_STATUSBAR_FUEL_ENTRY)->Show();
}

//----------------------------------------------------------------------
StatusBarMenu::~StatusBarMenu()
{
}

//----------------------------------------------------------------------
void StatusBarMenu::eventShow()
{
  getWidget(ID_STATUSBAR_MENU)->Show();
  update();
}

//----------------------------------------------------------------------
void StatusBarMenu::eventHide()
{
  getWidget(ID_STATUSBAR_MENU)->Hide();
}

//----------------------------------------------------------------------
void StatusBarMenu::update()
{
  updateScore();
  updateLifes();
  updateBonus();
  updateFuel();
}

//----------------------------------------------------------------------
void StatusBarMenu::updateScore()
{
    unsigned currentScore = PlayerStatus::getInstance()->getScore();
    if (m_score != currentScore)
    {
        m_score = currentScore;
        PG_Widget* scoreWidget = getWidget(ID_STATUSBAR_SCORE_ENTRY);
        scoreWidget->SetTextFormat("%d", m_score);
        scoreWidget->Redraw();
    }
}

//----------------------------------------------------------------------
void StatusBarMenu::updateLifes()
{
    unsigned currentLifes = PlayerStatus::getInstance()->getLifes();
    if (m_lifes != currentLifes)
    {
      m_lifes = currentLifes;
      PG_Widget* lifeWidget = getWidget(ID_STATUSBAR_SHIP_ENTRY);
      lifeWidget->SetTextFormat("%d", m_lifes);
      lifeWidget->Redraw();
    }
}

//----------------------------------------------------------------------
void StatusBarMenu::updateBonus()
{
    unsigned currentBonus = PlayerStatus::getInstance()->getBonus();
    if (m_lastBonusValue != currentBonus)
    {
        m_lastBonusValue = currentBonus;
        PG_Widget* bonusWidget = getWidget(ID_STATUSBAR_BONUS_ENTRY);
        bonusWidget->SetTextFormat("%d", m_lastBonusValue);
        bonusWidget->Redraw();
    }
}

//----------------------------------------------------------------------
void StatusBarMenu::updateFuel()
{
    const Ship *ship = GameControlBase::getInstance()->getPlayerShip();
    if (!ship)
    {
        return;
    }

    unsigned currentFuel = (unsigned)(((double)(ship->getFuel())) / 
      GameControlBase::getInstance()->getPlayerFuel() * 100);
    if (currentFuel != m_lastFuelValue)
    {
      m_lastFuelValue = currentFuel;
      PG_Widget* fuelWidget = getWidget(ID_STATUSBAR_FUEL_ENTRY);
      SDL_Color col = {0,0,0};
      if(m_lastFuelValue > 50)
        col.g = 255;
      else if(m_lastFuelValue > 25)
        col.r = 255, col.g = 200;
      else
        col.r = 255;
       
      fuelWidget->SetFontColor(col);
      fuelWidget->SetTextFormat("%d%%", m_lastFuelValue);
      fuelWidget->Redraw();
    }
}
