#ifndef GRINDER_H
#define GRINDER_H

#include <cassert>
#include <list>

#include "Tools.h"

#include "XMLVisitors.h"

#include "MovingDecorationBase.h"


//----------------------------------------------------------------------------
class GrinderSurfaces : public RotatingSurfacesBase
{
    SURFACES_SINGLETON_OBJECT(GrinderSurfaces);
};


//----------------------------------------------------------------------------
class Grinder : public MovingDecorationBase
{
    class WayPoint
    {
        //--------------------------------------------------------------------
        class InitializationData
        {
          public:
            InitializationData(const XMLNode *wayPointNode)
                throw (XMLException);
            ~InitializationData();

            Uint16 x;
            Uint16 y;
        };

      public:
        WayPoint(const InitializationData &init);
        ~WayPoint();

        static WayPoint *create(const XMLNode *wayPointNode)
            throw (Exception);

        inline Uint16 getX() const
        {
            return m_x;
        }

        inline Uint16 getY() const
        {
            return m_y;
        }

      private:
        Uint16 m_x;
        Uint16 m_y;
    };

    typedef std::list<WayPoint*> WayPoints;
    typedef WayPoints::iterator WayPointIter;
    typedef WayPoints::const_iterator WayPointCIter;

    //------------------------------------------------------------------------
    class WayPointVisitor;
    friend class WayPointVisitor;
    class WayPointVisitor : public XMLConstVisitor
    {
      public:
        //--------------------------------------------------------------------
        WayPointVisitor(Grinder *grinder) : m_grinder(grinder) {}
        ~WayPointVisitor() { m_grinder = NULL; }

      private:
        //--------------------------------------------------------------------
        void do_visit(const XMLProperty *a);
        void do_visit(const XMLNode *n);

        //--------------------------------------------------------------------
        Grinder *m_grinder;
    };

  public:
    //------------------------------------------------------------------------
    class InitializationData : public MovingDecorationBase::InitializationData
    {
      public:
        InitializationData(const XMLNode *grinderNode)
            throw (XMLException);
        ~InitializationData();

        Uint16 velocity;
    };

    //------------------------------------------------------------------------
    virtual ~Grinder();

    static Grinder *create(const XMLNode *grinderNode)
        throw (Exception);

    //------------------------------------------------------------------------
    void update();

  protected:
    //------------------------------------------------------------------------
    Grinder(const InitializationData &init);

    //------------------------------------------------------------------------
    void initVelocity();

    static Grinder *create(const InitializationData &init);

  private:
    //------------------------------------------------------------------------
    DECLARE_OBJECT_VISITOR_API();

    //------------------------------------------------------------------------
    unsigned m_velocity;

    unsigned m_frameDelay;
    unsigned m_currentFrame;
    unsigned m_frameCounter;

    WayPoints m_wayPoints;
    WayPointCIter m_wayPointIter;
};

#endif //MISSILE_H
