#ifndef SAMBATTERY_H
#define SAMBATTERY_H

#include "Tools.h"
#include "StaticDecorationBase.h"
#include "Missile.h"


//----------------------------------------------------------------------------
class SAMBatterySurfaces : public OrientatingSurfacesBase
{
    SURFACES_SINGLETON_OBJECT(SAMBatterySurfaces);
};


//----------------------------------------------------------------------------
class SAMBatteryBase : public StaticDecorationBase,
                       public OrientatingDecorationBase
{
  public:
    //------------------------------------------------------------------------
    class InitializationData
        : public StaticDecorationBase::InitializationData,
          public OrientatingDecorationBase::InitializationData
    {
      public:
        InitializationData(const XMLNode *samNode)
            throw (XMLException);
        ~InitializationData();

        unsigned delay;
        unsigned missileFuel;
        Missile::EnumHeadingStrategy missileHeadingStrategy;
        Missile::EnumWarheadStrategy missileWarheadStrategy;
    };


    //------------------------------------------------------------------------
    virtual ~SAMBatteryBase();

    static SAMBatteryBase *create(const XMLNode *samNode)
        throw (Exception);

    //------------------------------------------------------------------------
    /**
     * Creates some explosion particles on the SAM's position.
     */
    void createExplosionParticles();

    //------------------------------------------------------------------------
    void update();

  protected:
    //------------------------------------------------------------------------
    SAMBatteryBase(const InitializationData &init);

    //------------------------------------------------------------------------
    virtual Missile *createMissile() const = 0;
    Missile *do_createMissile(Sint16 angle) const;

    //------------------------------------------------------------------------
    static SAMBatteryBase *create(const InitializationData &init);

    //------------------------------------------------------------------------
    unsigned m_frameDelay;
    unsigned m_frameCounter;

  private:
    /// Helper method to set the missile's initial position.
    virtual void do_setInitialMissilePosition(Missile *m) const = 0;

    //------------------------------------------------------------------------
    DECLARE_OBJECT_VISITOR_API();


    /// The initial fuel to use for shooted missiles.
    unsigned m_missileFuel;

    /// The heading strategy to use for shooted missiles.
    Missile::EnumHeadingStrategy m_missileHeadingStrategy;

    /// The warhead strategy to use for shooted missiles.
    Missile::EnumWarheadStrategy m_missileWarheadStrategy;
};


//----------------------------------------------------------------------------
class TopSAMBattery : public SAMBatteryBase
{
  public:
    TopSAMBattery(const InitializationData &init);
    ~TopSAMBattery();

  protected:
    virtual Missile *createMissile() const;

  private:
    void do_setInitialMissilePosition(Missile *m) const;
};

//----------------------------------------------------------------------------
class BottomSAMBattery : public SAMBatteryBase
{
  public:
    BottomSAMBattery(const InitializationData &init);
    ~BottomSAMBattery();

  protected:
    virtual Missile *createMissile() const;

  private:
    void do_setInitialMissilePosition(Missile *m) const;
};

//----------------------------------------------------------------------------
class LeftSAMBattery : public SAMBatteryBase
{
  public:
    LeftSAMBattery(const InitializationData &init);
    ~LeftSAMBattery();

  protected:
    virtual Missile *createMissile() const;

  private:
    void do_setInitialMissilePosition(Missile *m) const;
};

//----------------------------------------------------------------------------
class RightSAMBattery : public SAMBatteryBase
{
  public:
    RightSAMBattery(const InitializationData &init);
    ~RightSAMBattery();

  protected:
    virtual Missile *createMissile() const;

  private:
    void do_setInitialMissilePosition(Missile *m) const;
};

#endif //SAMBATTERY_H
