#ifndef SOUNDFACTORY_H
#define SOUNDFACTORY_H

#include <cassert>

#include "Exception.h"
#include "SDLMixerCalls.h"

//----------------------------------------------------------------------------
class SoundFactory
{
  public:
    //------------------------------------------------------------------------
    enum Sound
    {
        S_BUMP_1 = 0,
        S_CASH_1 = 1,
        S_DING_1 = 2,
        S_EXPLOSION_1 = 3,
        S_EXPLOSION_2 = 4,
        S_EXPLOSION_3 = 5,
        S_SWEEP_1 = 6,
        S_THRUST_1 = 7,
        S_WARP_1 = 8,
        S_ZAP_1 = 9,
        S_ZAP_2 = 10,
        S_TOTAL_NUMBER = 11
    };

    ~SoundFactory();

    //------------------------------------------------------------------------
    inline Mix_Chunk *getChunk(Sound sound) const
    {
        assert(sound >= 0);
        assert(sound < S_TOTAL_NUMBER);

        return m_chunks[sound];
    }

    //------------------------------------------------------------------------
    static void init() throw (Exception);
    static void destroy();

    static inline SoundFactory *getInstance() { return sm_instance; }

  private:
    //------------------------------------------------------------------------
    SoundFactory();

    //------------------------------------------------------------------------
    Mix_Chunk *m_chunks[S_TOTAL_NUMBER];

    //------------------------------------------------------------------------
    static SoundFactory *sm_instance;
};

#endif //SOUNDFACTORY_H
