#ifndef TOOLS_H
#define TOOLS_H

//----------------------------------------------------------------------------
/**
 * Disables the copy constructor and assignment operator,
 * so the object cannot be copied.
 */
#define REFERENCE_OBJECT(O) \
  private: \
    O(const O &other); \
    O &operator=(const O &other)

//----------------------------------------------------------------------------
#define STATE_OBJECT(O) \
    REFERENCE_OBJECT(O); \
  public: \
    static inline O *getInstance() { return &sm_instance; } \
  private: \
    static O sm_instance

//----------------------------------------------------------------------------
#define STRATEGY_OBJECT(O) STATE_OBJECT(O)

//----------------------------------------------------------------------------
#define SINGLETON_OBJECT(O) STATE_OBJECT(O)


//----------------------------------------------------------------------------
#define DECLARE_PIMPL \
  private: \
    class PImpl; \
    PImpl *m_pImpl


//----------------------------------------------------------------------------
#if defined __GNUC__ && ! defined __LINT__
#define MIN(X, Y) ((X) <? (Y))
#define MAX(X, Y) ((X) >? (Y))
#else
#define MIN(X, Y) ((X) < (Y) ? (X) : (Y))
#define MAX(X, Y) ((X) > (Y) ? (X) : (Y))
#endif //!__GNUC__

//----------------------------------------------------------------------------
#define ZAP_POINTER(p) delete p; p = NULL;
#define ZAP_ARRAY(a)   delete [] a; a = NULL;

//----------------------------------------------------------------------------
/**
 * A wrapper for rand(), implemented as described
 * in the NOTES section of "man 3 rand".
 *
 * @return A random number inside of the interval [0, limit).
 */
int myRand(int limit);

#endif //TOOLS_H
