#!/usr/bin/env python
# vim: ai ts=4 sts=4 et sw=4

#    VideoView.py: Manage Video View

#    Copyright (c) 2007 Intel Corporation
#
#    This program is free software; you can redistribute it and/or modify it
#    under the terms of the GNU General Public License as published by the Free
#    Software Foundation; version 2 of the License
#
#    This program is distributed in the hope that it will be useful, but
#    WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
#    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
#    for more details.
#
#    You should have received a copy of the GNU General Public License along
#    with this program; if not, write to the Free Software Foundation, Inc., 59
#    Temple Place - Suite 330, Boston, MA 02111-1307, USA.


import Constant
import GeneralFunc
import sys, os, os.path, string
import pygtk, gobject
import gtk, gtk.gdk, gtk.glade
import string

class VideoView:
    """
    A class which manage video view.
    """

    def __init__(self, app):
        """
        init function
        """
        self.app = app
        self.wTree = gtk.glade.XML('MobilePlayer.glade',root='mp_video_nbk')
        dic = {"on_wm_vm_seekbar_hs_format_value": self.sb_format_value,
               "on_wm_vm_seekbar_hs_change_value": self.sb_change_value,
           }
        self.wTree.signal_autoconnect(dic)

        self.view_nbk = self.wTree.get_widget('mp_video_nbk')
        self.view_nbk.set_show_tabs(False)

        self.state_thumbnail = 0
        self.state_playback = 1
        self.state_share = 2
        self.state_default = 3

        self.state_current = self.state_default

        # if first launch
        self.is_first_launch = True

        # init GUI variables
        self.video_playback_view = self.wTree.get_widget('wm_vm_playback_wd_vb')
        self.video_length_lb = self.wTree.get_widget("wm_vm_video_length_lb")
        self.video_seekbar = self.wTree.get_widget("wm_vm_seekbar_hs")
        self.playback_surface = self.wTree.get_widget('wm_vm_drawarea_da')

        self.fs_mode = False
        self.init_ui()

    def sb_format_value(self, seekbar, cur_value):
        (hours, mins, secs) = GeneralFunc.get_hour_min_sec(cur_value)
        return GeneralFunc.format_time(hours, mins, secs)       

    def sb_change_value(self, seekbar, scrolltype, value):
        new_pos = value
        if new_pos < self.app.media_file_length:
            new_pos = max(0, int(new_pos))
            self.app.SetPosition(new_pos)
        else:
            pass

    def init_ui(self):
        self.view_nbk.set_current_page(self.state_current)
        widget = self.wTree.get_widget('vm_default_view_eb')
        widget.modify_bg(gtk.STATE_NORMAL, Constant.MediaColor['select_window_bg'])
        widget = self.wTree.get_widget('vm_default_view_lb')
        widget.modify_fg(gtk.STATE_NORMAL, Constant.MediaColor['select_label_fg'])

    def update_ui(self, is_last_view):
        self.view_nbk.set_current_page(self.state_current)
        if is_last_view == True:
            pass
        else:
            self.video_length_lb.set_text('')
        self.update_fs_mode_ui(self.fs_mode)

    def update_state_thumbnail(self):
        self.state_current = self.state_thumbnail

    def update_state_playback(self):
        self.state_current = self.state_playback

    def update_state_share(self):
        self.state_current = self.state_share

    def update_state_default(self):
        self.state_current = self.state_default

    def get_render_surface(self):
        self.playback_surface = self.wTree.get_widget('wm_vm_drawarea_da')
        return self.playback_surface

    def is_first_load(self):
        return (self.is_first_launch == True)

    def mark_default_flag(self):
        self.is_first_launch = False
        self.update_ui(True)

    def playback_set_seekbar_range(self, start, end):
        self.video_seekbar.set_range(start, end)

    def playback_set_seekbar_value(self, value):
        self.video_seekbar.set_value(value)

    def playback_set_seekbar_increments(self, step, page):
        self.video_seekbar.set_increments(step, page)

    def playback_set_seekbar_seekable(self, seekable):
        self.video_seekbar.set_sensitive(seekable)

    def playback_set_length_lb(self, text):
        self.video_length_lb.set_text(text)

    def set_fs_mode(self, on):
        self.fs_mode = on
        self.update_fs_mode_ui( on)

    def update_fs_mode_ui(self, on):
        if on :
            self.video_length_lb.hide()
            self.video_seekbar.hide()
        else :
            self.video_length_lb.show()
            self.video_seekbar.show()
