/*

  Copyright (C) 2000, The MITRE Corporation

  Use of this software is subject to the terms of the GNU General
  Public License version 2.

  Please read the file LICENSE for the exact terms.

*/

/*
 * Handles command line switches.  Instantiates the
 * ToDot object and runs it.
 *
 * Author: Kevin H. Grace, kgrace@mitre.org
 *         The MITRE Corporation
 *         202 Burlington Rd
 *         Bedford, MA  01730
 *         
 *
 * $Id$
 *  
 */

#include <ToDot.h>
#include <UtMain.h>
#include <UtString.h>
#include <UtReport.h>

static ToDot* t = 0;

static void Version() {
  char *version = "mmtodot - Mobile Mesh Dot File Writer v1.0\n";
  Report::Info(version);
}

static void Usage() {
  char *usage = "Usage: mmtodot [-ahmv] [-d file] -p port  \n"\
    " -a        , label nodes with LSP age \n"\
    " -d file   , use flags 'file' to enable debug output \n"\
    " -h        , display this help message \n"\
    " -m        , label edges with metrics \n"\
    " -n        , label nodes with LSP sequence number \n"\
    " -p port   , the UDP port number on which mmrp is running \n"\
    " -v        , display version information \n"\
    " -x        , label nodes with external routes \n";  
  Report::Error(usage);
}
		
int main(int argc, char* argv[]) {
  int    flags       = Report::fError | Report::fWarn | Report::fDebug;
  bool showMetrics  = false;
  bool showAge      = false;
  bool showSeq      = false;
  bool showExtRoutes= false;
  bool done = false;
  unsigned short port = 0;
  String debugFile = "";

  Report::UseOstream(&cerr, flags);

  while(!done) {
    int c = getopt(argc,argv,"ad:hmnvxp:");
    switch(c) {
    case 'a':
      showAge = true;
      break;
    case 'd':
      debugFile = optarg;
      break;
    case 'h':
      Usage();
      break;
    case 'm':
      showMetrics = true;
      break;
    case 'n':
      showSeq = true;
      break;
    case 'p':
      port = (unsigned short)String(optarg).Int();
      break;
    case 'v':
      Version();
      exit(0);
      break;
    case 'x':
      showExtRoutes = true;
      break;
    case EOF:
      done = true;
      break;
    default:
      Usage();
    }
  }
  if(optind < argc) Usage();
  
  if(port == 0) {
    Report::Error("Must specify port with '-p' option");
  }

  // Convert any relative file names to absolute paths so we can access them after
  // changing from the current directory
  debugFile  = AbsoluteFilename(debugFile);

  // We must run in the directory where the Unix sockets exists because
  // their names are limited to something like 14 characters
  Chdir("/var/run/mobilemesh");
    
  // In case a signal occurs, register for garbage collection
  GarbageCollection<ToDot>::Register(&t);

  t = new ToDot(port,debugFile,showMetrics,showAge,showSeq,showExtRoutes);
  t->Run();
  delete(t);
  t = 0;

  return(0);
}












