#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string.h>
#include <unistd.h>
#include <libosso.h>
#include <locale.h>
#include <libintl.h>
#include <gtk/gtk.h>
#include <glib.h>

int
main(int argc, char *argv[])
{
osso_context_t *osso_context;
char applet[1024];
GDir *dir;
gchar *tmp;

	gtk_init (&argc, &argv);

	if(argc != 2)
	{
	    printf("Usage:\n");
	    dir = g_dir_open(HCP_LIB_DIR, 0, NULL);
	    while((tmp = (gchar *)g_dir_read_name(dir)) != NULL)
	    {
		if(g_str_has_suffix(tmp, ".so"))
		{
		    g_strdelimit(tmp, ".", '\0');
		    printf("\t%s %s\n", argv[0], tmp);
		}
	    }
	    return 0;
	}

	if(g_str_has_suffix(argv[1], ".so"))
	    sprintf(applet, "%s/%s", HCP_LIB_DIR, argv[1]);
	else
	    sprintf(applet, "%s/%s.so", HCP_LIB_DIR, argv[1]);

	if(!g_file_test ((applet), G_FILE_TEST_EXISTS))
	{
	     fprintf(stderr, "%s does not exist\n", applet);
	     return -1;
	}

	osso_context = osso_initialize(PACKAGE, PACKAGE_VERSION, TRUE, NULL);
	if (!osso_context) 
	{
	    fprintf(stderr, "%s failed to initialize\n", argv[0]);
	    return -1;
	}

	if(g_str_has_suffix(argv[1], ".so"))
	    sprintf(applet, "%s", argv[1]);
	else
	    sprintf(applet, "%s.so", argv[1]);

	if(osso_cp_plugin_execute(osso_context, applet, NULL, FALSE) != OSSO_OK)
	{
	    fprintf(stderr, "%s failed to launch\n", applet);
	    return -1;
	}

	return 0;
}
