/* -*- mode: c; style: linux -*- */

/* keyboard-properties-xkbsk.c
 * Copyright (C) 2007 Jian Han
 *
 * Written by: Jian Han <jian.han@intel.com>
 *             Horace Li <horace.li@intel.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gconf/gconf-client.h>
#include <glade/glade.h>
#include <libxml/parser.h>
#include <moko-finger-scroll.h>

#include "moblin.h"
#include "capplet-util.h"
#include "gconf-property-editor.h"

#include "keyboard-properties-xkbsk.h"

enum
{
   COLUMN_NAME,
   COLUMN_DESCRIPTION,
   COLUMN_LAYOUT,
   NUM_COLUMNS
};

static gboolean 
set_new_layout (GtkTreeSelection *selection, GtkTreeModel *model, 
	GtkTreePath *path, gboolean path_currently_selected, 
	gpointer data)
{
  GConfClient *client = (GConfClient *)data;
  GtkTreeIter iter;
  gchar *layout = NULL;

    layout = g_new0 (gchar, 16);

    if (FALSE == path_currently_selected)
    {
	if (gtk_tree_model_get_iter (model, &iter, path))
	{
            gtk_tree_model_get (model, &iter, COLUMN_LAYOUT, &layout, -1);
            gconf_client_set_string (client, KBKEY(KB_LAYOUT), layout, NULL);
	}
    }

    if (layout) g_free (layout);

    return TRUE;
}

static void 
append_model (GtkWidget *treeview, gchar *name, 
	gchar *desc, gchar *layout, gboolean select)
{
  GtkTreeModel *model;
  GtkTreeIter iter;
  GtkTreePath *item=NULL;

    g_debug("append_model(name=%s, desc=%s, layout=%s, select=%s\n",
	name, desc, layout, (select)?"TRUE":"FALSE");
    model = gtk_tree_view_get_model (GTK_TREE_VIEW(treeview));
    gtk_list_store_append (GTK_LIST_STORE (model), &iter);
    gtk_list_store_set (GTK_LIST_STORE (model), &iter,
                       COLUMN_NAME, name,
                       COLUMN_DESCRIPTION, desc,
                       COLUMN_LAYOUT, layout,
                       -1);

    if(select)
    {
	if((item = gtk_tree_model_get_path (model, &iter)) != NULL)
	{
	    gtk_tree_view_scroll_to_cell(GTK_TREE_VIEW (treeview),
		item, NULL, FALSE, 0, 0);
	    gtk_tree_view_set_cursor(GTK_TREE_VIEW (treeview),
		item, NULL, FALSE);
	    gtk_tree_path_free (item);
	}
    }
}

static void 
generate_layout_tree_view (GtkWidget *treeview,
	GConfClient *client)
{
  gchar *name = NULL, *desc = NULL, *layout = NULL;
  gchar *current_layout;
  GError *error = NULL;
  GSList *dlist, *d;
  gchar *path;

    current_layout = 
	gconf_client_get_string (client, 
	KBKEY(KB_LAYOUT), &error);

    if (error)
    {
	g_warning("failed to get current layout: %s", error->message);
	current_layout = NULL;
    }

    if(!gconf_client_dir_exists(client,
	KBKEY(KB_LAYOUTS), NULL))
    {
	g_warning("Gconf dir does not exist: %s\n",
		KBKEY(KB_LAYOUTS));
	return;
    } 

    if((dlist = gconf_client_all_dirs(client,
	KBKEY(KB_LAYOUTS), NULL)) == NULL)
    {
	g_warning("Gconf dir has no contents: %s\n",
		KBKEY(KB_LAYOUTS));
	return;
    }

    for(d = dlist; d != NULL; d = g_slist_next(d))
    {
	name = desc = layout = NULL;
	layout = g_path_get_basename((const gchar *)d->data);
	path = g_build_filename ((gchar *)d->data, "/name", NULL);
	name = gconf_client_get_string (client, path, NULL);
	g_free (path);
	path = g_build_filename ((gchar *)d->data, "/description", NULL);
	desc = gconf_client_get_string (client, path, NULL);
	g_free (path);
	g_free (d->data);
	if (name && desc && layout)
	{
	    if(current_layout&&!g_strcasecmp(current_layout, layout))
		append_model (treeview, name, desc, layout, TRUE);
	    else
		append_model (treeview, name, desc, layout, FALSE);
	}
	else
	{
	    if(layout) g_free(layout);
	    if(name) g_free(name);
	    if(desc) g_free(desc);
	}
    }
    g_slist_free(dlist);
}

void 
setup_xkbsk_tabs (GladeXML *dialog,
	GConfClient *client)
{
  GtkWidget *treeview = WID ("layouts_treeview");
  GtkWidget *scrollwindow = WID ("scrolledwindow1");
  GtkWidget *box = WID ("hbox_parent");
  GtkWidget *mokoscroll;
  GtkTreeModel *model;
  GtkTreeSelection *selection;
  GtkCellRenderer *renderer;

    renderer = gtk_cell_renderer_text_new ();
    gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (treeview),
                                               -1,      
                                               _("Name"),  
                                               renderer,
                                               "text", COLUMN_NAME,
                                               NULL);

    renderer = gtk_cell_renderer_text_new ();
    gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (treeview),
                                               -1,      
                                               _("Description"),  
                                               renderer,
                                               "text", COLUMN_DESCRIPTION,
                                               NULL);

    selection = gtk_tree_view_get_selection (GTK_TREE_VIEW(treeview));
    gtk_tree_selection_set_mode (selection, GTK_SELECTION_SINGLE);
    gtk_tree_selection_set_select_function (selection, set_new_layout, client, NULL);

    model = GTK_TREE_MODEL (gtk_list_store_new (NUM_COLUMNS, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING));
    gtk_tree_view_set_model (GTK_TREE_VIEW (treeview), model);

    generate_layout_tree_view (treeview, client);

    /* reparent the treeview from the scrolled window to a moko */
    mokoscroll = moko_finger_scroll_new();
    gtk_widget_reparent(treeview, mokoscroll);

    /* destroy the scrolled window */
    gtk_container_remove(GTK_CONTAINER(box), scrollwindow);

    /* add the moko where the scrolled window used to be */
    gtk_box_pack_start(GTK_BOX(box), mokoscroll, TRUE, TRUE, 0);
    gtk_box_reorder_child(GTK_BOX(box), mokoscroll, 0);
    gtk_widget_show (mokoscroll);

    gtk_widget_hide (WID ("auto_launch_tb"));
    gtk_widget_hide (WID ("checkbutton2"));
}
