/*
 * moblin-settings-dbus.h
 *
 * Copyright (C) 2007 Jan Arne Petersen <jap@gnome.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 * USA.
 */

#ifndef __MOBLIN_SYSTEM_DBUS_H__
#define __MOBLIN_SYSTEM_DBUS_H__

#include <config.h>
#include <glib-object.h>
#include <dbus/dbus.h>
#include <dbus/dbus-glib-bindings.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <oobs/oobs.h>
#ifdef HAVE_POLKIT
#include <polkit/polkit.h>
#include <polkit-dbus/polkit-dbus.h>
#endif

#ifdef LOGDEBUG
extern FILE* logfp;
#define PRINTF(args...) if(logfp) fprintf(logfp, args)
#else
#define PRINTF(args...)
#endif

G_BEGIN_DECLS

#define MOBLIN_SYSTEM_TYPE_SERVER              (moblin_system_server_get_type ())
#define MOBLIN_SYSTEM_SERVER(object)           (G_TYPE_CHECK_INSTANCE_CAST ((object), MOBLIN_SYSTEM_TYPE_SERVER, MoblinSystemServer))
#define MOBLIN_SYSTEM_SERVER_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST ((klass), MOBLIN_SYSTEM_TYPE_SERVER, MoblinSystemServerClass))
#define MOBLIN_SYSTEM_IS_SERVER(object)        (G_TYPE_CHECK_INSTANCE_TYPE ((object), MOBLIN_SYSTEM_TYPE_SERVER))
#define MOBLIN_SYSTEM_IS_SERVER_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), MOBLIN_SYSTEM_TYPE_SERVER))
#define MOBLIN_SYSTEM_SERVER_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS ((obj), MOBLIN_SYSTEM_TYPE_SERVER, MoblinSystemServerClass))

typedef struct MoblinSystemServer MoblinSystemServer;
typedef struct MoblinSystemServerClass MoblinSystemServerClass;

struct MoblinSystemServer {
        GObject parent;

	OobsSession *session;
	OobsObject *time_config;
};

struct MoblinSystemServerClass {
        GObjectClass parent;
        DBusGConnection *connection;
#ifdef HAVE_POLKIT
	PolKitContext *pk_context;
#endif
};

GObject *moblin_system_server_get                      (void);

G_END_DECLS

#endif
