#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/Xatom.h>
#include <X11/keysym.h>

#include <stdio.h>
#include <signal.h>
#include <fcntl.h>
#include <stdlib.h>
#include <sys/time.h>
#include <glib.h>
#include <linux/input.h>

#define DEVFILE "/dev/input/touchscreen"

static int evfd;
static int capture = 0;
static int touch = 0;
static int x = -1;
static int y = -1;

const char *ev_msc_codes[] = {
	"SERIAL",
	"PULSELED",
	"GESTURE",
	"RAW",
	"SCAN"
};

static gboolean
get_events()
{
        struct input_event ev;

	if(capture) printf("SIGIO EVENT START\n");

	/* read till sync event */
	while (read(evfd, &ev, sizeof(ev)) != -1) {
                switch (ev.type) {
                case EV_ABS:
                        switch (ev.code) {
                        case ABS_X:
				if(x == -1) x = ev.value;
				printf("EV_ABS ABS_X [x = %d]\n",
					ev.value);
                                break;
                        case ABS_Y:
				if(y == -1) y = ev.value;
				printf("EV_ABS ABS_Y [y = %d]\n",
					ev.value);
                                break;
                        case ABS_Z:
				if(x == -1) x = ev.value;
				printf("EV_ABS ALT_ABS_X [x = %d]\n",
					ev.value);
                                break;
                        case ABS_RX:
				if(y == -1) y = ev.value;
				printf("EV_ABS ALT_ABS_Y [y = %d]\n",
					ev.value);
                                break;
                        default:
				printf("EV_ABS %x [val = %x]\n",
					ev.code, ev.value);
                                break;
                        }
                        break;
                case EV_KEY:
                       switch (ev.code) {
                        case BTN_LEFT:
				printf("EV_KEY BTN_LEFT [val = %x]\n",
					ev.value);
				touch = 1;
				break;
                        case BTN_TOUCH:
				printf("EV_KEY BTN_TOUCH [val = %x]\n",
					ev.value);
				touch = 1;
				break;
                        default:
				printf("EV_KEY %x [val = %x]\n",
					ev.code, ev.value);
				break;
                        }
                        break;
                case EV_SYN:
			switch(ev.code) {
			case SYN_REPORT:
				printf("EV_SYN SYN_REPORT [val = %x]\n",
					ev.value);
				if (capture&&touch&&(x != -1)&&(y != -1))
				{
					printf("TOUCH POINT VALUE: X=%d, Y=%d\n",
						x, y);
					x = -1;
					y = -1;
					touch = 0;
					capture = 0;
				}
				break;
			default:
				printf("EV_SYN %x [val = %x]\n",
					ev.code, ev.value);
			}
                        break;
                case EV_MSC:
			if(ev.code < MSC_MAX) {
				printf("EV_MSC %s [val = %x]\n",
					ev_msc_codes[ev.code], ev.value);
			} else {
				printf("EV_MSC %x [val = %x]\n",
					ev.code, ev.value);
			}
			break;
                default:
			printf("%x %x [val = %x]\n",
				ev.type, ev.code, ev.value);
                }
        }

	if(capture) printf("SIGIO EVENT FINISH\n\n");
        return FALSE;
}

static void
sig_handler(int num)
{
	static int is_busy = 0;

	if(is_busy||(num != SIGIO))
		return;

	is_busy = 1;
	get_events();
        is_busy = 0;
}

int main(int argc, char *argv[])
{
char in[1000];

	evfd = open(DEVFILE, O_RDONLY | O_NONBLOCK);
	if (evfd == -1) {
		fprintf(stderr, "Cannot open device file: %s!\n",
			DEVFILE);
		return -1;
	}

	signal(SIGIO, sig_handler);
	fcntl(evfd, F_SETOWN, getpid());
	fcntl(evfd, F_SETFL, fcntl(evfd, F_GETFL) | FASYNC);

	printf("Dumping Touchscreen Data to stdout\n");
	printf("Type \"showall\" to show all the touchscreen data unfiltered\n");
	printf("Type \"cap\" to simulate the start of a CaptureTouch call\n");
	printf("Type \"quit\" to quit\n\n");

	printf("SHOW ALL MODE\n\n");

	while(1) {
		scanf("%s", (char *)&in);
		if(!strcmp(in, "cap")) {
			printf("CAPTURE TOUCH MODE\n\n");
			x = -1;
			y = -1;
			touch = 0;
			capture = 1;
			printf("CAPTURE START\n\n");
		} else if(!strcmp(in, "showall")) {
			printf("SHOW ALL MODE\n\n");
			capture = 0;
		} else if(!strcmp(in, "quit")) {
			break;
		} 
	}

	return 0;
}
