#! /bin/sh -e

# Get lsb functions
. /lib/lsb/init-functions
. /etc/default/rcS

load_modules() {
  # As the name says. If the kernel supports modules, it'll try to load
  # the ones listed in "MODULES".
  LIST=`/sbin/lsmod|awk '!/Module/ {print $1}'`

  # Get list of available modules
  LOC="/lib/modules/`uname -r`/kernel/drivers/acpi"
  if [ -d $LOC ]; then
	MODAVAIL=`( find $LOC -type f -name "*.o" -printf "basename %f .o\n"; \
		find $LOC -type f -name "*.ko" -printf "basename %f .ko\n" ) | /bin/sh`
  else
	MODAVAIL=""
  fi

  if echo $MODAVAIL | grep -q -w "video"; then
	if ! echo $LIST | grep -q -w "video"; then
		modprobe -b video 2>/dev/null
	fi		
  fi
}

unload_modules() {
  # As the name says. If the kernel supports modules, it'll try to load
  # the ones listed in "MODULES".
  LIST=`/sbin/lsmod|awk '!/Module/ {print $1}'`

  # Get list of available modules
  LOC="/lib/modules/`uname -r`/kernel/drivers/acpi"
  if [ -d $LOC ]; then
	MODAVAIL=`( find $LOC -type f -name "*.o" -printf "basename %f .o\n"; \
		find $LOC -type f -name "*.ko" -printf "basename %f .ko\n" ) | /bin/sh`
  else
	MODAVAIL=""
  fi

  if echo $MODAVAIL | grep -q -w "video"; then
	if echo $LIST | grep -q -w "video"; then
		modprobe -r -b video 2>/dev/null
	fi		
  fi
}

case "$1" in
  start)
    [ -f /proc/modules ] && load_modules
    ;;
  stop)
    [ -f /proc/modules ] && unload_modules
    ;;
  restart)
    $0 stop
    sleep 1
    $0 start
    ;;
  reload|force-reload)
    $0 stop
    sleep 1
    $0 start
    ;;
  *)
    log_success_msg "Usage: /etc/init.d/moblin-applets {start|stop|restart|reload|force-reload}"
    exit 1
esac

exit 0
