/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 2 -*- */
/* GNOME Volume Applet
 * Copyright (C) 2004 Ronald Bultje <rbultje@ronald.bitfreak.net>
 *
 * applet.h: the main applet
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GVA_APPLET_H__
#define __GVA_APPLET_H__

#include <glib.h>
#include <glib/gi18n.h>
#include <stdio.h>
#include <locale.h>
#include <string.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <libintl.h>
#include <strings.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <gconf/gconf-client.h>
#include <libhildondesktop/hildon-status-bar-item.h>
#include <sys/ioctl.h>
#include <sys/soundcard.h>

#include <gtk/gtkicontheme.h>
#include <gtk/gtkimage.h>

#include "dock.h"

G_BEGIN_DECLS

#define GNOME_TYPE_VOLUME_APPLET \
  (gnome_volume_applet_get_type ())
#define GNOME_VOLUME_APPLET(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_TYPE_VOLUME_APPLET, \
			       GnomeVolumeApplet))
#define GNOME_VOLUME_APPLET_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_TYPE_VOLUME_APPLET, \
			    GnomeAppletAppletAppletClass))
#define GNOME_IS_VOLUME_APPLET(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_TYPE_VOLUME_APPLET))
#define GNOME_IS_VOLUME_APPLET_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_TYPE_VOLUME_APPLET))

typedef struct _GnomeVolumeApplet {
  GtkEventBox          parent;

  /* our main icon, which is our panel user interface */
  GtkImage *image;
  int mixerfd;

  /* the docked window containing the volume widget */
  GnomeVolumeAppletDock *dock;
  gboolean pop;

  /* list of volume control elements */
  GList *elements;

  /* gconf */
  GConfClient *client;
  gboolean lock;

  /* timeout ID, used to decouple on disposal */
  guint timeout;

  /* preferences */
  GtkWidget *prefs;

  /* icon theme */
  GdkPixbuf *pix[5];
  gint panel_size;

  /* use same object for setting tooltop */
  gboolean force_next_update;
} GnomeVolumeApplet;

typedef struct _GnomeVolumeAppletClass {
  GtkEventBoxClass klass;
} GnomeVolumeAppletClass;

typedef struct _MoblinVolumeApplet {
  HildonStatusBarItem* item;
  GtkWidget* button;
  GnomeVolumeApplet* applet;
} MoblinVolumeApplet;

int      set_volume(GnomeVolumeApplet *applet, int volume);
int      get_volume(GnomeVolumeApplet *applet);
GType    gnome_volume_applet_get_type (void);
gboolean moblin_volume_applet_setup    (GnomeVolumeApplet *applet);

MoblinVolumeApplet* moblin_volume_applet_new (void);

#define MIXER_DEVICE "/dev/mixer"
#define VOLUME_MAX	100
#define VOLUME_MIN	0

G_END_DECLS

#endif /* __GVA_APPLET_H__ */
