/*
    Copyright (c) Red Flag Software Co.,Ltd
    Copyright (c) 2007 Intel Corporation

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the Free
    Software Foundation; version 2 of the License

    This program is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
    more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc., 59
    Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <libhildondesktop/hildon-status-bar-item.h>
#include <gtk/gtk.h>
#include <locale.h>
#include <libintl.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <expat.h>
#include <sys/types.h>
#include <sys/stat.h>
#define _(string) gettext(string)
#define streq(a,b)      (strcmp(a,b) == 0)
/* 
    <moblin-keyboard-manager>

    <menu >
	<menuItem text=""
		command=""
		closeKeyword=""/>
	<menuItem ... />
	<menuItem ... />
	<menuItem ... />
    </menu>

    </moblin-keyboard-manager>
*/

GtkWidget *icon = NULL;
GtkWidget *g_button = NULL;

enum {
	MENU_0,
	MENU_1,
	NUM_MENUS
};

struct keyboardPlugin
{
	HildonStatusBarItem *item;
	GtkWidget* button;
	GtkWidget *menu;
	//GtkWidget *submenu[NUM_MENUS];
	GSList* submenu;
	gboolean menu_activated;
};

typedef struct _keyboardMenu
{
	GSList* menuItem;
}keyboardMenu;

typedef struct _kmMenuItem
{
	gchar* caption;
	gchar* command;
}kmMenuItem;

keyboardMenu *kbm;

void *keyboard_initialize(HildonStatusBarItem *item, GtkWidget **button);
void keyboard_update(void *data, gint value1, gint value2, const gchar *str);
void keyboard_destroy(void *data);
int keyboard_get_priority(void *data);

void btn_clicked(GtkButton* btn, gpointer data);
void popmenu_pos_func(GtkMenu *menu, gint *x, gint *y,gboolean *in, gpointer data);
static void config_xml_start_cb(void *data, const char *tag, const char **attr);
int menu_config_load(keyboardMenu *kbm, char *filename);
static const char *attr_get_val (char *key, const char **attr);

gboolean softkeyboard_is_running()
{
	char buf[255];
	FILE *fp;
	memset(buf, '\0', 255);
	fp = popen("ps ax | grep matchbox-keyboard | grep -v grep", "r");
	fread(buf, 254, 1, fp);
	fclose(fp);

	g_print("%s\n", buf);
	if(strstr(buf, "matchbox-keyboard"))
		return TRUE;
	else
		return FALSE;
}

static const char *attr_get_val (char *key, const char **attr)
{
  int i = 0;
  
  while (attr[i] != NULL)
    {
      if (!strcmp(attr[i], key))
	return attr[i+1];
      i += 2;
    }
  
  return NULL;
}

void config_xml_start_cb(void *data, const char *tag, const char **attr)
{
  keyboardMenu *state = (keyboardMenu *)data;
  const char            *val;
  kmMenuItem		*kmi=g_new0(kmMenuItem, 1);

  if (streq(tag, "menu"))
    {
      printf("menu~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~!!\n");
    }
  else if (streq(tag, "menuItem"))
    {
      printf("menuItem~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~!!\n");
      if ((val = attr_get_val("text", attr)) == NULL)
      {
    	error("menuItem has no text.\n");
      }
      else
      {
	kmi->caption=g_strdup(val);
      }

      if ((val = attr_get_val("command", attr)) == NULL)
      {
    	error("menuItem has no command.\n");
      }
      else
      {
	kmi->command=g_strdup(val);
      }
      state->menuItem=g_slist_append(state->menuItem,kmi);
    }
}

int menu_config_load(keyboardMenu *kbm, char *filename)
{
  char                  *data;
  XML_Parser             p;
  FILE*          	fp;
  struct stat    	stat_info;
  int 			n;

  if ((fp = fopen(filename, "rb")) == NULL) 
       error("Couldn't find a menu config file\n");

 if (stat(filename, &stat_info)) 
    error("Couldn't find stat_info\n");

  data = malloc(stat_info.st_size + 1);

  n = fread(data, 1, stat_info.st_size, fp);

  if (n >= 0) data[n] = '\0';

  p = XML_ParserCreate(NULL);

  XML_SetElementHandler(p, config_xml_start_cb, NULL);

  XML_SetUserData(p, (void *)kbm);

  if (! XML_Parse(p, data, strlen(data), 1)) 
  {
    fprintf(stderr,
	    "moblin-keyboard-manager: XML Parse error at line %d:\n%s\n of %s\n",
	    XML_GetCurrentLineNumber(p),
	    XML_ErrorString(XML_GetErrorCode(p)),
	    filename);
    error("XML Parse failed.\n");
  }
  fclose(fp);
  return 1;
}

static void menu_deactivate_cb(GtkMenuShell *menushell, gpointer data)
{
	g_return_if_fail(data);
	struct keyboardPlugin *bat = (struct keyboardPlugin *)data;

	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(bat->button), FALSE);
	bat->menu_activated = FALSE;
}

static void menuItem_cb (GtkMenuItem *item, gpointer data)
{
	gchar* command=g_strdup_printf("%s &",data);	
	printf("Command is %s\n",command);

	system(command);
}



void popmenu_pos_func(GtkMenu *menu, gint *x, gint *y,
		gboolean *in, gpointer data)
{
	GtkAllocation *a, *ma;
	GtkWidget *toplevel;
	gint tx, ty;

	g_return_if_fail(x && y);
	g_return_if_fail(data);
	g_return_if_fail(GTK_IS_WIDGET(((struct keyboardPlugin *)(data))->item));

	a = &(GTK_WIDGET(((struct keyboardPlugin *)(data))->item)->allocation);

	gtk_widget_realize(GTK_WIDGET(menu));
	ma = &GTK_WIDGET(menu)->allocation;

	toplevel =
		gtk_widget_get_toplevel(GTK_WIDGET(((struct keyboardPlugin *)(data))->item));

	if(GTK_WIDGET_TOPLEVEL(toplevel))
	{
		gdk_window_get_position(toplevel->window, &tx, &ty);
		*x = (tx + a->x + a->width) - ma->width;
	}
	*y = 52;
}

void btn_clicked(GtkButton* btn, gpointer data)
{
	GSList* tmp;
	GtkWidget *submenuitem;
     
	if(softkeyboard_is_running()) { 
		system("killall matchbox-keyboard &");
		remove("/tmp/keyboard.run");  
		remove("/var/run/keyboard.pid");
		return;
	} 
	
	struct keyboardPlugin *bat;
	g_return_if_fail(data);
	bat = (struct keyboardPlugin *)data;

	if(bat->menu_activated)
		return;

	if (!GTK_IS_MENU(bat->menu)) {
		bat->menu = gtk_menu_new();
		
		tmp=kbm->menuItem;
		while(tmp!=NULL)
		{
			submenuitem=gtk_menu_item_new_with_label(((kmMenuItem *)(tmp->data))->caption);
			gtk_menu_shell_append(GTK_MENU_SHELL(bat->menu),submenuitem);
			g_signal_connect(G_OBJECT(submenuitem),"activate",G_CALLBACK(menuItem_cb),((kmMenuItem *)(tmp->data))->command);
			bat->submenu=g_slist_append(bat->submenu,submenuitem);

			tmp=g_slist_next(tmp);
		}

		g_signal_connect(G_OBJECT(bat->menu),
				"deactivate",
				G_CALLBACK(menu_deactivate_cb),
				bat);

		gtk_widget_show_all(bat->menu);
	}

	gtk_menu_shell_select_first(GTK_MENU_SHELL(bat->menu), TRUE);

	gtk_menu_popup(GTK_MENU(bat->menu), NULL, NULL,
			popmenu_pos_func, data,
			1/* left mouse button */,
			gtk_get_current_event_time());

	g_signal_emit_by_name(G_OBJECT(bat->button), "released");
	bat->menu_activated = TRUE;
}

void keyboard_entry (HildonStatusBarPluginFn_st *fn)
{
	if (fn == NULL)
	{
		return;
	}

	fn->initialize = keyboard_initialize;
	fn->destroy = keyboard_destroy;
	fn->update = keyboard_update;
	fn->get_priority = keyboard_get_priority;
}



void *keyboard_initialize(HildonStatusBarItem *item, GtkWidget **button)
{
	kbm=g_new0(keyboardMenu, 1);
	struct keyboardPlugin *bat = g_new0(struct keyboardPlugin, 1);

	bat->item = item;
	g_button = *button = bat->button = gtk_button_new();
	g_signal_connect (g_button, "clicked", G_CALLBACK (btn_clicked), bat);
	
	icon = gtk_image_new_from_file("/usr/share/pixmaps/libkeyboard.png");
	gtk_container_add(GTK_CONTAINER(g_button), GTK_WIDGET(icon));	
	gtk_widget_show(icon);
	gtk_widget_show (g_button);
	//kbm = (keyboardMenu *)util_malloc0(sizeof(keyboardMenu));
	menu_config_load(kbm, "/usr/share/moblin-keyboard-manager/menu.xml");
	return (void *) bat;
}
     


        
void keyboard_update(void *data, gint value1, gint value2, const gchar *str)
{

	if (!data)
	{
		return;
	}

	struct keyboardPlugin *bat = (struct keyboardPlugin *) data;

	return;
}        
     

 
void keyboard_destroy(void *data)
{

	if (!data)
	{
		return;
	}

	g_free(data);
}

    
gint keyboard_get_priority(void *data)
{
	return 42;
}

