#!/usr/bin/env python
# vim: ai ts=4 sts=4 et sw=4

#    MobilePlugins.py: Manage Plugins

#    Copyright (c) 2007 Intel Corporation
#
#    This program is free software; you can redistribute it and/or modify it
#    under the terms of the GNU General Public License as published by the Free
#    Software Foundation; version 2 of the License
#
#    This program is distributed in the hope that it will be useful, but
#    WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
#    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
#    for more details.
#
#    You should have received a copy of the GNU General Public License along
#    with this program; if not, write to the Free Software Foundation, Inc., 59
#    Temple Place - Suite 330, Boston, MA 02111-1307, USA.

import Constant
import GeneralFunc
import sys, os, os.path, string
import pygtk, gtk
import subprocess
import ConfigParser

class Plugin:
    def __init__(self, filename, section='Media Plugin'):
        parser = ConfigParser.ConfigParser()
        parser.read(filename)
        self.name = parser.get(section, 'Name')
        self.cmd = parser.get(section, 'Exec')
        self.icon = parser.get(section, 'Icon')
        self.ext = []
        try:
            self.hint = parser.get(section, 'Hint')
        except:
            self.hint = ''
        try:
            tmp = parser.get(section, 'Ext')
            for type in string.split(tmp, ','):
                type = type.strip().lower()             
                try:
                    type = type.encode("ascii")
                except:
                    continue
                self.ext.append(type)
        except:
            pass
        # print 'Plugin: ', self.name, '\n', self.__str__()

    def __str__(self):
        return ("<name='%s' hint='%s' exec='%s' icon='%s' ext='%s'>" %
                (self.name, self.hint, self.cmd, self.icon, self.ext))

class PluginButton(gtk.Button):
    def __init__(self):
        gtk.Button.__init__(self)
        self.set_relief(gtk.RELIEF_NONE)
            
    def connect_to_plugin(self, plugin):
        self.plugin = plugin
        self.icon = self.set_button_image(plugin.icon)
        self.set_tooltip(plugin.hint)
        self.pack(self.icon)
        self.args = []
        self.command = []
        self.connect_signal()
        self.update_args(self.args)
        
    def set_button_image(self, image):
        icon = gtk.Image()
        if os.path.isfile(image) == False:
            icon.set_from_stock(gtk.STOCK_NO, gtk.ICON_SIZE_SMALL_TOOLBAR)
        else:
            icon.set_from_file(image)
        return icon
    
    def pack(self, image):
        box = gtk.VBox()
        box.pack_start(image, True, True)
        self.add(box)
        
    def set_tooltip(self, tip):
        """
        add hint
        """
        self.tooltip = gtk.Tooltips()
        self.tooltip.set_tip(self, tip)
    
    def connect_signal(self):
        self.connect('clicked', self.launch, self)
      
    def launch(self, button, plugin):
        # no args
        if plugin.args.count == 0:
            print 'no args found'
        # with args
        else:
            print 'args:', plugin.args
            
        # make a command sequence
        self.make_cmd(self.plugin.cmd, self.args)
        
        try:
            # it's a async call of another process
            retpid = subprocess.Popen(self.command).pid
            # print 'child pid:', retpid
        except OSError, e:
            print "Execution failed:", e

     
    def make_cmd(self, exe, args):
        # clear self.command
        self.command = []
        # append exec
        self.command.append(exe)
        # if no args
        if args.count == 0:
            print 'command is:', self.command
            # enough for launch
            return
        else:
            # args should only contain files with proper extentions
            args = filter(self.matchtype, args)
            for arg in args:
                self.command.append(arg)
            print 'command is:', self.command
       
    def update_args(self, args):
        """
        for other application to update args
        """
        if args != None:
            self.args = args #if args == None: self.args = self.args
            
        final_args = filter(self.matchtype, self.args)
        if len(self.args) == 0 or len(final_args) == 0 or len(self.args) != len(final_args):
            self.hide_bn()
        else:
            self.show_bn()
    
    def matchtype(self, args):
        return os.path.splitext(args)[1][1:].lower() in self.plugin.ext
            
    def hide_bn(self):
        self.hide()
        
    def show_bn(self):
        self.show_all()
        

class MediaPlugin:
    """
    Manage Plugins for Mobile Player
    """
    def __init__(self):
        self.plugin_list = []
        if os.path.isdir(Constant.MediaPluginsDir):
            for f in os.listdir(Constant.MediaPluginsDir):
                try:
                    self.plugin_list.append(
                        Plugin(os.path.join(Constant.MediaPluginsDir, f)))
                except:
                    continue

    def get_plugin_count(self):
        return self.plugin_list.count
    
    def get_plugin_list(self):
        return self.plugin_list


		
