#!/usr/bin/env python
# vim: ai ts=4 sts=4 et sw=4
#    MusicManag.py: music management class
# 
#    Copyright (c) 2007 Intel Corporation
#
#    This program is free software; you can redistribute it and/or modify it
#    under the terms of the GNU General Public License as published by the Free
#    Software Foundation; version 2 of the License
#
#    This program is distributed in the hope that it will be useful, but
#    WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
#    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
#    for more details.
#
#    You should have received a copy of the GNU General Public License along
#    with this program; if not, write to the Free Software Foundation, Inc., 59
#    Temple Place - Suite 330, Boston, MA 02111-1307, USA.

import os
from os.path import walk, join, normpath
from os import chdir, remove
import random
import mutagen.id3
import mutagen.mp3
import string
from xml.dom import minidom
import PlayList
import gnomevfs
import FileIO
import Constant
import MoblinMedia

MUSICMANAGDIR = os.path.join(Constant.MediaStreamPath, '.playlist')
DEFAULTLIBPATH= os.path.join(Constant.MediaStreamPath, 'audio')

class MusicManag:
    def __init__(self, app):
        self.app = app
        #pathList=[pathName]
        self.pathList = []
        #allSongList=[fileDir]
        self.allSongList = []
	self.internetRadioList = []
        #albumSongDict={fileName:fileDir}
        self.albumSongDict = {}
        #albumDict={albumName:[artist, date, songNumber, coverFile, albumSongDict]}
        self.albumDict = {}
        #infoDataBaseDict={filename:{title:,artist:,albumName:,coverFile:,date:,length:,albumCover:}}
        self.infoDataBaseDict = {}
        #fileListList=[listName]
        self.fileListList = []
        #allListDict={listName: playList object}
        self.allListDict = {}
        if os.path.isdir(MUSICMANAGDIR):
            pass
        else:
            os.mkdir(MUSICMANAGDIR)
        #m3u file to recorder all list name
        self.allListFileName = os.path.join(MUSICMANAGDIR, 'fileListList')
    
        self.listNumber = 0
        self.repeatSetted = False
        self.shuffleSetted = False

        self.addPathToLib(DEFAULTLIBPATH)

        if os.path.isfile(self.allListFileName):
            pass
        else:
            self.allListFile = file(self.allListFileName,'w')
            self.allListFile.close()

	al = self.newList('allSongList')
        al.songsUri = self.allSongList[:]
        al.queue = al.songsUri[:]
	
        self.updateAllListFile()
        al.updateListFile()

        self.defaultPlayList = al
    
        self.currentPlayList = al
        #load exist fileList
        walk(MUSICMANAGDIR, self.loadFileList, 0)
        
    def __del__(self):
        pass

    def setShuffle(self, shuffle=True):
        self.shuffled = shuffle
        for pl in self.allListDict.values():
            pl.setShuffle(shuffle)
    
    def setRepeat(self, repeated=True):
        self.repeated = repeated
        for pl in self.allListDict.values():
            pl.setRepeat(repeated)

    def loadFileList(self, arg, dirname, names):
        for file in names:
	    print 
            listName = file[:-4]
	    #if listName == 'internetRadioList':
            #    continue
	    if listName == 'allSongList':
                continue
            if file[-4:]=='.m3u':
		print "loadFileList", listName
                al=self.newList(listName)
                al.songsUri=FileIO.getUrisFromFile(normpath(join(dirname,file)),ext='.m3u')
                al.queue= al.songsUri[:]
            elif file[-4:] =='.pls':
                al=self.newList(listName)
                al.songsUri=FileIO.getUrisFromFile(normpath(join(dirname, file)),ext='.pls')
                al.queue =al.songsUri[:]
            elif file[-4:]=='.xml':
                al=self.newList(listName)
                al.songsUri=FileIO.getUrisFromFile(normpath(join(dirname, file)),ext='.xml')
                al.queue=al.songsUri[:]
            else:
                pass
        return

    def usrLoadFileList(self, filename):
        listName = filename[:-4]
        if listName == 'allSongList':
            print 'please change the file list\'s name!'
            return False
	if listName == 'internetRadioList':
            print 'please change the file list\'s name!'
            return False
        if file[-4:]=='.m3u':
            al=self.newList(listName)
            al.songsUri=FileIO.getUrisFromFile(normpath(join(dirname,file)),ext='.m3u')
            al.queue= al.songsUri[:]
        elif file[-4:] =='.pls':
            al=self.newList(listName)
            al.songsUri=FileIO.getUrisFromFile(normpath(join(dirname, file)),ext='.pls')
            al.queue =al.songsUri[:]
        elif file[-4:]=='.xml':
            al=self.newList(listName)
            al.songsUri=FileIO.getUrisFromFile(normpath(join(dirname, file)),ext='.xml')
            al.queue=al.songsUri[:]
        else:
            pass
        return True

    def getAllSongDict(self, arg, dirname, names):
        for file in names:
            if file[-4:]==".mp3" or file[-4:]==".aac" or file[-4:]==".wav" or file[-4:]==".wma" or file[-3:]==".rm" or file[-4:]==".ogg":
                filepath = normpath(join(dirname,file))
                self.allSongList.append(filepath)
        return

    def getAudioLibrary(self, pathStr):   
        pathArray =  pathStr.split(';')
        for items in pathArray:
            if items not in self.pathList:
                print 'new path is ', items
                self.pathList.append(items)
                print 'pathList:', self.pathList
                walk(items, self.getAllSongDict, 0)
		for song in self.allSongList:
		    print 'in allSongList: %s \n' % song
            else:
                print 'This path has already existed.'
        return

    def updateAllListFile(self):
        if os.path.isfile(self.allListFileName):
            f = file(self.allListFileName, "w")
            for listName in self.fileListList:
                f.write(listName)
                f.write('\n')
            f.close()
        else:
            print 'no allListFile exist!'        

    def newList(self,listName):
        if listName in self.fileListList:
            print 'this list has existed!', listName
            return 0
        else:
            pl = PlayList.PlayList(listName)
            self.fileListList.append(listName)
            self.allListDict[listName] = pl 
            self.updateAllListFile()
            return pl
    
    def renameList(self, listName, newName):
        if newName == listName:
            return True
        elif listName =='allSongList':
            print 'can\'t change allSongList\'s name!'
            return False
        elif listName =='internetRadioList':
            print 'can\'t change internetRadioList\'s name!'
            return False
        elif newName in self.fileListList:
            print newName, ' has already existed!'
            return False
        else:
            pl= self.getList(listName)
            pl.rename(newName)
            self.allListDict[newName]=pl
            del self.allListDict[listName]
            index1 = self.fileListList.index(listName)
            self.fileListList.insert(index1, newName)
            self.fileListList.remove(listName)
            self.updateAllListFile()
            return True

    def getDefaultList(self):
        return self.defaultPlayList
    
    def getAllList(self):
	return self.allListDict

    def getList(self, listName):
        if self.allListDict.has_key(listName):
            return self.allListDict[listName]
        else:
            print 'no such list named', listName
	    # fix me
            return 'no such list!'

    def delList(self,listName):
        if listName == 'allSongList':
            print 'can\'t delete allSongList!'
	elif listName == 'internetRadioList':
            print 'can\'t delete internetRadioList'
        elif listName in self.fileListList:
            self.fileListList.remove(listName)
            pl = self.getList(listName)
            if os.path.isfile(pl.listFileName):
                os.remove(pl.listFileName)
		print pl.listFileName
            del self.allListDict[listName]
            del pl
            self.updateAllListFile()
        else:
            print "can't find the list name in media database!\n"
        return
                
    def getAlbumCover(self,fileName,coverName):
        try:
            tag = mutagen.id3.ID3(fileName)
        except:
            return False
        f = file(coverName,"wr")
        count =0
        for frame in tag.getall("APIC"):
            count +=1
            f.write(frame.data)
            f.flush()
            f.seek(0,0)
        f.close()
        if count != 0:
            return True
        else:
            os.remove(coverName)
            return False
            
    def normLength(self, length):
    	hour = int(int(length)//(60*60))
        if (hour//10):
            outTime =str(hour)
        else:
            outTime ='0'+str(hour)
    	length1 = int(length) - (hour*60*60)
        minute = int(length1 //60)
        if (minute//10):
            outTime +=':' + str(minute)
        else:
            outTime +=':' + '0' + str(minute)
    	second = length1 - minute*60
        if (second//10):
            outTime +=':' + str(second)
        else:
            outTime +=':' + '0' + str(second)
        return outTime

    def getMp3Info(self, fileDir):
    	#fInfo ={artist:, album:, tracknum:, date:, length:, albumcover:}
        fInfo={}
        try:
            mp3file = mutagen.File(fileDir)
        except:
            print 'it\'s not a real mp3 file!'
            return fInfo
        try:
            title = str(mp3file['TIT2'])
        except:
            title ='Unknown'
        try:
            artist = str(mp3file['TPE1'])
        except:
            artist ='Unknown'
        try:
            album = str(mp3file['TALB'])
        except:
            album ='Unknown'
        try:
            tracknum = str(mp3file['TRCK'])
        except:
            tracknum ='Unknown'
        try:
            date = str(mp3file['TDRC'])
        except:
            date ='Unknown'
        try:
            audio = mutagen.mp3.MP3(fileDir)
            length1 = audio.info.length
            length = self.normLength(length1)

        except:
            length = 'Unknown'
            
        albumcover = fileDir.replace('.mp3','.jpg')
        fInfo['title'] = title
        fInfo['artist'] = artist
        fInfo['album'] = album
        fInfo['tracknum']=tracknum
        fInfo['date'] =date
        fInfo['length']=length
        
        if self.getAlbumCover(fileDir, albumcover):
            fInfo['albumcover']=albumcover
        else:
        	fInfo['albumcover']='Unknown'
        return fInfo

    def getAudioInfo(self, fileDir):
        fileInfo ={}
        fileName = (os.path.split(fileDir))[1] 
    	if fileDir[-4:] == ".mp3":
            fileInfo=self.getMp3Info(fileDir)
            if len(fileInfo) != 0:
		    return fileInfo
        fileInfo['title'] = 'Unknown'
        fileInfo['artist'] = 'Unknown'
        fileInfo['album'] = 'Unknown'
        fileInfo['tracknum']='Unknown'
        fileInfo['date'] ='Unknown'
        fileInfo['length']='Unknown'
        fileInfo['albumcover']='Unknown'
        #elif fileName == ".wav" or fileName==".wma" or fileName==".aac" or fileName==".ogg" or fileName==".rm"
        #set default value for these streams
        if fileInfo['title'] == 'Unknown':
            fileInfo['title'] = fileName    	
        return fileInfo
		
    #go over all files, to get all the file information by calling 3rd party APIs.
    def setInfoDataBase(self):
        fileInfo={}
        for fileDir in self.allSongList:
            self.infoDataBaseDict[fileName]=self.getAudioInfo(fileDir)
	for fileDir in self.internetRadioList:
            self.infoDataBaseDict[fileName]=self.getAudioInfo(fileDir)
        return
        
    def getTrackFeatures(self,trackName):
        if infoDataBaseDict.has_key(trackName):
            return infoDataBaseDict[trackName]

    def getAlbumInfo(self, albumName):
        if albumName in self.albumInfo:
            return self.albumInfo[albumName]
            
    #from infoDataBaseDict, find which files are in the same album
    #need to define the structure of album database firstly???
    def setAlbumDataBase(self): 
        pass
    
    def addPathToLib(self, pathName):
        self.getAudioLibrary(pathName)
        return

    def play(self, currentName):
	print "play----------------------", currentName
        pl = self.currentPlayList
        if currentName in pl.songsUri:
            while(1):
                self.app.service.OpenUri(currentName)
                self.app.service.Play()
                #need to get the signal of playback complete
                newIndex = pl.getNextSong()
                if newIndex == -1:
                    print 'end of playlist.'
                    return False
                else:
                    currentName = pl.songsUri[newIndex]

    def playPrev(self,currentName):
        pl = self.currentPlayList
        if currentName in pl.songsUri:
            currentIndex = pl.getIndex(currentName)
            newIndex = pl.getPrevSong(currentIndex)
            newName = pl.songsUri[newIndex]
            self.app.service.OpenUri(newName)
            self.app.service.Play()
            return True
        else:
            return False

    def playNext(self,currentName):
        pl = self.currentPlayList
        if currentName in pl.songsUri:
            currentIndex = pl.getIndex(currentName)
            newIndex = pl.getNextSong(currentIndex)
            newName = pl.songsUri[newIndex]
            self.app.service.OpenUri(newName)
            self.app.service.Play()
            return True
        else:
            return False    

    def getPrev(self):
        pl = self.currentPlayList
	currentName = pl.currentName
        if currentName in pl.songsUri:
            currentIndex = pl.getIndex(currentName)
            newIndex = pl.getPrevSong(currentIndex)
	    if not newIndex ==-1:
		newName = pl.songsUri[newIndex]
		#pl.setCurrentName(newName)
		return newName
        else:
            return None

    def getNext(self):
        pl = self.currentPlayList
	currentName = pl.currentName
        if currentName in pl.songsUri:
            currentIndex = pl.getIndex(currentName)
		
            newIndex = pl.getNextSong(currentIndex)
	    if not newIndex == -1:
		newName = pl.songsUri[newIndex]
		#pl.setCurrentName(newName)
		return newName
        else:
            return None    
	
    def getContextInfo(self):
	contextInfo=[]
	pl = self.currentPlayList
	currentName = pl.currentName
	if currentName in pl.songsUri:
	    currentIndex = pl.getIndex(currentName)
	    newIndex = pl.getPrevSong(currentIndex)
	    if not newIndex == -1:
		contextInfo.append(True)
	    else:
		contextInfo.append(False)
	    newIndex = pl.getNextSong(currentIndex)
	    if not newIndex == -1:
		contextInfo.append(True)
	    else:
		contextInfo.append(False)
	    print 'in mm.Context:', contextInfo
	    return contextInfo
	else:
	    print 'in mm.Context:None' 
	    return None
	
    def setCurPlaylist(self, pl):
	self.currentPlayList = pl
	
    def getCurPlaylist(self):
	return self.currentPlayList
	
 


