#!/usr/bin/env python
# vim: ai ts=4 sts=4 et sw=4

#    MusicView.py: Manage Music View

#    Copyright (c) 2007 Intel Corporation
#
#    This program is free software; you can redistribute it and/or modify it
#    under the terms of the GNU General Public License as published by the Free
#    Software Foundation; version 2 of the License
#
#    This program is distributed in the hope that it will be useful, but
#    WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
#    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
#    for more details.
#
#    You should have received a copy of the GNU General Public License along
#    with this program; if not, write to the Free Software Foundation, Inc., 59
#    Temple Place - Suite 330, Boston, MA 02111-1307, USA.

import Constant
import GeneralFunc
import ToolBarView
import sys, os, os.path, string
import pygtk
import gtk, gtk.gdk, gtk.glade
import pango, gobject
import MusicManag
import string

(COLUMN_STATE,
 COLUMN_STATE_PIXBUF,
 COLUMN_URI,
 COLUMN_TITLE,
 COLUMN_ARTIST,
 COLUMN_ALBUM,
 COLUMN_TIME,
 ) = range(7)

(PL_COLUMN_STATE,
 PL_COLUMN_STATE_PIXBUF,
 PL_COLUMN_URI,
 PL_COLUMN_NAME,
 ) = range(4)

(TARGET_PL_LIST,
 TARGET_SONG_LIST,
) = range(2)

(COLUMN_STATE_ACTIVE,
 COLUMN_STATE_INACTIVE,
) = range(2)

class MusicView:
    """
    A class which manage audio view.
    """

    def __init__(self, app):
        """
        init function
        """
        self.app = app
	
        self.wTree = gtk.glade.XML(Constant.MediaGladePath,root='mp_music_nbk')

        dic = {"on_wm_mm_song_seekbar_hs_format_value": self.sb_format_value,
               "on_wm_mm_song_seekbar_hs_change_value": self.sb_change_value,
               "on_mm_pl_playlist_tree_button_press_event": self.on_mm_pl_playlist_tree_button_press_event,
           }
        self.wTree.signal_autoconnect(dic)

        self.view_nbk = self.wTree.get_widget('mp_music_nbk')
        self.view_nbk.set_show_tabs(False)

        self.state_album = 0
        self.state_art = 1
        self.state_playlist = 2
        self.state_playback = 3
        self.state_default = 4

        self.state_current = self.state_playlist

        # if first launch
        self.is_first_launch = True
        
        # current postion of video playback
        self.cur_pos = 0

        # init playback view
        self.music_playback_view = self.wTree.get_widget('mm_playback_wd_vb')

        self.title_lb = self.wTree.get_widget("mm_song_title_lb")
        self.album_lb = self.wTree.get_widget("mm_album_titel_lb")
        self.artist_lb = self.wTree.get_widget("mm_song_artist_lb")
        self.album_year_lb = self.wTree.get_widget("mm_album_year_lb")
        self.album_img = self.wTree.get_widget("mm_album_img")
        self.song_length_lb = self.wTree.get_widget("mm_song_length_lb")
        self.music_seekbar = self.wTree.get_widget("mm_song_seekbar_hs")

        self.playback_surface = None
        
        # init playlist view
	self.music_window = self.wTree.get_widget('mp_music_window')
        self.music_playlist_view = self.wTree.get_widget('mm_playlist_view_eb')
        self.pl_tree = self.wTree.get_widget('mm_pl_playlist_tree')
        self.song_tree = self.wTree.get_widget('mm_pl_song_tree')
	"""
	print "music window--------------------------------", type(self.music_window)
	self.music_window.modify_base(gtk.STATE_NORMAL, Constant.select_window_bg)
	bg_color = gtk.gdk.Color(0,0,0,0)
        self.pl_tree.modify_base(gtk.STATE_NORMAL,bg_color)
	self.song_tree.modify_base(gtk.STATE_NORMAL,bg_color)
        fg_color = gtk.gdk.Color(65535,65535,65535,0)
	self.pl_tree.modify_text(gtk.STATE_NORMAL,fg_color)
        self.song_tree.modify_text(gtk.STATE_NORMAL,fg_color)
	font= pango.FontDescription("sans bold 8")
	self.song_tree.modify_font(font)
	"""
       
        # operating buttons
	
	# this variable should be a static value, which the new playlist button will use to
	#      make a new list naming "playlist%d" % self.count
	# fix me
        self.count = 3
	
	# temp buttons
        self.addpl_bn = self.wTree.get_widget('add_pl')
        self.addpl_bn.connect('clicked', self.on_new_pl_bn_clicked)
        
        self.delpl_bn = self.wTree.get_widget('del_pl')
        self.delpl_bn.connect('clicked', self.on_del_pl_bn_clicked)
	
	self.delsong_bn = self.wTree.get_widget('del_song')
        self.delsong_bn.connect('clicked', self.on_del_song_bn_clicked)
        
        self.shuffle_bn = self.wTree.get_widget('shuffle_bn')
        self.shuffle_bn.connect('toggled', self.on_shuffle_bn_toggled)
        
        self.repeat_bn = self.wTree.get_widget('repeat_bn')
        self.repeat_bn.connect('toggled', self.on_repeat_bn_toggled)
        
        # path = '/stream'
	# path = '/root/Desktop/streams'
	self.mm = MusicManag.MusicManag(self.app)
	
	self.view_playlist = self.cur_playlist = self.mm.getCurPlaylist()
	
	self.pl_model = self.create_playlist_model(None)
	self.pl_tree.set_model(self.pl_model)
	self.udpate_pl_view()
	self.pl_tree.get_selection().set_mode(gtk.SELECTION_SINGLE)
	self.pl_tree.get_selection().connect("changed", self._on_pl_sel_changed)
	
	self.song_model, self.song_modelsort = self.create_song_model()
	self.song_tree.set_model(self.song_model)
	#self.song_tree.set_rules_hint(True)
	self.song_tree.set_search_column(COLUMN_TITLE)	
	self.song_tree.get_selection().set_mode(gtk.SELECTION_MULTIPLE)
	
	# for drag and drop
	self.dnd_target = [
	    ('pl_list', 0, TARGET_PL_LIST),
	    ('song_list', 0, TARGET_SONG_LIST),
	]
	
	self.pl_tree.connect("drag-data-get", self._on_pl_tree_drag_data_get)
	self.pl_tree.connect("drag-data-received", self._on_pl_tree_drag_data_received)
	self.pl_tree.connect("drag-motion", self._on_pl_tree_drag_motion)
	
	self._pending_event = None
	self.song_tree.connect("button-press-event", self._on_song_tree_button_press_event)
	#self.song_tree.connect("button-release-event", self._on_song_tree_button_release_event)
	self.song_tree.connect("drag-data-get", self._on_song_tree_drag_data_get)
	self.song_tree.connect("drag-data-received", self._on_song_tree_drag_data_received)
	self.song_tree.connect("drag-motion", self._on_song_tree_drag_motion)
	self.song_tree.connect("row_activated", self._on_song_tree_row_activated)
	
	
	self.pl_tree.enable_model_drag_source(gtk.gdk.BUTTON1_MASK,
                                               self.dnd_target,
                                               gtk.gdk.ACTION_DEFAULT |
                                               gtk.gdk.ACTION_MOVE)
        self.pl_tree.enable_model_drag_dest(self.dnd_target,
                                             gtk.gdk.ACTION_DEFAULT|
                                               gtk.gdk.ACTION_MOVE)
	self.song_tree.enable_model_drag_source(gtk.gdk.BUTTON1_MASK,
                                               self.dnd_target,
                                               gtk.gdk.ACTION_DEFAULT|
                                               gtk.gdk.ACTION_MOVE)
        self.song_tree.enable_model_drag_dest(self.dnd_target,
                                             gtk.gdk.ACTION_DEFAULT)

        self.init_ui()

    def init_ui(self):
        self.view_nbk.set_current_page(self.state_current)
        widget = self.wTree.get_widget('mm_default_view_eb')
        widget.modify_bg(gtk.STATE_NORMAL, Constant.MediaColor['select_window_bg'])
        widget = self.wTree.get_widget('mm_default_view_lb')
        widget.modify_fg(gtk.STATE_NORMAL, Constant.MediaColor['select_label_fg'])
        widget = self.wTree.get_widget('mm_playback_view_eb')
        widget.modify_bg(gtk.STATE_NORMAL, Constant.MediaColor['mm_playback_bg'])
	widget = self.wTree.get_widget('mm_pl_view_paned')
        widget.set_position(150)

        self.title_lb.modify_fg(gtk.STATE_NORMAL, Constant.MediaColor['select_label_fg'])
        self.album_lb.modify_fg(gtk.STATE_NORMAL, Constant.MediaColor['select_label_fg'])
        self.artist_lb.modify_fg(gtk.STATE_NORMAL, Constant.MediaColor['select_label_fg'])
        self.album_year_lb.modify_fg(gtk.STATE_NORMAL, Constant.MediaColor['select_label_fg'])
        self.song_length_lb.modify_fg(gtk.STATE_NORMAL, Constant.MediaColor['select_label_fg'])
	

    def update_ui(self, is_last_view):
        self.view_nbk.set_current_page(self.state_current)
        if is_last_view == True:
            pass
        else:
            self.title_lb.set_text('')
            self.album_lb.set_text('')
            self.artist_lb.set_text('')
            self.album_year_lb.set_text('')
            self.song_length_lb.set_text('')
            self.set_album_img(os.path.join(Constant.MediaSpecImagePath,'AlbumArtMissing.png'))
            self.song_length_lb.set_text(GeneralFunc.format_time(0, 0, 0))

    def sb_format_value(self, seekbar, cur_value):
        (hours, mins, secs) = GeneralFunc.get_hour_min_sec(cur_value)
        return GeneralFunc.format_time(hours, mins, secs)

    def sb_change_value(self, seekbar, scrolltype, value):
        self.cur_pos = value
        if self.cur_pos < self.app.media_file_length:
            self.cur_pos = max(0, int(self.cur_pos))
            self.app.SetPosition(self.cur_pos)
        else:
            pass

    def get_sb_value(self):
        return self.cur_pos

    def update_state_playlist(self):
        self.state_current = self.state_playlist

    def update_state_playback(self):
        self.state_current = self.state_playback

    def update_state_share(self):
        self.state_current = self.state_share

    def update_state_default(self):
        self.state_current = self.state_default

    def get_render_surface(self):
        self.playback_surface = self.wTree.get_widget('mp_music_nbk')
        return self.playback_surface

    def is_first_load(self):
        return (self.is_first_launch == True)

    def mark_default_flag(self):
        self.is_first_launch = False
        self.update_ui(True)  

    def set_album_img(self, filename):
        GeneralFunc.set_image_fit(self.album_img, filename)

    def playback_set_title_lb(self, text):
        self.title_lb.set_text(text)

    def playback_set_album_lb(self, text):
        self.album_lb.set_text(text)

    def playback_set_artist_lb(self, text):
        self.artist_lb.set_text(text)

    def playback_set_album_year_lb(self, text):
        self.album_year_lb.set_text(text)

    def playback_set_length_lb(self, text):
        self.song_length_lb.set_text(text)

    def playback_set_seekbar_range(self, start, end):
        self.music_seekbar.set_range(start, end)

    def playback_set_seekbar_value(self, value):
        self.music_seekbar.set_value(value)

    def playback_set_seekbar_increments(self, step, page):
        self.music_seekbar.set_increments(step, page)

    def playback_set_seekbar_seekable(self, seekable):
        self.music_seekbar.set_sensitive(seekable)

    def set_fs_mode(self, on):
        pass
    
    
    # ###################################
    # for playlist view signal handler
    # ###################################
    
    def on_mm_pl_playlist_tree_button_press_event(self, treeview, event):
	x, y = int(event.x), int(event.y)
	path_info = treeview.get_path_at_pos(x, y)
	
        if event.button == 3:
            selected_rows = []
            if path_info is not None:
                path, col, cellx, celly = path_info
                selected_rows = self.get_selected_rows(treeview)
                if not selected_rows or (path[0] not in selected_rows):
                    # No selections or click was outside selections, so select
                    # row under mouse click
		    treeview.grab_focus()
		    treeview.set_cursor(path[0])
		    selected_rows = [path[0]]
            self._playlist_pl_popup_menu(selected_rows, event)
            return True
	
	elif event.button == 1:
	    if event.type == gtk.gdk._2BUTTON_PRESS:
		# maybe we'd like to do something here
		#print 'double click'
		pass
		
	    return False
	
        else:
           return False
       
    def _on_pl_sel_changed(self, sel, resort=False):
	model, path_list = sel.get_selected_rows()
	if not len(path_list) == 0:
	    name = model[path_list[0]][PL_COLUMN_NAME]
	    pl = self.mm.getList(name)
	    self.update_song_view(pl)

    def on_mm_pl_playlist_tree_row_activated(self, treeview, path, column):
	print 'in on_mm_pl_playlist_tree_row_activated'
	model = treeview.get_model()
	name = model[path][PL_COLUMN_NAME]
	pl = self.mm.getList(name)
	self.update_song_view(pl)
    
    def _on_song_tree_button_press_event(self, treeview, event):
	if event.button == 3:
            x, y = int(event.x), int(event.y)
            path_info = treeview.get_path_at_pos(x, y)
            selected_rows = []
            if path_info is not None:
                path, col, cellx, celly = path_info
                selected_rows = self.get_selected_rows(treeview)
                if not selected_rows or (path[0] not in selected_rows):
                    # No selections or click was outside selections, so select
                    # row under mouse click
                    treeview.grab_focus()
                    treeview.set_cursor(path[0])
                    selected_rows = [path[0]]

            self._playlist_song_popup_menu(selected_rows, event)
            return True
	elif event.button == 1:
	    return False
	    #if event.type == gtk.gdk._2BUTTON_PRESS:
		#return False
	    #else:
		#return self._block_selection(event)
        else:
           return False
       
    def _on_song_tree_row_activated(self, treeview, path, column):
	model = treeview.get_model()
	song = model.get_value(model.get_iter(path), COLUMN_URI)
	self.play_pl_song(song)
	
    def _set_song_tree_row_status(self, stock_id=None, row=None):
	if row is None:
            row = self.cur_playlist.getCurIndex()
        if row < 0 or row >= len(self.cur_playlist):
            return
	# Set new
	iter = self.song_model.get_iter(row)
        self.song_model.set_value(iter, COLUMN_STATE_PIXBUF, stock_id)

        # If playing reset model row to active
        if stock_id == gtk.STOCK_MEDIA_PLAY:
            self.song_model.set_value(iter, COLUMN_STATE, COLUMN_STATE_ACTIVE)
       
    def _on_song_tree_button_release_event(self, treeview, event):
	return 
        if self._pending_event:
            self.song_tree.get_selection().set_select_function(lambda *args: True)
            oldevent = self._pending_event
            self._pending_event = None
            if oldevent != [event.x, event.y]: 
		return True
            x, y = int(event.x), int(event.y)
            try: 
		path, col, cellx, celly = self.song_tree.get_path_at_pos(x, y)
            except TypeError: 
		return True
            self.song_tree.set_cursor(path, col, 0)
	    
    def _block_selection(self, event):
	x, y = int(event.x), int(event.y)
        try: 
	    path, col, cellx, celly = self.song_tree.get_path_at_pos(x, y)
        except TypeError: 
	    return True
        self.song_tree.grab_focus()
        sel = self.song_tree.get_selection()
        if ((sel.path_is_selected(path)
            and not (event.state & (gtk.gdk.CONTROL_MASK|gtk.gdk.SHIFT_MASK)))):
            self._pending_event = [x, y]
            sel.set_select_function(lambda *args: False)
	    
        elif event.type == gtk.gdk.BUTTON_PRESS:
            self._pending_event = None
            sel.set_select_function(lambda *args: True)
	return False
       
    def _playlist_song_popup_menu(self, selected_rows, event):
	song_menu_xml = gtk.glade.XML('MoblinMedia.glade',root='mm_pl_song_pop_menu')
	song_menu = song_menu_xml.get_widget('mm_pl_song_pop_menu')
        song_menu_xml.signal_autoconnect(self)
	
	# dynamic add submenus to "add_to_playlist" menuitem
	
	pl_name_menuitem = gtk.Menu()
	pl_name_list = self.mm.fileListList
	for i in range(len(pl_name_list)):
	    item = gtk.MenuItem(pl_name_list[i])
	    item.connect('activate', self._add_song_to_pl, pl_name_list[i])
	    pl_name_menuitem.add(item)
	
	add_pl_menuitem = song_menu_xml.get_widget('add_to_playlist')
	add_pl_menuitem.set_submenu(pl_name_menuitem)
	
        song_menu.show_all()
        song_menu.popup(None, None, None, event.button, event.time)
    	
    def _playlist_pl_popup_menu(self, selected_rows, event):
	pl_menu_xml = gtk.glade.XML('MoblinMedia.glade',root='mm_pl_pl_pop_menu')
	pl_menu = pl_menu_xml.get_widget('mm_pl_pl_pop_menu')
        pl_menu_xml.signal_autoconnect(self)
        pl_menu.show_all()
        pl_menu.popup(None, None, None, event.button, event.time)

    def _on_pl_rename_activate(self, menuitem):
	model, path_list = self.pl_tree.get_selection().get_selected_rows()
	# single selection mode, so path_list[0] is the actual path
	self.pl_tree.set_cursor(path_list[0], focus_column=self.pl_column, start_editing=True)
   
    def _on_pl_deletel_activate(self, menuitem):
	sel = self.pl_tree.get_selection()
	model, path_list = sel.get_selected_rows()
	if not len(path_list) == 0:
	    name = model[path_list[0]][PL_COLUMN_NAME]
	    self.mm.delList(name)
	    
	self.udpate_pl_view(path_list[0])
     
 
    def get_selected_rows(self, treeview):
	'''Returns a sorted list of the selected rows for special treeview'''
        rows = []
        model, path_list = treeview.get_selection().get_selected_rows()
        iters = [model.get_iter(path) for path in path_list]
        for iter in iters:
            row = model.get_path(iter)[0]
            rows.append(row)
        rows.sort()
        return rows
    
    def _on_song_remove_activate(self, menuitem):
	
	model, path_list = self.pl_tree.get_selection().get_selected_rows()
	if not len(path_list) == 0:
	    list_name = model[path_list[0]][PL_COLUMN_NAME]
	else:
	    list_name = model[0][PL_COLUMN_NAME]
	pl = self.mm.getList(list_name)
	   
	model, path_list = self.song_tree.get_selection().get_selected_rows()
	songs = [model[path][COLUMN_URI] for path in path_list]
	
	# test
	file = 'file://' + songs[0]
	print 'load %s'% file
	self.app.view['toolbar'].open_media_file(file)
	return 
    
	for song in songs:
	    pl.removeSong(song)
	self.update_song_view(pl)    
        
	print '_on_song_remove_activate'
	
    def _add_song_to_pl(self, menuitem, list_name):
	print 'list_name:', list_name
        model, path_list = self.song_tree.get_selection().get_selected_rows()
        songs = [self.song_model[path][COLUMN_URI] for path in path_list]
	pl = self.mm.getList(list_name)
	for song in songs:
	    pl.appendSong(song)
	  
	# update playlist view
	path = -1
	for row in self.pl_model:
	    if self.pl_model[row.path][PL_COLUMN_NAME] == list_name:
		path = row.path
		break
	if not path == -1:
	    self.udpate_pl_view(path)
	    
	# update song view
	self.update_song_view(pl)
	
        
    def _on_pl_tree_drag_data_get(self, treeview, context, selection, target_id, etime):
	print 'in _on_pl_tree_drag_data_get'
    
    def _on_pl_tree_drag_data_received(self, treeview, context, x, y, selection, info, timestamp):
	print 'info:', info
	try:
	    path, position = treeview.get_dest_row_at_pos(x, y)
        except TypeError:
            path = max(0, len(self.pl_model) - 1)
            position = gtk.TREE_VIEW_DROP_INTO_OR_BEFORE
	if selection.format == 8:
	    #print 'selection.target', selection.target
	    songs = selection.data.split('\xFF')
	    #if position in (gtk.TREE_VIEW_DROP_BEFORE, gtk.TREE_VIEW_DROP_INTO_OR_BEFORE):
	    list_name = self.pl_model[path][PL_COLUMN_NAME]
	    #print 'list name:', list_name
	    pl = self.mm.getList(list_name)
	    for song in songs:
		pl.appendSong(song)
	    self.update_song_view(pl)
	    self.udpate_pl_view(path)
            context.finish(True, False, timestamp)
        else:
            context.finish(False, False, timestamp)
	print 'in _on_pl_tree_drag_data_received'
	
    def _on_song_tree_drag_data_get(self, treeview, context, selection, target_id, etime):
	print 'target_id:', target_id
	model, path_list = self.song_tree.get_selection().get_selected_rows()
	songs = [self.song_model[path][COLUMN_URI] for path in path_list]
	selection.set('song_list', 8, '\xFF'.join(songs))
	
	print 'in _on_song_tree_drag_data_get'
    
    def _on_song_tree_drag_data_received(self, treeview, context, x, y, selection, info, timestamp):
	print 'in _on_song_tree_drag_data_received'
	# print 'selection:', selection
	if selection.format == 8:
	    print selection.target
            print 'Received "%s" in trashcan' % selection.data
            context.finish(True, False, timestamp)
        else:
            context.finish(False, False, timestamp)
	    
	    
    def _on_pl_tree_drag_motion(self, widget, context, x, y, timestamp):
	pass
	#print 'in _on_pl_tree_drag_motion'
	
    def _on_song_tree_drag_motion(self, widget, context, x, y, timestamp):
	pass
	#print 'in _on_song_tree_drag_motion'
	
    # ###################################
    # for playlist view song tree
    # ###################################
    
    def create_song_model(self):
	lstore = gtk.ListStore(int, # Column state
				str, # Status pixbuf
				str, # Source URI
				str, # Source title
				str, # Source artist
				str, # Source album
				str, # Source time (formatted)
			       )
	lstore_sort = gtk.TreeModelSort(lstore)
	lstore_sort.set_sort_column_id(COLUMN_TITLE, gtk.SORT_DESCENDING)
	
        for song in self.view_playlist:
	    row = self.new_song_model_row(song)
	    if(row != None):
                row = lstore.append(row)
                lstore_sort.convert_child_iter_to_iter(None, row)
	    
	self.add_song_columns()
	
	
        return lstore, lstore_sort
    
    def update_song_view(self, pl):
	self.update_song_model(pl)
	
    def update_song_model(self, pl):
	self.song_model.clear()
	for song in pl:
            row = self.song_model.append(self.new_song_model_row(song))
	    self.song_modelsort.convert_child_iter_to_iter(None, row)
	    
	self.view_playlist = pl
	
	self.song_tree.set_model(self.song_model)

    def add_song_columns(self):
	treeview = self.song_tree
	# COLUMN_STATE
	self.append_state_column(treeview, width=30)
	
	self.append_text_column(treeview, 'Title', COLUMN_TITLE, expand=True, width=200)
        self.append_text_column(treeview, 'Artist', COLUMN_ARTIST)
        self.append_text_column(treeview, 'Album', COLUMN_ALBUM)
	self.append_text_column(treeview, 'Time', COLUMN_TIME)
	
    def append_state_column(self, treeview, width=None):
	col = StatusColumn()
	if not width == None:
	    col.set_sizing(gtk.TREE_VIEW_COLUMN_FIXED)
	    col.set_fixed_width(width)
	treeview.append_column(col)
	    
	return col
	
    def append_text_column(self, treeview, title, model_index, expand=True, width=None, sortable=True, editable=False):
	col = TextColumn(title, expand = expand, editable = editable)
	col.add_attribute(col.txt_renderer, 'markup', model_index)
	if sortable == True:
	    col.set_sort_column_id(model_index)
	if not width == None:
	    col.set_sizing(gtk.TREE_VIEW_COLUMN_FIXED)
	    col.set_fixed_width(width)
	treeview.append_column(col)
	return col
	
    def new_song_model_row(self, song):
        song_data = self.get_song_metadata(song)
        if(len(song_data) == 0):
            return None
	return [COLUMN_STATE, None,
		song,
                song_data['title'],
		song_data['artist'],
		song_data['album'],
		song_data['length'],
	    ]
    
    def get_song_metadata(self, song):
	song_data = self.mm.getAudioInfo(song)
	#print '***', song_data, '\n'
	return song_data
	
	
    # ###################################
    # for playlist view playlist tree
    # ###################################
    
    def create_playlist_model(self, dname):
	lstore = gtk.ListStore(int, # Column state
				str, # Status pixbuf
				str, # Source URI
				str, # Source Name
			       )
	for pl_name, pl in self.mm.getAllList().items():
            lstore.append(self.new_pl_model_row(pl))
	 
	self.pl_column = self.append_text_column(self.pl_tree, 'Playlist', PL_COLUMN_NAME, expand=False, editable=True)
	self.pl_column._get_render().connect("edited", self._on_pl_name_edited, lstore)
	
        return lstore
    
    	
    def udpate_pl_view(self, path=0):
	self.update_pl_model()
	if type(path) == type((1,)):
	    path = path[0]
	if path >= len(self.pl_model):
	    path = len(self.pl_model)-1
	elif path < 0:
	    path = 0
	self.pl_tree.set_cursor(path)
	    
    
    def update_pl_model(self):
	self.pl_model.clear()
	for pl_name, pl in self.mm.getAllList().items():
            self.pl_model.append(self.new_pl_model_row(pl))
	self.pl_tree.set_model(self.pl_model)
    
    def new_pl_model_row(self, pl):
        return [PL_COLUMN_STATE,
		None,
		None,
		pl.listName,
               ]
	
    def _on_pl_name_edited(self, cell, path, new_text, model):
	print 'new name:', new_text
	print 'old:', model[path][PL_COLUMN_NAME]
	if self.mm.renameList( model[path][PL_COLUMN_NAME], new_text) == True:
	    model[path][PL_COLUMN_NAME] = new_text
	# update mm and playlist
	self.udpate_pl_view(path)
			
    def on_new_pl_bn_clicked(self, bn):
	name = 'playlist' + str(self.count)
	self.count += 1
	pl2 = self.mm.newList(name)
	self.udpate_pl_view(len(self.pl_model))
	
    def on_del_pl_bn_clicked(self, bn):
	sel = self.pl_tree.get_selection()
	model, path_list = sel.get_selected_rows()
	if not len(path_list) == 0:
	    name = model[path_list[0]][PL_COLUMN_NAME]
	    self.mm.delList(name)
	    self.pl_model.remove(self.pl_model.get_iter(path_list[0]))
	    
	self.udpate_pl_view(path_list[0])
	
    def on_del_song_bn_clicked(self, bn):
	model, path_list = self.pl_tree.get_selection().get_selected_rows()
	if not len(path_list) == 0:
	    list_name = self.pl_model[path_list[0]][PL_COLUMN_NAME]
	else:
	    list_name = self.pl_model[0][PL_COLUMN_NAME]
	pl = self.mm.getList(list_name)
	   
	model, path_list = self.song_tree.get_selection().get_selected_rows()
	songs = [model[path][COLUMN_URI] for path in path_list]
	
	for song in songs:
	    pl.removeSong(song)
	self.update_song_view(pl)    
	
    def on_shuffle_bn_toggled(self, bn):
	shuffled = bn.get_active()
	self.mm.setShuffle(shuffled)
	self.app.view['toolbar'].set_prev_next_state(self.mm.getContextInfo())
	 
    def on_repeat_bn_toggled(self, bn):
	repeated = bn.get_active()
	self.mm.setRepeat(repeated)
	self.app.view['toolbar'].set_prev_next_state(self.mm.getContextInfo())
	
    def on_song_ended(self, object):
	print 'in on_song_ended************catched'
	self.play_pl_next()
	#print 'data', data
	
    def play_pl_next(self):
	song = self.mm.getNext()
	print '\n###############\n'
	print 'next:', song
	if not song == None:
	    self.play_pl_song(song)
	    
    def play_pl_prev(self):
	song = self.mm.getPrev()
	print 'prev:', song
	if not song == None:
	    self.play_pl_song(song)
	
    def play_pl_song(self, song):
	print "play_pl_song---------------", song
	self.cur_playlist = self.view_playlist
	self.mm.setCurPlaylist(self.cur_playlist)
	self.cur_playlist.setCurrentName(song)
	print 'in play..index:', self.cur_playlist.getIndex(song)
	self.update_song_list()
	ctxt = self.mm.getContextInfo()
	print 'in ctxt:', ctxt
	self.app.view['toolbar'].set_prev_next_state(self.mm.getContextInfo())
	if(song.find("http://") != 0):
		
		file = 'file://' + song
	else:
		file = song
		print "play http stream:", song
	self.app.view['toolbar'].open_media_file(file)
	
    def update_song_list(self):
	# update the state pixmap
	for index in range(len(self.cur_playlist)):
	    if index == self.cur_playlist.getCurIndex():
		self._set_song_tree_row_status(gtk.STOCK_MEDIA_PLAY, index)
		# set current cursor to current index
		self.song_tree.set_cursor(index)
	    else:
		self._set_song_tree_row_status(None, index)

class TextColumn(gtk.TreeViewColumn):

    def __init__(self, title, expand = False, editable=False):
        gtk.TreeViewColumn.__init__(self, title)

        self.txt_renderer = gtk.CellRendererText()
        self.txt_renderer.set_property('ellipsize', pango.ELLIPSIZE_END)
	self.txt_renderer.set_property('editable', editable)
        self.pack_start(self.txt_renderer, True)
        self.set_resizable(True)
        self.set_reorderable(True)
        self.set_property('expand', expand)
	
    def _get_render(self):
	return self.txt_renderer
	
### TreeViewColumn types ###
class StatusColumn(gtk.TreeViewColumn):

    def __init__(self):
        gtk.TreeViewColumn.__init__(self, ' ' * 2)

        self.img_renderer = gtk.CellRendererPixbuf()
        self.img_renderer.set_property('stock-size', gtk.ICON_SIZE_MENU)

        self.pack_start(self.img_renderer, False)

        self.set_resizable(False)
        self.set_sizing(gtk.TREE_VIEW_COLUMN_AUTOSIZE)
        self.set_reorderable(False)

        self.add_attribute(self.img_renderer, 'stock-id', COLUMN_STATE_PIXBUF)    
