#!/usr/bin/env python
# vim: ai ts=4 sts=4 et sw=4

#    ThumbnailView.py: Manage Thumbnail View

#    Copyright (c) 2007 Intel Corporation
#
#    This program is free software; you can redistribute it and/or modify it
#    under the terms of the GNU General Public License as published by the Free
#    Software Foundation; version 2 of the License
#
#    This program is distributed in the hope that it will be useful, but
#    WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
#    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
#    for more details.
#
#    You should have received a copy of the GNU General Public License along
#    with this program; if not, write to the Free Software Foundation, Inc., 59
#    Temple Place - Suite 330, Boston, MA 02111-1307, USA.

from PIL import Image
import os
import md5
import gtk
import string
import PhotoPlayback
import Constant
import StringIO
import gc
import pango
import tempfile

def PILImage_to_GdkPixbuf (img,img_type):
    if img_type=='jpeg':
        img_type='png'
    tmpfile = StringIO.StringIO ()
    img.save (tmpfile,img_type)
    contents = tmpfile.getvalue()
    tmpfile.close ()
    GtkLoader = gtk.gdk.PixbufLoader (img_type)
    GtkLoader.write (contents, len (contents))
    GdkPixbuf = GtkLoader.get_pixbuf ()
    GtkLoader.close ()
    gc.collect()

    return GdkPixbuf
class ThumbnailSupport:
    def __init__(self,wTree,app):
       
        self.wTree = wTree
        self.app = app
        self.ThumbnailLevel=7.5 
        self.model = gtk.ListStore(str, gtk.gdk.Pixbuf,  int,     int,   long)
        self.CurrentImgDir = ''
        self.SortType = 0
        self.SelectedItems = list()
        self.iconview = self.wTree.get_widget("pm_main_iconview")
        iconbg = gtk.gdk.Color(0,0,0,0)
        self.iconview.modify_base(gtk.STATE_NORMAL,iconbg)
        iconbg = gtk.gdk.Color(65535,65535,65535,0)
        self.iconview.modify_text(gtk.STATE_NORMAL,iconbg)
        font= pango.FontDescription("sans bold 8")
        self.iconview.modify_font(font)
        dic = {
            "on_pm_main_iconview_button_press_event" : self.button_press_event,
            "on_pm_main_iconview_button_release_event": self.button_release_event,
            }
        self.wTree.signal_autoconnect(dic)	
        self.PlaybackImage = self.wTree.get_widget("wm_pm_cur_img")
        #self.SyncEverytime('/root/.mobile-player/.mobilethumbnail/normal')
    def GetCurrentMode(self):
        return self.model 

    def SetSortType(self,SortType):
        self.SortType = SortType 


    def GetSelectedItems(self):
        return self.CurrentImgDir, self.SelectedItems
    
    def get_iconview(self):
        self.iconview = self.wTree.get_widget("pm_main_iconview")
        return iconview

    def button_release_event(self,widget,event):
        num = len (self.SelectedItems)-1
        while num >= 0:
            self.SelectedItems.remove(self.SelectedItems[num])
            num -= 1
        SelItemsPath = widget.get_selected_items()
        if SelItemsPath:
            for i in SelItemsPath:
                self.SelectedItems.append(self.PathToFilename(i)) 
        if self.SelectedItems:
            self.SelectedItems.sort()
            
        dir, list = self.GetSelectedItems()
        file_list = []
        for i in list:
            if os.path.isdir(os.path.join(dir, i)) == False:
                file_list.append(os.path.join(dir, i))
            
        # update plugin args
        if self.app.view['toolbar'].plugins.get_plugin_count() == 0:
            # no plugins
            return
        else:
            buttons = self.app.view['toolbar'].get_plugin_buttons()
            for bn in buttons['photo']:
                bn.update_args(file_list)
        
    def button_press_event(self,widget, event):
        item = widget.get_selected_items()
        if item:
            if event.type == gtk.gdk._2BUTTON_PRESS:
                self.ViewInBigSize(self.CurrentImgDir,widget.get_selected_items()[0][0])

    def key_press_event(self,widget,event):
        """
        if (keyval > 'a'and keyval<'z') or (keyval >'A' and keyval <'Z') or (keyval >'1',keyval<'9'):   
            self.KeyToScroll(keyval,self.iconview)
        else :
        """
        keyval = gtk.gdk.keyval_name(event.keyval)
        # print self.GetSelectedItems()
        if keyval in ['Escape']:
            pass
            #self.BackBrowseDir()
        if keyval in ['i']:
            print ' thumbnail level changed'
            self.ThumbnailLevel+=0.5
            self.MakeAllImageThumbnail(self.CurrentImgDir)
        if keyval in ['o']:
            self.ThumbnailLevel-=0.5
            self.MakeAllImageThumbnail(self.CurrentImgDir)
    
    def SetThumbnailSizeLevel(self,NewSizeLevel):
            self.ThumbnailLevel=NewSizeLevel
            self.MakeAllImageThumbnail(self.CurrentImgDir)   
    def KeyToScroll(self,keyval,widget):
        """
        use key to scroll to the selected item ,more friendly than scroll use cursor
        """
        if keyval.isupper:
            corkey = keyval.lower()
        else:
            corkey = keyval.upper()
        for i in range(len(self.model)):    
            if keyval == self.model[i][0][0]or corkey == self.model[i][0][0]:
                widget.scroll_to_path((i,),True,True,True)
                widget.select_path((i,))
                break 
                             
    def SetModel(self):
        self.iconview.set_model(self.model)
        self.iconview.set_text_column(0)
        self.iconview.set_pixbuf_column(1)    
        
    def MakeDirThumbnail(self,CurDir,size=(200,200),IsHidden=False):
        pixbuf = self.iconview.render_icon(gtk.STOCK_DIRECTORY,gtk.ICON_SIZE_BUTTON)
        self.model.append(['..', pixbuf,2,0,0])#2 if for browse backward 
        self.CurrentDirPath = CurDir
        self.app.view['photo'].update_cur_image_dir(CurDir)
        for Dir in os.listdir(CurDir):
            dirpath = os.path.join(CurDir,Dir)
            if os.path.exists(dirpath) and os.path.isdir(dirpath) and  self.ThumbFilter(CurDir,Dir,IsHidden) == 1:
                pixbuf1 = self.iconview.render_icon(gtk.STOCK_DIRECTORY,gtk.ICON_SIZE_BUTTON)
                mtime,size = self.GetFileDetailInfo(dirpath)
                self.model.append([Dir, pixbuf1, 1, mtime,size])#1 means type is directory
        #self.ThumbnailSort(0)        

    def SyncEverytime(self,MobileHomeDir):
        for thumbfile in os.listdir(MobileHomeDir):
            path = thumbfile[32:].replace('\n','/')
            if not os.path.exists(path):
                os.remove(os.path.join(MobileHomeDir,thumbfile))
                continue
            mtime,filesize = self.GetFileDetailInfo(path)
            md5sum = md5.new(path+str(mtime)+str(filesize)).hexdigest()
            if not md5sum == thumbfile[:32]:
                os.remove(os.path.join(MobileHomeDir,thumbfile))
                          
    def MakeAllSizeOfCacheDir(self,subdir = '.moblinthumbnail'):
        HomeDir = os.path.expanduser("~")
        MobileHomeDir = os.path.join(HomeDir,'.moblin-media')
        if not os.path.exists(MobileHomeDir):
            os.mkdir(MobileHomeDir)				
        self.thumbdir = os.path.join(MobileHomeDir, subdir)	
        if not os.path.exists(self.thumbdir):
            os.mkdir(self.thumbdir)
        self.thumbdirSizeLargest = os.path.join(self.thumbdir,'largest')
        self.thumbdirSizeNormal = os.path.join(self.thumbdir,'normal')
        self.thumbdirVideoTmp =  os.path.join(self.thumbdir,'video_tmp')
        if not os.path.exists(self.thumbdirSizeLargest):
            os.mkdir(self.thumbdirSizeLargest)
        if not os.path.exists(self.thumbdirSizeNormal):
            os.mkdir(self.thumbdirSizeNormal)
        if not os.path.exists(self.thumbdirVideoTmp):
            os.mkdir(self.thumbdirVideoTmp)
        
    def SelectHomeSize(self,IsSelLargest=True,subdir = '.moblinthumbnail'):
        MobileHomeDir = os.path.join(os.path.expanduser("~"),'.moblin-media')
        ThumbHomeDir = os.path.join(MobileHomeDir,subdir)
        returnval = ''
        if IsSelLargest: 
            returnval = os.path.join(ThumbHomeDir,'largest')
        else: 
            returnval = os.path.join(ThumbHomeDir,'normal')  
            
       
        return returnval
    def GetImgType(self,filename):
        
        root,ext = os.path.splitext(filename)
        img_type = ext.replace('.','').lower()
        if img_type == 'jpg':
            return 'jpeg'
        
        return img_type
    def PathToMd5(self,path,imgfile,IsSelLargest=True):
        # get the mtime and size to decide wether to reload the thumbdir
        mtime,filesize = self.GetFileDetailInfo(os.path.join(path,imgfile))
        destination = self.SelectHomeSize(IsSelLargest)
        tmp = os.path.join(path,imgfile)
        md5dest = md5.new(tmp+str(mtime)+str(filesize)).hexdigest()+tmp.replace('/','\n')
        
        return os.path.join(destination,md5dest)
    
    def GetCurrentImgDir(self):
        return self.CurrentImgDir

    def MakeAllImageThumbnail(self, imgdir, IsHidden=False, thumbsize=(200,200),subdir='.mobilethumbnail'):
        self.CurrentImgDir = imgdir
        if not os.path.exists(imgdir):
            print imgdir,os.path.exists(imgdir)
            print 'invalid path '
            return 
        self.model.clear()
        self.MakeAllSizeOfCacheDir()
        thumbs = []
        for imgfile in os.listdir(imgdir):         
            thumbpath = os.path.join(self.thumbdir, imgfile)
            mtime,filesize = self.GetFileDetailInfo(os.path.join(imgdir,imgfile))
            i = self.ThumbFilter(imgdir,imgfile,IsHidden)
            if not i:
                continue
            elif i == 1: 
                CacheDest = self.PathToMd5(imgdir,imgfile,True)
                NewImgfile = self.AlignNameWithThumb(imgfile)
                if os.path.exists(CacheDest):
                    PILImg=Image.open(CacheDest)
                    NewSize=(int(PILImg.size[0]*(self.ThumbnailLevel/10)),int(PILImg.size[1]*(self.ThumbnailLevel/10)))
                    PILImg.thumbnail(NewSize)
                    PILImg.save(self.PathToMd5(imgdir,imgfile,False))
                    image = gtk.Image()
                    image.set_from_file(self.PathToMd5(imgdir,imgfile,False))
                    image.show()
                    
                    self.model.append([NewImgfile,image.get_pixbuf(),0,mtime,filesize]) #0 means type is image
                elif os.path.isfile(os.path.join(imgdir, imgfile)):
                    
                    imgpath = os.path.join(imgdir, imgfile)
                        
                    PILImg = Image.open(imgpath)      
                    PILImg.thumbnail(thumbsize)
                    PILImg.save(CacheDest,'png') 
                    NewSize=( int(PILImg.size[0]*(self.ThumbnailLevel/10)),int(PILImg.size[1]*(self.ThumbnailLevel/10))) 
                    PILImg1=Image.open(CacheDest)
                    PILImg1.thumbnail(NewSize)   
                    PILImg1.save(self.PathToMd5(imgdir,imgfile,False))          
                    image = gtk.Image()
                    image.set_from_file(self.PathToMd5(imgdir,imgfile,False))
                    image.show()
                    
                    self.model.append([NewImgfile,image.get_pixbuf(),0,mtime,filesize]) #0 means type is image
                else:
                    pass
           
            
            elif i == 2:
                image = gtk.Image()
                image.set_from_file(os.path.join(Constant.MediaImagePath,'mime-audio.png'))
                NewImgfile = self.AlignNameWithThumb(imgfile)
                self.model.append([NewImgfile,image.get_pixbuf(),3,mtime,filesize])#2 means type is audio
            elif i == 3:
                curEng = self.app.EngManag.FindEngByService(self.app.service)
                NewImgfile = self.AlignNameWithThumb(imgfile)
                if not curEng :
                    image = gtk.Image()
                    image.set_from_file(os.path.join(Constant.MediaImagePath,'mime-video.png'))
                else:
                    root,ext = os.path.splitext(imgfile)
                    if False:
                        image = gtk.Image()
                        image.set_from_file(os.path.join(Constant.MediaImagePath,'mime-video.png'))
                    else:
                        CacheDest = self.PathToMd5(imgdir,imgfile,True)
                        root,ext = os.path.splitext(CacheDest)
                        curEng.AddCaps(ext.replace('.',''))
                        CacheDest = CacheDest.replace(ext,'.png')
                        if os.path.exists(CacheDest):
                            PILImg = Image.open(CacheDest)      
                            NewSize=( int(PILImg.size[0]*(self.ThumbnailLevel/10)),int(PILImg.size[1]*(self.ThumbnailLevel/10)))
                            PILImg.thumbnail(NewSize)
                            CacheDest = self.PathToMd5(imgdir,imgfile,False)
                            root,ext = os.path.splitext(CacheDest)
                            CacheDest = CacheDest.replace(ext,'.png')
                            PILImg.save(CacheDest)  
                            image = gtk.Image()
                            image.set_from_file(CacheDest)
                        else:
                            if self.GetThumbnaliFromService(os.path.join(imgdir,imgfile)):
                                continue 
                            else:
                                image = gtk.Image()
                                image.set_from_file(os.path.join(Constant.MediaImagePath,'mime-video.png'))    
				PILImg = Image.open(os.path.join(Constant.MediaImagePath,'mime-video.png'))
				PILImg.save(CacheDest)
                self.model.append([NewImgfile,image.get_pixbuf(),4,mtime,filesize])#3 means type is audio
        self.ThumbnailSort(self.SortType)
    
    def GetThumbnaliFromService(self,uri):
        print uri
        root,ext = os.path.splitext(uri)
        head,tail = os.path.split(uri)
        output_file = os.path.join(self.thumbdirVideoTmp,tail.replace(ext,'')+'.png')
        result = self.app.service.GetVideoFrame('file://'+uri,output_file)
        curEng = self.app.EngManag.FindEngByService(self.app.service)
        if result:
            curEng.AddCaps(ext.replace('.',''))
            PILImg = Image.open(output_file)      
            PILImg.thumbnail((200,200))
            CacheDest = self.PathToMd5(self.CurrentImgDir,tail,True)
            root,ext = os.path.splitext(CacheDest)
            CacheDest = CacheDest.replace(ext,'.png')
            PILImg.save(CacheDest) 
            print CacheDest,'^^^^^^^^^^^^^^^^^^^^'
            NewSize=( int(PILImg.size[0]*(self.ThumbnailLevel/10)),int(PILImg.size[1]*(self.ThumbnailLevel/10))) 
            PILImg1=Image.open(CacheDest)
            PILImg1.thumbnail(NewSize)
            root,ext = os.path.splitext(self.PathToMd5(self.CurrentImgDir,tail,False))   
            video_thumb_dest = root + '.png'
            PILImg1.save(video_thumb_dest)          
            image = gtk.Image()
            image.set_from_file(video_thumb_dest)
            mtime,filesize = self.GetFileDetailInfo(uri)      
            self.model.append([tail,image.get_pixbuf(),4,mtime,filesize]) #0 means
            return True
        print 'can not to get thumbnail for ',uri
        return False

    def AlignNameWithThumb(self,imgfile):
        NewImgfile = ''
        if len(imgfile)<15:
            return imgfile
        i = 0
        while i<len(imgfile):
            if i-15>len(imgfile):
                j = i
            else:
                j = i+15
            NewImgfile += imgfile[i:j]+'\n'
            i = j
            
        return NewImgfile   
    def ContinueBrowseDir(self,CurrentImgDir,SelectedDirIcon):
        self.MakeAllImageThumbnail(os.path.join(CurrentImgDir,SelectedDirIcon))
        
    def BackBrowseDir(self):
        if len(self.CurrentImgDir) == 1 and self.CurrentImgDir == '/':
            CurDir = '/'
        elif len(self.CurrentImgDir) > 1 :
            if self.CurrentImgDir[-1] == '/':
                self.CurrentImgDir.replace(self.CurrentImgDir[-1],'')
            head,tailr = os.path.split(self.CurrentImgDir)
            if not head: #if at '/' exist a .png,then root should be '/'
                head = '/'
            CurDir = head
        else:	
            CurDir = '/'
            print " path error in BackBrowseDir(),should never occour in general"
        self.MakeAllImageThumbnail(CurDir)
        
    def ViewInBigSize(self,CurrentImgDir,i):
        if self.model[i][2] == 2:
            self.BackBrowseDir()
        elif self.model[i][2] == 1:
            self.ContinueBrowseDir(CurrentImgDir,self.model[i][0].replace('\n',''))
        elif self.model[i][2] == 3 or self.model[i][2] == 4:
            self.app.view['toolbar'].open_media_file('file://'+os.path.join(CurrentImgDir,self.model[i][0].replace('\n','')))
            self.app.view['toolbar'].vm_browse_button.set_sensitive(False)
        else:
            self.app.view['photo'].set_cur_index(i)
            self.app.view['photo'].set_cur_dir(os.path.join(CurrentImgDir,self.model[i][0].replace('\n','')))
            self.app.view['photo'].set_cur_picture(os.path.join(CurrentImgDir,self.model[i][0].replace('\n','')))
            self.app.view['photo'].update_state_playback()
            
    def GetImgDir(self,filename):
        head,tail=os.path.split(filename)
        return head
    
    def ThumbFilter(self,root,ext,isHide=False):
        """
        Note that isHide is to decise whether to show the hiden dir,default is no 
        """
        filepath=os.path.join(root,ext)
        ##@filter out the type not in directory or image
        if os.path.isdir(filepath):
            if ext:
                if  ext == '.moblinthumbnail':
                    return 0  #never show my .thumbs 
                if ext[0] == '.':  #yes this is a hiden file
                    return isHide
            return True
        
        NewRoot, NewExt = os.path.splitext(filepath)
        NewExt = NewExt.replace('.','').lower()
        if NewExt in Constant.MediaType['photo']:
            return 1
        elif NewExt in Constant.MediaType['audio']:
            return 2
        elif  NewExt in  Constant.MediaType['video']:
            return 3  
        return 0
    
    def ThumbnailSort(self,ByWhatType=0):
        if ByWhatType == 0:
            # print 'sort by name'
            self.model.set_sort_column_id(0,gtk.SORT_ASCENDING)
        elif ByWhatType == 1:
            self.model.set_sort_column_id(3,gtk.SORT_ASCENDING)
            # print 'sort by time'
        elif ByWhatType == 2:
            self.model.set_sort_column_id(4,gtk.SORT_ASCENDING)
            # print 'sort by size'
        elif ByWhatType == 3:
            self.model.set_sort_column_id(5,gtk.SORT_ASCENDING)
            # print 'sort by mime'
        else:
            print 'not support type of sort'

    def GetFileDetailInfo(self,filepath):
        DeInfo = os.stat(filepath)
        
        # return modified time and size
        return 	DeInfo[-2],DeInfo[-4] 
    
    def PathToFilename(self,path):
        return self.model[path[0]][0].replace('\n','')
    def __del__(self):
        print 'destructor of ThumbnailView class was called'
        self.SyncEverytime('/root/.moblin-media/.moblinthumbnail/normal')
