#ifndef LIBBTPEER_BITFIELD_H
#define LIBBTPEER_BITFIELD_H

#include <stdint.h>

#define BTP_BITFIELD_PIECE(piece) (1 << (7 - (piece % 8)))
#define BTP_BITFIELD_PIECE_N(piece) (piece/8)
#define BTP_BITFIELD_POS(bitfield, piece) bitfield[BTP_BITFIELD_PIECE_N(piece)]

static inline int btp_bitfield_has(uint8_t* bitfield, int piece) {
    return BTP_BITFIELD_POS(bitfield, piece) & BTP_BITFIELD_PIECE(piece);
}

static inline void btp_bitfield_add(uint8_t* bitfield, int piece) {
    BTP_BITFIELD_POS(bitfield, piece) |= BTP_BITFIELD_PIECE(piece);
}

static inline void btp_bitfield_remove(uint8_t* bitfield, int piece) {
    BTP_BITFIELD_POS(bitfield, piece) &= ~BTP_BITFIELD_PIECE(piece);
}

#endif /* LIBBTPEER_BITFIELD_H */
