#ifndef LIBBTT_ITER_ITER_H
#define LIBBTT_ITER_ITER_H

/* other libs */
#include <db.h>
#include <apr.h>
#include <apr_pools.h>
/* local */
#include <libbttracker/types.h>
#include <libbttracker/txn.h>

#ifdef BTT_WITH_LIBXML2
#include <libxml/tree.h>
#endif

typedef struct btt_iter_hashandpeer_s {
    btt_infohash*  infohash;
    btt_infohash*  oldhash;
    btt_tracker*   tracker;
    btt_peer*      peer;
    unsigned char  updating;
} btt_iter_hashandpeer;

typedef struct btt_iter_content_s {
    int                    content_length;
    int                    buffer_length;
/* The "content" buffer should NOT be allocated out of a pool.
 * it should be allocated using standard malloc(), as iterators
 * that write to it will increase content_length and realloc()
 * content if the buffer is too small. Any libbttracker functions
 * that return this content first copy it into a buffer from an APR pool,
 * then free() the buffer stored on this struct.
 *
 * This buffer is not implmented with APR pools because under some
 * circumstances, it could need to grow hundreds (or thousands)
 * of times, and we want to reclaim the memory as fast as we can without
 * creating and destroying hundreds of APR pools.
 */
    char*                  content;
    btt_iter_hashandpeer   hashandpeer;
    apr_pool_t*            pool;
#ifdef BTT_WITH_LIBXML2
    xmlDocPtr              xml_document;
#endif
} btt_iter_content;

/* btt_iter_scrape_want_hash.c */
extern int btt_iter_scrape_want_hash(
    apr_pool_t* p, DB_TXN* txn, DBC* cursor, DBT* key, DBT* val, void* data
);

/* btt_iter_scrape_add_hash.c */
extern int btt_iter_scrape_add_hash(
    apr_pool_t* p, DB_TXN* txn, DBC* cursor, DBT* key, DBT* val, void* data
);

/* btt_iter_make_peerlist.c */
extern int btt_iter_make_peerlist_string(
    apr_pool_t* p, DB_TXN* txn, DBC* cursor, DBT* key, DBT* val, void* data
);
extern int btt_iter_make_peerlist_check(
    apr_pool_t* p, DB_TXN* txn, DBC* cursor, DBT* key, DBT* val, void* data
);

/* btt_iter_peer_stats.c */
extern int btt_iter_peer_stats(
    apr_pool_t* p, DB_TXN* txn, DBC* cursor, DBT* key, DBT* val, void* data
);
/* btt_iter_check_hash.c */
extern int btt_iter_check_hash(
    apr_pool_t* p, DB_TXN* txn, DBC* cursor, DBT* key, DBT* val, void* data
);
/* btt_iter_check_peer.c */
extern int btt_iter_check_peer(
    apr_pool_t* p, DB_TXN* txn, DBC* cursor, DBT* key, DBT* val, void* data
);

#endif /* LIBBTT_ITER_ITER_H */
