/*
 *  mod_bt - Making Things Better For Seeders
 *  Copyright 2004, 2005, 2006 Tyler MacDonald <tyler@yi.org>
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/* other libs */
#include <db.h>
#include <apr.h>
#include <apr_pools.h>
/* local */
#include <libbttracker.h>

/* data is set to the scrape config */
/* modifies nothing */
int btt_iter_scrape_want_hash(
    apr_pool_t* p, DB_TXN* txn, DBC* cursor, DBT* key, DBT* val, void* data
) {
    btt_cxn_scrape_config* config = (btt_cxn_scrape_config*) data;
    btt_infohash *infohash = (btt_infohash*)val->data;
    int found = 0;
    int n = 0;
    char* hash;
 
    /* if we want all of the hashes, or this hash is active, we're all good */
    if(config->full)
        return 0;
  
    if(!config->hashes) {
        fflush(stderr);
        if(
            infohash->peers ||
            (
                (config->rv.hashandpeer.tracker)->s->server_time -
                infohash->last_t
            )
            <=
            ((config->rv.hashandpeer.tracker)->c->return_interval * 2)
        )
            return 0;
        else
            return BT_CALLBACK_STOP;
    }
    
    /* since specific info_hash requests are probably going to be fairly short
     * lists, this method is still fast. in the future it might be better to 
     * use apr_tables or something
     */
 
    hash = config->hashlist;
    while((!found) && (n < config->hashes)) {
        if(!memcmp(hash, infohash->infohash, BT_INFOHASH_LEN))
            found = 1;
  
        n++;
        hash = hash + BT_INFOHASH_LEN;
    }

    if(found)
        return 0;
    else
        return BT_CALLBACK_STOP;
}
