/*
 *  mod_bt - Making Things Better For Seeders
 *  Copyright 2004, 2005, 2006 Tyler MacDonald <tyler@yi.org>
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/* libc */
#include <stdio.h>
/* other libs */
#include <db.h>
/* local */
#include <libbttracker.h>

int btt_tracker_disconnect_db(btt_tracker* tracker)
{
 int ret;

 if(!tracker->db.open)
 {
  fprintf(stderr, "bt_tracker_disconnect_db(): Called on a tracker that is not connected to it's db yet!\n");
  fflush(stderr);
  goto err;
 }
 
 if((ret = tracker->db.index->close(tracker->db.index, 0)) != 0)
 {
  tracker->db.index->err(tracker->db.index, ret, "bt_tracker_disconnect_db(): index->close");
  goto err;
 }

 tracker->db.index = NULL;


 if((ret = tracker->db.hashes->close(tracker->db.hashes, 0)) != 0)
 {
  tracker->db.hashes->err(tracker->db.hashes, ret, "bt_tracker_disconnect_db(): hashes->close");
  goto err;
 }

 tracker->db.hashes = NULL;
 
 if((ret = tracker->db.peers->close(tracker->db.peers, 0)) != 0)
 {
  tracker->db.peers->err(tracker->db.peers, ret, "bt_tracker_disconnect_db(): peers->close");
  goto err;
 }

 tracker->db.peers = NULL;
 
 if((ret = tracker->db.env->close(tracker->db.env, 0)) != 0)
 {
  tracker->db.env->err(tracker->db.env, ret, "bt_tracker_disconnect_db(): env->close");
  goto err;
 }
 
 tracker->db.env = NULL;
 tracker->db.open = 0;

 return 1;

 err:
 return 0;
}

int btt_tracker_disconnect_mem(btt_tracker* tracker)
{
 tracker->s->num_children--;
 tracker->c = NULL;
 tracker->s = NULL;
 
 return 1;
}

int btt_tracker_disconnect(btt_tracker* tracker)
{
 if(btt_tracker_disconnect_db(tracker))
  return btt_tracker_disconnect_mem(tracker);
 else
  return 0;
}
