#include <apr.h>
#include <apr_pools.h>
#include <apr_strings.h>

#include <libbtutil/const.h>

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>

#define SZSTR	64
#define ssize ((long double)size)

char* bt_nice_size(apr_pool_t* p, bt_size_t size) {
    char* rv;
    char  szstr[SZSTR];

    if(size > 1024 * 1024 * 1024 * 0.85)
        snprintf(szstr, SZSTR, "%.02LfGb", ssize / 1024 / 1024 / 1024);
    else if(size > 1024 * 1024 * 0.85)
        snprintf(szstr, SZSTR, "%.02LfMb", ssize / 1024 / 1024);
    else if(size > 1024 * 0.85)
        snprintf(szstr, SZSTR, "%.02LfKb", ssize / 1024);
    else
        snprintf(szstr, SZSTR, BT_SIZE_T_FMT "b", size);
 
    rv = apr_pstrdup(p, szstr);
 
    return rv;
}
