#include <time.h>
#include <apr.h>
#include <apr_pools.h>
#include <apr_strings.h>
#include <libbtutil.h>

char* bt_strfunixtime(apr_pool_t* p, const char* format, time_t unixtime) {
    char result[BT_SHORT_STRING];
    if(unixtime) {
        if(strftime(result, BT_SHORT_STRING-1, format, localtime(&unixtime))) {
            return apr_pstrdup(p, result);
        } else {
            return NULL;
        }
    } else {
        return apr_pstrdup(p, "Never");
    }
}

char* bt_strinterval(apr_pool_t* p, int interval) {
    if(!interval)
        return apr_psprintf(p, "Never");
    else if(interval < 300)
        return apr_psprintf(p, "%us", interval);
    else if(interval < 3600)
        return apr_psprintf(p, "%um", interval / 60);
    else if(interval < 86400)
        return apr_psprintf(
            p, "%uh%um", interval / 3600, (interval % 3600) / 60
        );
    else if(interval < 604800)
        return apr_psprintf(
            p, "%ud%uh%um", interval / 86400, (interval % 86400) / 3600,
            ((interval % 86400) % 3600) / 60
        );
    else
        return apr_psprintf(p, "%ud", interval / 86400);
}
