/* libc */
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
/* other libs */
#include <apr.h>
#include <apr_pools.h>
/* local */
#include <libbtutil.h>

int main(int argc, const char* const*argv) {
    apr_pool_t* pool;
    char* rv = NULL;
    apr_size_t len = 0;
    apr_status_t ret;
    char addr[BT_SHORT_STRING];
    char resource[BT_SHORT_STRING];
    apr_port_t port;

    if(argc != 2) {
        fprintf(stderr, "Usage: %s url\n", argv[0]);
        exit(1);
    }
 
    if(apr_app_initialize(&argc, &argv, NULL) != APR_SUCCESS) {
        fprintf(stderr, "apr_app_initialize() failed!\n");
        fflush(stderr);
        exit(20);
    }
 
    atexit(apr_terminate);

    if(apr_pool_initialize() != APR_SUCCESS) {
        fprintf(stderr, "apr_pool_initialize() failed!\n");
        fflush(stderr);
        exit(2);
    }
 
    if(apr_pool_create(&pool, NULL) != APR_SUCCESS) {
        fprintf(stderr, "apr_pool_create() failed!\n");
        fflush(stderr);
        exit(3);
    }
    
    if((ret = bt_url2args(argv[1], addr, &port, resource)) != APR_SUCCESS) {
        fprintf(stderr, "bt_url2args(%s) failed1\n", argv[0]);
        fflush(stderr);
        exit(4);
    }
    
    if(
        (ret = bt_http_get(pool, addr, port, resource, &rv, &len))
        != APR_SUCCESS
    ) {
        fprintf(
            stderr, "bt_http_get on %s:%i failed: %s!\n",
            addr, port,
            apr_strerror(ret, resource, sizeof(resource))
        );
        fflush(stderr);
        exit(5);
    }
    
    fwrite(rv, len, 1, stdout);
    exit(0);
}
