#include <libbtpeer.h>
#include <apr.h>
#include <apr_pools.h>
#include <apr_general.h>
#include <apr_errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "libtap/tap.h"

static void loadsave(apr_pool_t* pool) {
    bt_metainfo*        metainfo;
    apr_status_t        ret;
    char err            [255];

    if(!(ok(
        metainfo = bt_metainfo_parse(pool, "single.torrent"),
        "parsed single metainfo"
    )))
        return;

    if(ok(
        (ret = bt_metainfo_save(metainfo,pool,"test.torrent")) == APR_SUCCESS,
        "re-save torrent"
    )) {
    } else {
        diag(apr_strerror(ret, err, sizeof(err)));
    }

    if(!(ok(
        metainfo = bt_metainfo_parse(pool, "multi.torrent"),
        "parsed multi metainfo"
    )))
        return;

    if(ok(
        (ret = bt_metainfo_save(metainfo,pool,"test.torrent")) == APR_SUCCESS,
        "re-save torrent"
    )) {
    } else {
        diag(apr_strerror(ret, err, sizeof(err)));
    }
    
    apr_file_remove("test.torrent", pool);
}

static void single_torrent_test (apr_pool_t* pool) {
    const char *        tfile = "mod_bt-0.0.17.tar.gz";
    const uint64_t      tsize = 556518;
    
    btp_torrent*        torrent;
    bt_metainfo*        metainfo;
    struct stat         sb;
    
    if(!(ok(
        metainfo = bt_metainfo_parse(pool, "single.torrent"),
        "parsed metainfo"
    )))
        return;
    
    ok(metainfo->file_count == 1, "metainfo contains one file");

    if(!(ok(
        torrent = btp_torrent_create(pool, metainfo, NULL),
        "create torrent from metainfo"
    )))
        return;
    
    sprintf(torrent->destination, ".");
    
    ok(
        torrent->pieces = btp_torrent_pieces_init(torrent),
        "initialize torrent piece matrix"
    );

    ok1(btp_torrent_bytes_left(torrent) == tsize);
    
    if(!(ok(stat(tfile, &sb) == -1, "%s doesn't exist yet", tfile)))
        return;

    if(!(ok1(btp_torrent_io_create_files(torrent) == APR_SUCCESS)))
        return;
    
    if(!(
        ok(stat(tfile, &sb) == 0,
        "%s exists after btp_torrent_io_create_files",
        tfile
    )))
        return;
    
    ok(sb.st_size == 0, "%s is zero bytes", tfile);
    ok(S_ISREG(sb.st_mode), "%s is a regular file", tfile);
    
    unlink(tfile);
    
    return;
}

int main (int argc, const char* const* argv) {
    apr_pool_t *pool;
    
    if(apr_app_initialize(&argc, &argv, NULL) != APR_SUCCESS) {
        fprintf(stderr, "apr_app_initialize() failed!\n");
        fflush(stderr);
        exit(20);
    }
 
    atexit(apr_terminate);
 
    if(apr_pool_initialize() != APR_SUCCESS) {
        fprintf(stderr, "apr_pool_initialize() failed!\n");
        fflush(stderr);
        exit(2);
    }
 
    if(apr_pool_create(&pool, NULL) != APR_SUCCESS) {
        fprintf(stderr, "apr_pool_create() failed!\n");
        fflush(stderr);
        exit(3);
    }

    plan_no_plan();
    single_torrent_test(pool);
    loadsave(pool);
    exit(exit_status());
}
